<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Java Scripts --%>
<db:script src="/database/LOV.js"/>

<%-- @RAR
  <db:script src="/database/remoteBrowser/remoteBrowser.js"/>
 --%> 

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsgID" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>    

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="/database/schema/java/javasource/loadJava"/>
<%-- @RAR 
<uix:formValue name="initDir" value="/home/rreilly/temp"/>
--%>

<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <uix:subTabBar selectedIndex="0">
         <db:link textBinding="GENERAL@uixJavaSourceTypeBundle@servletRequest"
                  copyParams="target,type,cancelURL,sname,oname,otype" />
         <db:link textBinding="OPTIONS@uixJavaSourceTypeBundle@servletRequest" 
                  onClick="submitForm('foo', true, {event:'gotoValue5'})"
                  copyParams="target,type,cancelURL,sname,oname,otype" />
         <db:link textBinding="RESOLVERS@uixJavaSourceTypeBundle@servletRequest" 
                  onClick="submitForm('foo', true, {event:'gotoValue2'})"
                  copyParams="target,type,cancelURL,sname,oname,otype" />
     </uix:subTabBar>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>

    <uix:spacer height="10"/>

              <uix:rowLayout>
              <uix:contents>
                <uix:spacer width="30"/> 
              </uix:contents>                     
              <uix:contents>     
                <uix:stackLayout>            

<%-- @RAR  * * * * * * * * * * * * * * *  --%>
<%-- @RAR  Test the Remote Browser:START  --%>
<%-- @RAR  * * * * * * * * * * * * * * *  --%>
<%--

  <uix:spacer height="5"/>  
  <uix:messageLovField name="filePick" 
                       text=""
                       prompt="File"
                       columns="30"
                       shortDesc="Pick an Animal!"
                       onClick = '<%= "setTitle(\'" + DBObjectMsg.class.getName() + "\',\'" 
                                                    + DBObjectMsgID.NAME + "\');"
                                    + "setDefaultDirectory(document.forms[0].initDir.value, \'/\');"
                                    + "startFileBrowser(\'filePick\');" %>' />
  
  <uix:spacer height="5"/>
  <uix:messageLovField name="dirPick" 
                       text=""
                       prompt="Directory"
                       columns="30"
                       shortDesc="Pick a Directory!"
                       onClick = "setDefaultDirectoryToOracleHome();startDirectoryBrowser('dirPick')"/>

  <uix:spacer height="5"/>
  <uix:messageLovField name="dirFilePick" 
                       text=""
                       prompt="Directory or File"
                       columns="30"
                       shortDesc="Pick anything you want!"
                       onClick = "setDefaultDirectoryToRoot();startBrowser('dirFilePick')"/>

--%>
<%-- @RAR  * * * * * * * * * * * * * * *  --%>
<%-- @RAR  Test the Remote Browser:END    --%>
<%-- @RAR  * * * * * * * * * * * * * * *  --%>

                   
                    <%-- SCHEMA --%>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                         <uix:messagePrompt labeledNodeId="SCHEMA"
                                            promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"required="yes"/>            
                        </uix:cellFormat>
                         <uix:spacer width="5"/>   
                        <uix:cellFormat hAlign="left">
                        <uix:stackLayout>                 
                          <uix:messageLovField name="schemaName" 
                                               id="SCHEMA"
                                               shortDescBinding="SCHEMA@dbMsgs" 
                                               searchDescBinding="SCHEMA@dbMsgs" 
                                               textBinding="schemaName@objectBean@servletRequest" 
                                               onClick="startLov('schemaName','ListSchemaWithPubUser')" />  
                          <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>

                    
                    
                    <uix:rowLayout hAlign="right">
                      <uix:submitButton textBinding="GRANT_READ_PERMISSION@uixJavaSourceTypeBundle@servletRequest" name="event" value="grantPermission" />
                    </uix:rowLayout>
                    <uix:spacer height="25"/>
                    <uix:stackLayout>
                      <oem:table name="loadFileUIDataSource" 
                                 beanKey="objectBean" 
                                 destinationBinding="destination@objectBean@servletRequest"
                                 formSubmitted="true" 
                                 dataSourceProp="loadFileUIDataSource" 
                                 width="100%"
                                 summaryBinding="LOADJAVA@uixJavaSourceTypeBundle@servletRequest"
                                 copyParams="target,type,cancelURL,sname,oname,otype">

                       <uix:tableSelection>
                        <oem:singleSelection shortDescBinding="SELECT_A_VALUE@uixDBObjectBundle@servletRequest"
                                             selectedIndexBinding="selectedIndex@objectBean@servletRequest">
                          <uix:submitButton textBinding="DELETE@uixJavaSourceTypeBundle@servletRequest" name="event" value="deleteRowLoadJava"/>
                        </oem:singleSelection>
                       </uix:tableSelection>

                        <uix:footer>
                          <uix:submitButton textBinding="ADD_ANOTHER_ROW@uixJavaSourceTypeBundle@servletRequest" name="event" value="addRowLoadJava" />
                        </uix:footer>
                      </oem:table>  
                      <uix:messageText messageBinding="fileNames@errors@servletRequest" messageType="error"/>
                      
                        <uix:tip>
                         <uix:messagePrompt promptBinding="FILES_LOCATION_TIP@uixJavaSourceTypeBundle@servletRequest"/>  
                         </uix:tip>             
                        
                    </uix:stackLayout>
                    <uix:spacer width = "20"/>             
                </uix:stackLayout>            
              </uix:contents>              
            </uix:rowLayout> 


    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:submitButton textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
    <uix:submitButton textBinding="CANCEL@dbMsgs"  name="event" value="cancel" unvalidated="true"/>
    <uix:submitButton textBinding="OK@dbMsgs" name="event" value="apply"/>
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




