<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/java/javasource/options"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <uix:subTabBar selectedIndex="1">
        <db:link textBinding="GENERAL@uixJavaSourceTypeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'gotoValue3'})"
                 copyParams="target,type,cancelURL,sname,oname,otype" />
        <db:link textBinding="OPTIONS@uixJavaSourceTypeBundle@servletRequest"
                 copyParams="target,type,cancelURL,sname,oname,otype" />   
        <db:link textBinding="RESOLVERS@uixJavaSourceTypeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'gotoValue2'})"
                 copyParams="target,type,cancelURL,sname,oname,otype" />   
     </uix:subTabBar>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>
            <uix:rowLayout>
              <uix:contents>
                <uix:spacer width="30"/> 
              </uix:contents>                     
              <uix:contents>     
                <uix:stackLayout>            
  
                    <uix:checkBox name="resolveOptions" textBinding="RESOLVE_FILES@uixJavaSourceTypeBundle@servletRequest" checkedBinding="resolveOptions@objectBean@servletRequest" />                     

                   <%--andresolve(for resolveWhen) is now deprecated in 11g. According to ernest.tucker, 99.9% user case is -resolve (for resolveAfter)
                    <uix:rowLayout>
                    <uix:contents>
                      <uix:spacer width = "20"/>
                    </uix:contents>                          
                      <uix:contents>
                        <uix:stackLayout>
                          <uix:contents>                 
                            <oem:radioButton name="resolveChoiceOption" value="resolveAfter"  textBinding="RESOLVE_FILES_AFTER@uixJavaSourceTypeBundle@servletRequest"   selectedValueBinding="resolveChoiceOption@objectBean@servletRequest"/>
                            <oem:radioButton name="resolveChoiceOption" value="resolveWhen"   textBinding="RESOLVE_FILES_WHEN@uixJavaSourceTypeBundle@servletRequest"    selectedValueBinding="resolveChoiceOption@objectBean@servletRequest"/>
                          </uix:contents>
                        </uix:stackLayout>
			      </uix:contents>
			    </uix:rowLayout> 
			    --%>

			    <uix:checkBox name="forceLoadOption" textBinding="FORCE_OPTION@uixJavaSourceTypeBundle@servletRequest"  checkedBinding="forceLoadOption@objectBean@servletRequest"/>  
                    <uix:checkBox name="grantExecuteLoadOption" textBinding="GRANTEXECUTE_OPTION@uixJavaSourceTypeBundle@servletRequest"  checkedBinding="grantExecuteLoadOption@objectBean@servletRequest"/> 

                    <uix:rowLayout>             
                      <uix:spacer width="80"/>            
                      <oem:shuttle name="ObjectAttributes" leadingHeaderBinding="AVAILABLE_SCHEMAS@uixDBObjectBundle@servletRequest"
                                                           trailingHeaderBinding="SELECTED_SCHEMAS@uixDBObjectBundle@servletRequest"
                                                           size="5" reorderable="true" >
                        <uix:leading>
                          <oem:list name="availableSchemasList" 
                                    shortDescBinding="AVAILABLE_SCHEMAS@uixDBObjectBundle@servletRequest"
                                    optionsBinding="availableSchemasList@objectBean@servletRequest"/>
                        </uix:leading>
                        <uix:trailing>
                          <oem:list name="selectSchemasList" 
                                    shortDescBinding="SELECTED_SCHEMAS@uixDBObjectBundle@servletRequest"
                                    optionsBinding="selectSchemasList@objectBean@servletRequest"/>
                        </uix:trailing>
                      </oem:shuttle>                 
                    </uix:rowLayout> 

                    <uix:checkBox name="createSynonymLoadOption" textBinding="CREATESYNONYM_OPTION@uixJavaSourceTypeBundle@servletRequest" checkedBinding="createSynonymLoadOption@objectBean@servletRequest"/> 
                    <uix:rowLayout>
                      <uix:contents> 
                        <uix:checkBox name="otherOptionsLoadOption"  
                                      textBinding="OTHEROPTIONS_OPTION@uixJavaSourceTypeBundle@servletRequest"  
                                      checkedBinding="otherOptionsLoadOption@objectBean@servletRequest"/>  
                        <uix:spacer width = "5"/>
                        <uix:textInput name="otherOptionsLoadOptionInput"  
                                       textBinding="otherOptionsLoadOptionInput@objectBean@servletRequest"
                                       shortDescBinding="OTHEROPTIONS_OPTION@uixJavaSourceTypeBundle@servletRequest"/>
                      </uix:contents>
                    </uix:rowLayout>

                    <uix:spacer width = "20"/>
                                             
                </uix:stackLayout>            
              </uix:contents>              
            </uix:rowLayout> 


    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
     <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" name="event" value="showSql"/>
     <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancel" unvalidated="true"/>
     <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="apply"/>
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




