<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/java/resolversPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
   <uix:subTabs>
            <uix:switcher  childNameBinding="loadMode@objectBean@servletRequest">
              <uix:case name="true">
                <uix:subTabBar selectedIndex="2">
                  <uix:contents>
                    <db:link textBinding="GENERAL@uixJavaSourceTypeBundle@servletRequest"
                             onClick="submitForm('foo', true, {event:'gotoValue3'})"
                             copyParams="target,type,cancelURL,sname,oname,otype"/>
                    <db:link textBinding="OPTIONS@uixJavaSourceTypeBundle@servletRequest" 
                             onClick="submitForm('foo', true, {event:'gotoValue5'})"
                             copyParams="target,type,cancelURL,sname,oname,otype"/>
                    <db:link textBinding="RESOLVERS@uixJavaSourceTypeBundle@servletRequest"
                             copyParams="target,type,cancelURL,sname,oname,otype"/>
                  </uix:contents>
                </uix:subTabBar>
              </uix:case>
              <uix:case name="false">
                <uix:subTabBar selectedIndex="1">
                  <uix:contents>
                    <db:link textBinding="GENERAL@uixJavaSourceTypeBundle@servletRequest"
                             onClick="submitForm('foo', true, {event:'gotoValue1'})"
                             copyParams="target,type,cancelURL,sname,oname,otype"/>
                    <db:link textBinding="RESOLVERS@uixJavaSourceTypeBundle@servletRequest"
                             copyParams="target,type,cancelURL,sname,oname,otype"/>
                  </uix:contents>
                </uix:subTabBar>
              </uix:case>
            </uix:switcher>
    </uix:subTabs>


    <%-- START: TAB CONTENTS starts here --%>

          <uix:contents>
		        <uix:spacer height="10"/>

		
        <uix:rowLayout>
          <uix:contents>  
            <uix:spacer width="30"/>    
            <uix:stackLayout>                      
              <uix:tableLayout cellSpacing="5">
                <oem:table name="resolverUI"
                           beanKey="resolverBean"
                           formSubmitted="true"
                           dataSourceProp="resolverUI"
                           width="100%"
                           summaryBinding="RESOLVERS@uixJavaSourceTypeBundle@servletRequest"
                           alternateTextBinding="NO_ITEMS_FOUND@dbMsgs">
                           <%--copyParams="target,type,cancelURL,sname,oname,otype"--%>
                           <%--copyParams break the lovField table cells, it appends the params to the javascript --%> 
           <uix:tableSelection>
              <oem:singleSelection shortDescBinding="SELECT_A_VALUE@uixDBObjectBundle@servletRequest"
                                   selectedIndexBinding="selectedIndex@resolverBean@servletRequest">
                <uix:submitButton textBinding="DELETE@uixJavaSourceTypeBundle@servletRequest" name="event" value="deleteRow"/>
	      </oem:singleSelection>
           </uix:tableSelection>
           
           <uix:footer>
            <uix:submitButton textBinding="ADD_ANOTHER_ROW@uixJavaSourceTypeBundle@servletRequest" name="event" value="addRow" />
          </uix:footer>
          </oem:table>     
         <uix:spacer height="10"/>                                           
              </uix:tableLayout>
            </uix:stackLayout>            
          </uix:contents>              
        </uix:rowLayout> 
      </uix:contents>



    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%--  Buttons --%>
  <uix:pageButtons>

        <uix:pageButtonBar>
          
            <uix:switcher childNameBinding="loadMode@objectBean@servletRequest">
              <uix:case name="true">
                <uix:flowLayout>
                  <uix:submitButton textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                  <uix:spacer width="5"/>
                  <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancel" unvalidated="true"/>
                  <uix:spacer width="5"/>
                  <uix:submitButton textBinding="OK@dbMsgs" name="event" value="apply"/>
                </uix:flowLayout>
              </uix:case>
              <uix:case name="false">
                <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="true">
                    <uix:flowLayout>
                      <uix:submitButton textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                      <uix:spacer width="5"/>
                      <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancel" unvalidated="true"/>
                      <uix:spacer width="5"/>
                      <uix:submitButton textBinding="OK@dbMsgs" name="event" value="apply"/>
                    </uix:flowLayout>
                  </uix:case>
                  <uix:case name="false">
                    <uix:flowLayout>
                      <uix:submitButton textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                      <uix:spacer width="5"/>
                      <uix:submitButton textBinding="REVERT@dbMsgs" name="event" value="revert" unvalidated="true"/>
                      <uix:spacer width="5"/>
                      <uix:submitButton textBinding="APPLY@dbMsgs" name="event" value="apply"/>
                    </uix:flowLayout>
                  </uix:case>
                </uix:switcher>
              </uix:case>
            </uix:switcher>
            <%-- SWITCHER --%>


        </uix:pageButtonBar>

  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




