<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:head>
<db:script src="/database/utils.js"/>
<db:script src="/cabo/jsLibs/TableProxy.js"/> 
  <script>
    function lovSelect(lovField)
    {
      var proxy = new TableProxy('schemaDataSource');
      var selectedIndex = proxy.getSelectedRow();
      if (selectedIndex >= 0)
      {
        var selectedElement = proxy.getFormElement('Hidden', selectedIndex);
        lovField.value = selectedElement.value;
        window.close();
      }
    }
  </script>
</uix:head>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>


<uix:document>
<%-- HTML Page Title --%>
<uix:head titleBinding="SEARCH_SELECT_SCHEMA_NAME@uixDBObjectBundle@servletRequest"/>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/java/selectResolverSchemaPage"/>
<uix:formValue name="selectResolverSchemaDestination" valueBinding="selectResolverSchemaDestination@servletRequest"/>
<uix:pageLayout titleBinding="SEARCH_SELECT_SCHEMA_NAME@uixDBObjectBundle@servletRequest">

    <%-- START: TAB CONTENTS starts here --%>

          <uix:tableLayout cellSpacing="2">
            <uix:rowLayout hAlign="right">
              <uix:cellFormat>
                <uix:spacer width="20"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer width="5"/>
	          </uix:cellFormat>
	        </uix:rowLayout>
	        <uix:rowLayout>
	          <uix:cellFormat>
                <uix:spacer width="20"/>
              </uix:cellFormat>
              <uix:cellFormat>
	            <uix:stackLayout>
	              <uix:header textBinding="SEARCH@uixDBObjectBundle@servletRequest">
	                <uix:styledText textBinding="TO_FIND_ITEM@uixDBObjectBundle@servletRequest"/>
	                <uix:rowLayout>
	                  <uix:messagePrompt labeledNodeId="schemaSearchCriteria"
                                             promptBinding="SEARCH_FOR_SCHEMA@uixDBObjectBundle@servletRequest"/>
	                  <uix:spacer width="10"/>
	                  <uix:textInput id="schemaSearchCriteria"
                                         name="schemaSearchCriteria" 
                                         textBinding="schemaSearchCriteria@objectBean@servletRequest"/>
	                  <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" name="event" value="changeResolverSchemaSearchCriteria"/>
	                </uix:rowLayout>
	              </uix:header>
	            </uix:stackLayout>
	          </uix:cellFormat>
	        </uix:rowLayout>
	        <uix:rowLayout>
	          <uix:cellFormat>
                <uix:spacer width="20"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:stackLayout>
	              <uix:header textBinding="RESULTS@uixDBObjectBundle@servletRequest">
                    <oem:table name="schemaDataSource" 
                               beanKey="objectBean" 
                               blockSize="10"
                               destinationBinding="destination@objectBean@servletRequest" 
                               formSubmitted="true"
                               dataSourceProp="schemaDataSource" 
                               width="90%" 
                               alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                               summaryBinding="RESULTS@uixDBObjectBundle@servletRequest"
                               copyParams="target,type,cancelURL,sname,oname,otype">
                      <uix:tableSelection>
                      <oem:singleSelection shortDescBinding="SELECT_A_VALUE@uixDBObjectBundle@servletRequest"
                                           selectedIndexBinding="selectedIndex@objectBean@servletRequest"/>
                      </uix:tableSelection>
                    </oem:table>
	              </uix:header>
	            </uix:stackLayout>
	          </uix:cellFormat>
	        </uix:rowLayout>
	      </uix:tableLayout>


    <%-- END: TAB CONTENTS ends here --%>   
        

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest" destination="javascript:self.close()"/>
    <uix:button textBinding="SELECT@uixDBObjectBundle@servletRequest" destinationBinding="selectResolverSchemaDestination@servletRequest"/> 
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:document>

<%-- END: Content --%> 




