<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%--
  -- Page:       multiSelectSchemaObjectPage.jsp
  -- Controller: db/adm/schm/*Controller.java - used by several controllers
  --
  -- Description: LOV that lets users search and select multiple schema.object combination.
  --              An example of this being used can be seen by looking at the 
  --              Table object's Add Foreign Key Constriant page, this is the 
  --              LOV that allows the user to select a referenced table.
  --%>
  
<uix:renderingContext id="renderingContext">

<uix:bundle name="DBObjectBundle"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
            
<oem:setURLEncoder id="renderingContext"/>
 <uix:document>

   <uix:metaContainer>
     <uix:head titleBinding="SEARCH_AND_SELECT_HEADER@DBObjectBundle"/>
 
     <script language="JavaScript" >
       <%@ include file="/database/utils.js"%>
     </script>
     <script language="JavaScript" >
       <%@ include file="/cabo/jsLibs/TableProxy.js" %>         
     </script>
     <script>

       function removePrevSelected()
       {
         var proxy = new TableProxy('schemaObjectUIDataSource');

         for(var m=0; m < proxy.length; m++)
         {
           var element = proxy.getFormElement('Object', m);            
           var schmelement = element.value;
 
           // Remove from selectedObjectNames list if found in case
           // user unchecks it.  If user keeps selection, it will be
           // added back.
           if (document.foo.selectedObjectNames.value.indexOf(schmelement) != -1)
           {
             var i = document.foo.selectedObjectNames.value.indexOf(schmelement);              
             var tmpstr = document.foo.selectedObjectNames.value.substring(0,i-1);              
             var tmpstr2 = document.foo.selectedObjectNames.value.substring(i + schmelement.length + 1);

             if (tmpstr2.length > 0)
             {
               document.foo.selectedObjectNames.value = tmpstr + tmpstr2;
             }
              
           }
         }
       }


       function lovSelect(lovField)
       { 
         // This is needed to allow deselection when navigating
         removePrevSelected();

         var proxy = new TableProxy('schemaObjectUIDataSource');
         var selectedItems = proxy.getSelectedRows();
         var objs = "";
        
         if (selectedItems.length >= 1)
         {
           for(var i=0; i < selectedItems.length; i++)
           {
             var selectedIndex = selectedItems[i];
             var selectedElement = proxy.getFormElement('Object', selectedIndex);          
             // First time
             if (objs == "")
             {
               // Only add current selection if we don't already have that
               // value
               if (lovField.value.indexOf(selectedElement.value) == -1 && 
                   document.foo.selectedObjectNames.value.indexOf(selectedElement.value) == -1)
               {
                 objs =  selectedElement.value;
               }
             }
             else
             {
               // Only add current selection if we don't already have that
               // value
               if (lovField.value.indexOf(selectedElement.value) == -1 && 
                   document.foo.selectedObjectNames.value.indexOf(selectedElement.value) == -1 && 
                   objs.indexOf(selectedElement.value) == -1)
               {
                 objs = objs + ", " +  selectedElement.value;
               }
             } 
           }
         } 

         // Build fresh return values list from 3 sources: new selections
         // (objs), previous LOV field values (lovField) and
         // selections from previous pages in LOV popup (selectedObjectNames)
         var retVals = "";
 
         // 1st source: selectedObjectNames
         var tmpRes = document.foo.selectedObjectNames.value;
         while (tmpRes.indexOf(",") != -1)
         {
           var i = tmpRes.indexOf(",");                    
           var oneVal = tmpRes.substring(0, i);

           while (oneVal.charAt(0) == " ")
           {
             oneVal = oneVal.substring(1);
           }

           if (retVals.indexOf(oneVal) == -1)
           {
             if (retVals == "")
             {
               retVals = oneVal;
             }
             else
             {
               retVals = retVals + ", " + oneVal;
             }
           }              
           tmpRes = tmpRes.substring(i+1);
         }

         // Handle last value
         if (retVals.indexOf(tmpRes) == -1)
         {
           while (tmpRes.charAt(0) == " ")
           {
             tmpRes = tmpRes.substring(1);
           }
           if (retVals == "")
           {
             retVals = tmpRes;
           }
           else
           {
             retVals = retVals + ", " + tmpRes;
           }
         }       

         // 2nd source: lovField
         tmpRes = lovField.value;
         while (tmpRes.indexOf(",") != -1)
         {
           var i = tmpRes.indexOf(",");                    
           var oneVal = tmpRes.substring(0, i);

           while (oneVal.charAt(0) == " ")
           {
             oneVal = oneVal.substring(1);
           }

           if (retVals.indexOf(oneVal) == -1)
           {
             if (retVals == "")
             {
               retVals = oneVal;
             }
             else
             {
               retVals = retVals + ", " + oneVal;
             }
           }              
           tmpRes = tmpRes.substring(i+1);
         }
         // Handle last value
         if (retVals.indexOf(tmpRes) == -1)
         {
           while (tmpRes.charAt(0) == " ")
           {
             tmpRes = tmpRes.substring(1);
           }
           if (retVals == "")
           {
             retVals = tmpRes;
           }
           else
           {
             retVals = retVals + ", " + tmpRes;
           }
         }       

         // Build final list, adding new selections at the end
         if (retVals.length > 0)
         {
           if (objs.length > 0)
           {
             lovField.value = retVals + ", " + objs; 
           }
           else
           {
             lovField.value = retVals; 
           }
         }
         else
         {
           lovField.value = objs; 
         }

         document.foo.submit();
         window.close();
       }
     </script>

   </uix:metaContainer>


<uix:body>
  <uix:contents>
     <db:form
      name="foo" 
      method="post"
      destinationBinding="destination@objectBean@servletRequest" copyParams="target,type,cancelURL,multipleselect,selectType">


   <uix:formValue name="pageName" value="/database/schema/multiSelectSchemaObjectPage" />
      <uix:formValue name="selectedObjectNames" valueBinding="selectedObjectNames@objectBean@servletRequest" />

      <uix:pageLayout titleBinding="SEARCH_AND_SELECT_HEADER@DBObjectBundle" >
       <uix:header  textBinding="selectSchemaObjectHeader@objectBean@servletRequest">
          <uix:tableLayout cellSpacing="2">

              <%-- Search Criteria and Instruction --%>
              <uix:rowLayout>
              <uix:header textBinding="SEARCH@DBObjectBundle" >
                <uix:rowLayout>
                  <uix:tableLayout cellSpacing="4">
                    <uix:rowLayout hAlign="left">

                      <uix:cellFormat vAlign="top">
                        <uix:stackLayout>
                          <uix:styledText labeledNodeId="searchSchemaName"
                                          textBinding="SCHEMA_NAME_COLON@DBObjectBundle"/>
                          <uix:textInput id="searchSchemaName"
                                         name="searchSchemaName" 
                                         textBinding="searchSchemaName@objectBean@servletRequest"/> 
                        </uix:stackLayout> 
                      </uix:cellFormat>
                      <uix:cellFormat vAlign="top">
                        <uix:stackLayout>
                          <uix:styledText labeledNodeId="searchObjectName"
                                          textBinding="objectColumnText@objectBean@servletRequest" />
                          <uix:rowLayout>
                            <uix:textInput id="searchObjectName"
                                           name="searchObjectName" 
                                           textBinding="searchObjectName@objectBean@servletRequest"/> 
                            <uix:submitButton textBinding="GO@DBObjectBundle"
                                              name="event" value="searchSchemaObject"/> 
                          </uix:rowLayout>
                        </uix:stackLayout> 
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:rowLayout>
              </uix:header>
            </uix:rowLayout>
            <%-- End Search Criteria and Instruction --%>

            <uix:rowLayout>
              <uix:switcher childNameBinding="showSearchResults@objectBean@servletRequest">
                <uix:case name="true">
                  <uix:header textBinding="RESULTS@DBObjectBundle" >
                    <uix:rowLayout width="80%">    
                    <oem:table name="schemaObjectUIDataSource"  blockSize="10"
                    destination="destination" 
                    formSubmitted="true"
                    dataSourceProp="schemaObjectUIDataSource" 
                    alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle"
                    summaryBinding="RESULTS@DBObjectBundle"
                    width="100%" >                   
                   <uix:tableSelection>
                      <uix:multipleSelection shortDescBinding="SELECT_A_VALUE@DBObjectBundle"                                                                       selectionBinding="selection@objectBean@servletRequest"
                     selectedBinding="selected"/>
                     </uix:tableSelection>
   
                    </oem:table>

                    </uix:rowLayout>
                  </uix:header>
                </uix:case>
              </uix:switcher>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>

     <uix:pageButtons>  
          <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@DBObjectBundle"  destination="javascript:self.close()"/>
            <uix:button textBinding="SELECT@DBObjectBundle" destinationBinding="selectSchemaObjectDestination@servletRequest" />
          </uix:pageButtonBar>
     </uix:pageButtons>  
</uix:pageLayout>
      </db:form>
    </uix:contents>
  </uix:body>
  </uix:document>
</uix:renderingContext>
