<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%--
  -- Page:       multiSelectSchemaPage.jsp
  -- Controller: db/util/sqlaccess/SqlAccessController.java
  --
  -- Description: LOV that lets users search and select multiple 
  --              schemas (users)
  --%>
  
<uix:renderingContext id="renderingContext">
<uix:bundle name="DBObjectBundle"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="UsersBundle"
            class="oracle.sysman.db.rsc.sec.UserMsg"/>            

<oem:setURLEncoder id="renderingContext"/>
 <uix:document>

   <uix:metaContainer>
     <uix:head titleBinding="SEARCH_AND_SELECT_HEADER@DBObjectBundle"/>
 
     <script language="JavaScript" >
       <%@ include file="/database/utils.js"%>
     </script>
     <script language="JavaScript" >
       <%@ include file="/cabo/jsLibs/TableProxy.js" %>         
     </script>
     <script>

       function removePrevSelected()
       {
         var proxy = new TableProxy('schemaDataSource');

         for(var m=0; m < proxy.length; m++)
         {
           var element = proxy.getFormElement('Hidden', m);            
           var schmelement = element.value;
 
           // Remove from selectedObjectNames list if found in case
           // user unchecks it.  If user keeps selection, it will be
           // added back.
           if (document.foo.selectedObjectNames.value.indexOf(schmelement) != -1)
           {
             var i = document.foo.selectedObjectNames.value.indexOf(schmelement);              
             var tmpstr = document.foo.selectedObjectNames.value.substring(0,i-1);              
             var tmpstr2 = document.foo.selectedObjectNames.value.substring(i + schmelement.length + 1);

             if (tmpstr2.length > 0)
             {
               document.foo.selectedObjectNames.value = tmpstr + "," + tmpstr2;
             }
             else
             {
               document.foo.selectedObjectNames.value = tmpstr;
             }              
           }
         }
       }

       function lovSelect(lovField)
       { 
         // This is needed to allow deselection when navigating
         removePrevSelected();

         var proxy = new TableProxy('schemaDataSource');
         var selectedItems = proxy.getSelectedRows();
         var objs = "";
        
         if (selectedItems.length >= 1)
         {
           for(var i=0; i < selectedItems.length; i++)
           {
             var selectedIndex = selectedItems[i];
             var selectedElement = proxy.getFormElement('Hidden', selectedIndex);          
             // First time
             if (objs == "")
             {
               // Only add current selection if we don't already have that
               // value
               if (lovField.value.indexOf(selectedElement.value) == -1 && 
                   document.foo.selectedObjectNames.value.indexOf(selectedElement.value) == -1)
               {
                 objs =  selectedElement.value;
               }
             }
             else
             {
               // Only add current selection if we don't already have that
               // value
               if (lovField.value.indexOf(selectedElement.value) == -1 && 
                   document.foo.selectedObjectNames.value.indexOf(selectedElement.value) == -1 && 
                   objs.indexOf(selectedElement.value) == -1)
               {
                 objs = objs + ", " +  selectedElement.value;
               }
             } 
           }
         } 

         // Build fresh return values list from 3 sources: new selections
         // (objs), previous LOV field values (lovField) and
         // selections from previous pages in LOV popup (selectedObjectNames)
         var retVals = "";
 
         // 1st source: selectedObjectNames
         var tmpRes = document.foo.selectedObjectNames.value;
         while (tmpRes.indexOf(",") != -1)
         {
           var i = tmpRes.indexOf(",");                    
           var oneVal = tmpRes.substring(0, i);

           while (oneVal.charAt(0) == " ")
           {
             oneVal = oneVal.substring(1);
           }

           if (retVals.indexOf(oneVal) == -1)
           {
             if (retVals == "")
             {
               retVals = oneVal;
             }
             else
             {
               retVals = retVals + ", " + oneVal;
             }
           }              
           tmpRes = tmpRes.substring(i+1);
         }

         // Handle last value
         if (retVals.indexOf(tmpRes) == -1)
         {
           while (tmpRes.charAt(0) == " ")
           {
             tmpRes = tmpRes.substring(1);
           }
           if (retVals == "")
           {
             retVals = tmpRes;
           }
           else
           {
             retVals = retVals + ", " + tmpRes;
           }
         }       

         // 2nd source: lovField
         tmpRes = lovField.value;
         while (tmpRes.indexOf(",") != -1)
         {
           var i = tmpRes.indexOf(",");                    
           var oneVal = tmpRes.substring(0, i);

           while (oneVal.charAt(0) == " ")
           {
             oneVal = oneVal.substring(1);
           }

           if (retVals.indexOf(oneVal) == -1)
           {
             if (retVals == "")
             {
               retVals = oneVal;
             }
             else
             {
               retVals = retVals + ", " + oneVal;
             }
           }              
           tmpRes = tmpRes.substring(i+1);
         }
         // Handle last value
         if (retVals.indexOf(tmpRes) == -1)
         {
           while (tmpRes.charAt(0) == " ")
           {
             tmpRes = tmpRes.substring(1);
           }
           if (retVals == "")
           {
             retVals = tmpRes;
           }
           else
           {
             retVals = retVals + ", " + tmpRes;
           }
         }       

         // Build final list, adding new selections at the end
         if (retVals.length > 0)
         {
           if (objs.length > 0)
           {
             lovField.value = retVals + ", " + objs; 
           }
           else
           {
             lovField.value = retVals; 
           }
         }
         else
         {
           lovField.value = objs; 
         }

         document.foo.submit();
         window.close();
       }

       function addChecks()
       {
         var proxy = new TableProxy('schemaDataSource');
 
         for(var m=0; m < proxy.length; m++)
         {
           var element = proxy.getFormElement('Hidden', m);            
           var oneSchema = element.value;
 
           // Check checkbox if user already selected this value
           if (document.foo.selectedObjectNames.value.indexOf(oneSchema) != -1)
           {
             var selected = proxy.getFormElement('selected', m);
             selected.checked=true;
           }	
         }
       }

     </script>

   </uix:metaContainer>


<uix:body onLoad="addChecks()">
  <uix:contents>
     <db:form
      name="foo" 
      method="post"
      destinationBinding="destination@objectBean@servletRequest" 
      copyParams="target,type,cancelURL,multipleselect">


   <uix:formValue name="pageName" 
                  value="/database/schema/multiSelectSchemaPage" />
      <uix:formValue name="selectedObjectNames" 
                     valueBinding="selectedSchemaNames@objectBean@servletRequest" />

      <uix:pageLayout titleBinding="SEARCH_AND_SELECT_HEADER@DBObjectBundle" >
       <uix:header  textBinding="SELUSERS@UsersBundle">
          <uix:tableLayout cellSpacing="2">

              <%-- Search Criteria --%>
              <uix:rowLayout>
              <uix:header textBinding="SEARCH@DBObjectBundle" >
                <uix:rowLayout>
                            <uix:messageTextInput id="schemaSearchCriteria"
                                           name="schemaSearchCriteria" 
                                           promptBinding="USERS@DBObjectBundle"
                                           textBinding="schemaSearchCriteria@objectBean@servletRequest"/> 
                            <uix:submitButton textBinding="GO@DBObjectBundle"
                                              name="event" value="changeSchemaSearchCriteria"/> 
                </uix:rowLayout>
              </uix:header>
            </uix:rowLayout>
            <%-- End Search Criteria --%>

            <uix:rowLayout>
              <uix:switcher childNameBinding="showSearchResults@objectBean@servletRequest">
                <uix:case name="true">
                  <uix:header textBinding="RESULTS@DBObjectBundle" >
                    <uix:rowLayout width="80%">    
                    <oem:table name="schemaDataSource" 
                          blockSize="10"
                          formSubmitted="true"
                          dataSourceProp="schemaDataSource" 
                          alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle"
                          summaryBinding="RESULTS@DBObjectBundle"
                          width="100%" >                   
                   <uix:tableSelection>
                      <uix:multipleSelection shortDescBinding="SELECT_A_VALUE@DBObjectBundle" />
                     </uix:tableSelection>
   
                    </oem:table>

                    </uix:rowLayout>
                  </uix:header>
                </uix:case>
              </uix:switcher>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>

     <uix:pageButtons>  
          <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@DBObjectBundle"  destination="javascript:self.close()"/>
           <uix:button textBinding="SELECT@DBObjectBundle" destinationBinding="selectSchemaDestination@servletRequest"/>
          </uix:pageButtonBar>
     </uix:pageButtons>  
</uix:pageLayout>
      </db:form>
    </uix:contents>
  </uix:body>
  </uix:document>
</uix:renderingContext>
