<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="explainHeader@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="mviewForm" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/mview/explainMV"/>

<uix:pageLayout titleBinding="explainHeader@objectBean@servletRequest"> 

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
       <uix:tableLayout cellSpacing="10">
        <uix:rowLayout>
          <uix:cellFormat hAlign="left">
            <uix:styledText styleClass="oraInstructionText" textBinding="MVIEW_EXPLAIN_INST@uixMViewBundle@servletRequest"/>
             </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat hAlign="left">
              <oem:table name="explainMVUI"
                         beanKey="objectBean"
                         dataSourceProp="explainMVUI"
                         width="100%" 
                         summaryBinding="EXPLAIN_NEW_MVIEW_HEADER@uixMViewBundle@servletRequest"
                         copyParams="target,type,cancelURL,sname,oname,otype"/>
          </uix:cellFormat>
        </uix:rowLayout>

     </uix:tableLayout>

    <%-- END: TAB CONTENTS ends here --%>   
        

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>

    <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="okFromExplainMV"/>

  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




