<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
   <uix:bundle name="msg" class="oracle.sysman.db.rsc.schm.MViewMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<uix:metaContainer>
  <uix:head titleBinding="explainRewriteHeader@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>
<db:form name="mviewForm" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/mview/explainMV"/>

<uix:pageLayout titleBinding="explainRewriteHeader@objectBean@servletRequest"> 
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

<uix:tableLayout width="100%" cellSpacing="5">
  <uix:rowLayout>
    <uix:cellFormat hAlign="right" vAlign="top">
      <uix:spacer height="10"/>
    </uix:cellFormat>
    <uix:cellFormat hAlign="left">
      <uix:styledText textBinding="EXPLAIN_REWRITE_TEXT1@uixMViewBundle@servletRequest" styleClass="OraInstructionText" />
      <uix:tableLayout width="100%" cellSpacing="5">
        <uix:spacer height="10"/>
        <uix:rowLayout>
          <uix:cellFormat hAlign="right" vAlign="top">
            <uix:messagePrompt promptBinding="EXPLAIN_SQL_TEXT@uixMViewBundle@servletRequest"
                                    labeledNodeId="ViewLabel" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left">
            <uix:textInput name="sqlText" id="ViewLabel"
                                 textBinding="sqlText@objectBean@servletRequest"
                                 columns="120"
                                 rows="10" />
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat hAlign="right" vAlign="top">
            <uix:spacer height="10"/>
          </uix:cellFormat>
          <uix:cellFormat hAlign="left">
            <uix:submitButton textBinding="EVALUATE@msg" name="event" value="onExplainRewrite"/>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>
      <uix:separator />
      <uix:tableLayout width="100%" cellSpacing="5" renderedBinding="isVersionEqualOrHigher10g2@objectBean@servletRequest">
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:spacer height="10"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" vAlign="top">
                <uix:messageStyledText promptBinding="QUERY_REWRITABLE@msg"
                    shortDescBinding="QUERY_REWRITABLE@msg"
                    textBinding="explainRewriteable@objectBean@servletRequest" 
                    contentStyleClass="OraDataText" />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="10"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left" vAlign="top">
                <uix:messageStyledText promptBinding="MV_QUERY_REWRITTEN@msg" vAlign="top"
                    shortDescBinding="MV_QUERY_REWRITTEN@msg"
                    textBinding="explainRewriteMaterializedView@objectBean@servletRequest" 
                    contentStyleClass="OraDataText" />
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
      <uix:styledText textBinding="EXPLAIN_REWRITE_TEXT2@uixMViewBundle@servletRequest" styleClass="OraInstructionText" />
      <uix:table name="ExplainRewrite"
                 width="100%"
                 formSubmitted="true"
                 tableDataBinding="tableData@objectBean@servletRequest"
                 maxValueBinding="length@objectBean@servletRequest"
                 valueBinding="startIndex@objectBean@servletRequest"
                 blockSizeBinding="blockSize@objectBean@servletRequest"
                 showAll="yes"
                 summaryBinding="EXPLAIN_REWRITE_TEXT2@uixMViewBundle@servletRequest"
                 alternateTextBinding="NO_DATA@msg">
          <uix:tableFormat tableBanding="rowBanding"/>
         
          <%-- Table column name column --%>
          <uix:column renderedBinding="isShowExplainRewrittenColumn@objectBean@servletRequest">
            <uix:columnHeader>
              <uix:styledText textBinding="QUERY_REWRITABLE@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="explainRewriteable@objectBean@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="MESSAGE@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:contents>
              <uix:styledText textBinding="explainRewriteMessage@objectBean@servletRequest"/>
              <uix:styledText textBinding="explainRewriteRewrittenText@objectBean@servletRequest" renderedBinding="isShowExplainRewriteRewrittenText@objectBean@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column renderedBinding="isVersionEqualOrHigher10i@objectBean@servletRequest">
            <uix:columnHeader>
              <uix:styledText textBinding="ORIGINAL_COST@msg"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="numberFormat"/>
            <uix:contents>
              <uix:styledText textBinding="explainRewriteOrginalCost@objectBean@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column renderedBinding="isVersionEqualOrHigher10i@objectBean@servletRequest">
            <uix:columnHeader>
              <uix:styledText textBinding="REWRITTEN_COST@msg"/>
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="explainRewriteRewrittenCost@objectBean@servletRequest"/>
            </uix:contents>
            <uix:columnFormat columnDataFormat="numberFormat"/>
          </uix:column>
          <uix:column renderedBinding="isVersionEqualOrHigher10g2@objectBean@servletRequest">
            <uix:columnHeader>
              <uix:styledText textBinding="QUERY_BLOCK@msg"/>
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="queryBlockNumber@objectBean@servletRequest"/>
            </uix:contents>
            <uix:columnFormat columnDataFormat="numberFormat"/>
          </uix:column>
      </uix:table>
    
    </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>
   <uix:pageButtons>
  <uix:pageButtonBar>

    <uix:submitButton textBinding="RETURN@uixDBObjectBundle@servletRequest" name="event" value="cancel"/>

  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




