<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="mvMsgs"
              class="oracle.sysman.db.rsc.schm.MViewMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="mviewForm"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/mview/generalPage"/>
<uix:formValue name="s_name" valueBinding="schemaName@objectBean@servletRequest"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest"> 

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <uix:pageStatus>
    <uix:switcher childNameBinding="creating@objectBean@servletRequest">
      <uix:case name="true">
        <uix:tableLayout renderedBinding="versionEqualOrHigher10i@objectBean@servletRequest">
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:styledText textBinding="GET_RECOMMENDATION_INST@mvMsgs" styleClass="OraInstructionText"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:case>
    </uix:switcher>
  </uix:pageStatus>

  <uix:subTabLayout>
    
    <%-- SubTabs  --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/mview/subTabsInclude.jsp" />
      <uix:ref refID="mviewSubTabsInclude" />
    </uix:subTabs>
    <%-- SubTabs --%>


    <%-- START: TAB CONTENTS starts here --%>


        <uix:switcher childNameBinding="creating@objectBean@servletRequest">
        <uix:case name="true">
          <%-- for create page --%>
          <uix:stackLayout>

              <uix:tableLayout cellSpacing="5" hAlign="center" width="75%">
       
                <%-- object name --%>
                  <uix:switcher childNameBinding="showNameInput@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" width="120">
                          <uix:messagePrompt labeledNodeId="objectName"
                                             promptBinding="NAME@dbMsgs" 
                                             required="yes"/>
                        </uix:cellFormat> 
                        <uix:stackLayout>
                          <uix:textInput id="objectName"
                                         name="objectName" 
                                         textBinding="objectName@objectBean@servletRequest"/> 
                          <uix:messageText messageBinding="objectName@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>               				 
                      </uix:rowLayout>
                    </uix:case> 
                  </uix:switcher> 
                
                  <%-- schema name --%>
                  <uix:switcher childNameBinding="showNameInput@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" width="120">
                          <uix:messagePrompt labeledNodeId="schema" promptBinding="SCHEMA@dbMsgs" required="yes"/>          
                        </uix:cellFormat> 
                        <uix:stackLayout>               
                          <uix:messageLovField name="schemaName" 
                                               id="schema"
                                               shortDescBinding="SCHEMA@dbMsgs" 
                                               searchDescBinding="SCHEMA@dbMsgs" 
                                               textBinding="schemaName@objectBean@servletRequest" 
                                               onClick="startLov('schemaName','ListSchema')"/>
                          <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/> 
                        </uix:stackLayout>
                      </uix:rowLayout>
                    </uix:case> 
                  </uix:switcher> 

                <%-- tablespace name --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="120">
                    <uix:messagePrompt labeledNodeId="tbsp" promptBinding="TABLESPACE@dbMsgs"/>          
                  </uix:cellFormat> 
                  <uix:stackLayout>               
                    <uix:messageLovField name="tablespaceName" 
                                         id="tbsp"
                                         shortDescBinding="TABLESPACE@dbMsgs" 
                                         searchDescBinding="TABLESPACE@dbMsgs" 
                                         textBinding="tablespaceName@objectBean@servletRequest" 
                                         onClick="startLov('tablespaceName','ListTablespaceAll')"
                                         disabledBinding="fromExistingTable@objectBean@servletRequest"/>
                    <uix:messageText messageBinding="tablespaceName@errors@servletRequest" messageType="error"/> 
                 </uix:stackLayout>
               </uix:rowLayout>

             </uix:tableLayout>
           

         <%-- use existing table--%>
         <uix:header textBinding="MATERIALIZED_VIEW_DEFINITION@mvMsgs" size="1">
           <uix:tableLayout cellSpacing="5">
             <uix:rowLayout>
               <uix:cellFormat hAlign="left">
                 <uix:checkBox name="queryRewrite" checkedBinding="queryRewrite@objectBean@servletRequest" 
                               textBinding="MVIEW_ENABLE_QUERY_REWRITE@mvMsgs"/>
               </uix:cellFormat>
             </uix:rowLayout>
             <uix:rowLayout>
               <uix:cellFormat hAlign="left">
                 <uix:checkBox name="updatable" checkedBinding="updatable@objectBean@servletRequest" 
                               textBinding="MVIEW_MAKE_UPDATABLE@mvMsgs"/>
               </uix:cellFormat>
             </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="left">
                 <uix:tableLayout cellSpacing="0">
                   <uix:rowLayout>
                     <uix:cellFormat hAlign="left" vAlign="top">
                       <uix:checkBox name="fromExistingTable" 
                                     shortDescBinding="MVIEW_BUILD_FROM_EXISTING_TABLE@mvMsgs"
                                     checkedBinding="fromExistingTable@objectBean@servletRequest"
                                     onClick="submitForm('mviewForm', true, {event:'buildFromExistingTable'})"/>
                     </uix:cellFormat>
                     <uix:cellFormat hAlign="left" vAlign="top">
                       <uix:stackLayout>
                         <uix:styledText styleClass="OraInstructionText" 
                                         textBinding="MVIEW_BUILD_FROM_EXISTING_TABLE@mvMsgs" />
                           <uix:switcher childNameBinding="fromExistingTable@objectBean@servletRequest">
                             <uix:case name="true">
                               <uix:tableLayout cellSpacing="5">
                                 <uix:rowLayout>
                                   <uix:cellFormat vAlign="top">
                                     <uix:messagePrompt labeledNodeId="schemaTable"
                                                        promptBinding="SCHEMA_TABLE_LABEL@dbMsgs"/>
                                   </uix:cellFormat> 

                                   <uix:stackLayout>
                                     <uix:messageLovField name="onSchemaAndObject" 
                                                          id="schemaTable"
                                                          columns="40"
                                                          shortDescBinding="SCHEMA_TABLE_LABEL@dbMsgs" 
                                                          searchDescBinding="SCHEMA_TABLE_LABEL@dbMsgs" 
                                                          textBinding="onSchemaAndObject@objectBean@servletRequest" 
                                                          onClick="setSearchFilter('s_name');startLov('onSchemaAndObject','ListSchemaTable')"/>
                                     <uix:messageText messageBinding="onSchemaAndObject@errors@servletRequest" 
                                                      messageType="error"/> 

                                     <uix:checkBox name="reducedPrecision"
                                                   textBinding="MVIEW_WITH_REDUCED_PRECISION@mvMsgs"
                                                   checkedBinding="reducedPrecision@objectBean@servletRequest"/>
                                   </uix:stackLayout>               				 

                                 </uix:rowLayout>
                                 <uix:rowLayout>
                                 </uix:rowLayout>
                               </uix:tableLayout>
                             </uix:case>
                           </uix:switcher>

                           <%-- Hint Text --%>
                           <uix:styledText styleClass="OraInstructionText" 
                                           textBinding="MVIEW_FROM_EXISTING_TABLE@mvMsgs" />
                        </uix:stackLayout>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>

                <%-- SWITCHER: MV query --%>
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="left" >
                        <uix:rowLayout>
                          <uix:messagePrompt labeledNodeId="queryText"
                                             promptBinding="MVIEW_MV_QUERY@mvMsgs" 
                                             required="yes"/> 
                          <uix:spacer width="280" height="1"/>
                          <uix:submitButton textBinding="MVIEW_EXPLAIN@mvMsgs" 
                                            name="event" value="explain" 
                                            unvalidated="true"/>
                        </uix:rowLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="left">
                       <uix:stackLayout>
                           <uix:textInput id="queryText"
                                          name="queryText" 
                                          textBinding="queryText@objectBean@servletRequest" 
                                          columns="80" 
                                          rows="10" />    
                           <uix:messageText messageBinding="queryText@errors@servletRequest" messageType="error"/>    
                       </uix:stackLayout>
                     </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout renderedBinding="creating@objectBean@servletRequest">
                    <uix:cellFormat hAlign="left">
                     <uix:checkBox name="analyzeMV"
                                   checkedBinding="analyzeMV@objectBean@servletRequest"
                                   textBinding="MVIEW_ANALYZE_MV_AFTER_CREATE@mvMsgs"/>
                   </uix:cellFormat>
                  </uix:rowLayout>

                 </uix:tableLayout>
               </uix:header>

               <%-- Tunning --%>
               <%--
               <uix:header textBinding="MVIEW_TUNNING_HEADER@mvMsgs" 
                           renderedBinding="versionEqualOrHigher10i@objectBean@servletRequest"
                           size="1">
                 <uix:tableLayout cellSpacing="5"> 
                   <uix:rowLayout>
                   <uix:styledText styleClass="OraInlineInfoText"
                                   textBinding="MVIEW_TUNE_TIP@mvMsgs"/>
                   </uix:rowLayout>
                   <uix:spacer height="10"/>
                   <uix:rowLayout>
                   <uix:styledText styleClass="OraInlineInfoText"
                                   textBinding="MVIEW_TUNE_INST@mvMsgs"/>
                   </uix:rowLayout>
                   <uix:rowLayout>
                     <uix:submitButton textBinding="MVIEW_TUNE@mvMsgs" name="event" value="tuneMView"/>
                   </uix:rowLayout>
                 </uix:tableLayout>
               </uix:header>
               --%>

               
               </uix:stackLayout>

            </uix:case>

           <uix:case name="false"> 
            <%-- for edit page --%>
            <uix:stackLayout>

              <%-- general obj description --%>
              <uix:tableLayout cellSpacing="5" hAlign="center" width="75%">
                  <%-- object name --%>

                  <%-- prebuilt mview dont have to show name input --%>
                  <uix:rowLayout renderedBinding="showNameInput@objectBean@servletRequest">
                      <uix:cellFormat hAlign="right" width="120">
                         <uix:messagePrompt labeledNodeId="objectName"
                                            promptBinding="NAME@dbMsgs"/>
                      </uix:cellFormat> 
                      <uix:cellFormat>
                      <uix:textInput id="objectName" 
                                     name="objectName"
                                     textBinding="objectName@objectBean@servletRequest" 
                                     disabled="true"/>
                      </uix:cellFormat>
                  </uix:rowLayout>
                
                  <%-- schema name --%>
                  <uix:rowLayout renderedBinding="showNameInput@objectBean@servletRequest">
                      <uix:cellFormat hAlign="right" width="120">
                        <uix:messagePrompt labeledNodeId="schemaName"
                                           promptBinding="SCHEMA@dbMsgs"/> 
                      </uix:cellFormat> 
                      <uix:cellFormat>
                         <uix:textInput id="schemaName" 
                                        name="schemaName"
                                        textBinding="schemaName@objectBean@servletRequest" 
                                        disabled="true"/>
                      </uix:cellFormat>
                  </uix:rowLayout>

                  <%-- tablespace name --%>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="120">
                      <uix:messagePrompt labeledNodeId="tablespaceName"
                                         promptBinding="TABLESPACE@dbMsgs"/>          
                    </uix:cellFormat> 
                    <uix:cellFormat>
                      <uix:textInput id="tablespaceName" 
                                     name="tablespaceName"
                                     textBinding="tablespaceName@objectBean@servletRequest" 
                                     disabled="true"/>
                    </uix:cellFormat>
                  </uix:rowLayout>

               <%-- number of indexes --%>
               <uix:rowLayout renderedBinding="editing@objectBean@servletRequest">
                 <uix:cellFormat hAlign="right">
                   <uix:messagePrompt promptBinding="NUMBER_OF_INDEXES@dbMsgs"/>
                 </uix:cellFormat>
                 <uix:cellFormat hAlign="left">
                   <uix:switcher childNameBinding="hasIndex@objectBean@servletRequest">
                     <uix:case name="true">
                       <uix:link textBinding="numIndexes@objectBean@servletRequest"
                                 onClick="submitForm('mviewForm', true, {event:'getIndexesForMView'})"/>
                     </uix:case>
                     <uix:case name="false">
                       <uix:styledText styleClass="OraDataText"
                                       textBinding="numIndexes@objectBean@servletRequest"/>
                     </uix:case>
                   </uix:switcher>
                 </uix:cellFormat>
               </uix:rowLayout>
             </uix:tableLayout>

              
              <%-- states --%>
              <uix:header textBinding="STATUS@dbMsgs" size="1">
                <uix:tableLayout cellSpacing="5"> 

                    <uix:rowLayout>
                     <uix:cellFormat hAlign="right" width="150">
                        <uix:messagePrompt labeledNodeId="lastAnalyzedDate"
                                            promptBinding="MVIEW_LAST_ANALYZE_DATE@mvMsgs"/> 
                     </uix:cellFormat>                     
                     <uix:textInput id="lastAnalyzedDate"
                                    textBinding="lastAnalyzeDate@objectBean@servletRequest" 
                                    disabled="true"/> 
                     <uix:submitButton textBinding="MVIEW_ANALYZE@mvMsgs" name="event" value="analyze"/>
                   </uix:rowLayout>

                    <uix:rowLayout>
                     <uix:cellFormat hAlign="right" width="150">
                        <uix:messagePrompt labeledNodeId="refreshState"
                                           promptBinding="MVIEW_REFRESH_STATE@mvMsgs"/> 
                     </uix:cellFormat>                     
                     <uix:cellFormat hAlign="left">
                       <uix:textInput id="refreshState"
                                      textBinding="refreshState@objectBean@servletRequest" 
                                      disabled="true"/> 
                     </uix:cellFormat>
                     <uix:cellFormat hAlign="left">
                             <uix:submitButton textBinding="MVIEW_REFRESH@mvMsgs" name="event" value="refresh"/>
                     </uix:cellFormat>
                   </uix:rowLayout>

                    <uix:rowLayout>
                     <uix:cellFormat hAlign="right" width="150">
                        <uix:messagePrompt labeledNodeId="compileState"
                                           promptBinding="MVIEW_COMPILE_STATE@mvMsgs"/> 
                     </uix:cellFormat>                     
                     <uix:cellFormat hAlign="left">
                       <uix:textInput id="compileState"
                                      textBinding="compileState@objectBean@servletRequest" 
                                      disabled="true"/> 
                     </uix:cellFormat>
                     <uix:cellFormat hAlign="left">
                             <uix:submitButton textBinding="COMPILE@dbMsgs" name="event" value="compile"/>
                     </uix:cellFormat>
                   </uix:rowLayout>
                  
                   </uix:tableLayout>
               </uix:header>


               <uix:header textBinding="MATERIALIZED_VIEW_DEFINITION@mvMsgs" size="1">
                <%-- from existing table label --%>
                <uix:tableLayout cellSpacing="3">

                  <%-- object name --%>
                    <uix:rowLayout renderedBinding="fromExistingTable@objectBean@servletRequest">
                      <uix:cellFormat hAlign="right"> 
                        <uix:messagePrompt promptBinding="MVIEW_BUILD_FROM_EXISTING_TABLE@mvMsgs"/> 
                      </uix:cellFormat> 
                      <uix:cellFormat width="5"/>

                      <uix:styledText styleClass="OraDataText" textBinding="name@objectBean@servletRequest" />
                  </uix:rowLayout>
                </uix:tableLayout>
               
              
                <%--  MV query --%>
                <uix:tableLayout cellSpacing="3">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="left">
                        <uix:checkBox name="queryRewrite" checkedBinding="queryRewrite@objectBean@servletRequest" 
                                      textBinding="MVIEW_ENABLE_QUERY_REWRITE@mvMsgs"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="left">
                        <uix:checkBox name="updatable" checkedBinding="updatable@objectBean@servletRequest" 
                                      textBinding="MVIEW_MAKE_UPDATABLE@mvMsgs" disabled="true"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:spacer height="10"/>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="left">
                        <uix:rowLayout>
                          <uix:messagePrompt labeledNodeId="queryText"
                                             promptBinding="MVIEW_MV_QUERY@mvMsgs"/> 
                          <uix:spacer width="280" height="1"/>
                        <uix:submitButton textBinding="MVIEW_EXPLAIN@mvMsgs" 
                                          name="event" value="explain" unvalidated="true"/>
                        </uix:rowLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <uix:rowLayout>
                     <uix:cellFormat hAlign="left">
                       <uix:textInput id="queryText"
                                      name="queryText" 
                                      textBinding="queryText@objectBean@servletRequest" 
                                      columns="80" 
                                      rows="10" 
                                      readOnly="true" />
                     </uix:cellFormat>
                   </uix:rowLayout>
                 </uix:tableLayout>
               </uix:header>
             </uix:stackLayout>
          </uix:case>
          </uix:switcher>

    <%-- END: TAB CONTENTS ends here --%>   
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/mview/pageButtonInclude.jsp" />
    <uix:ref refID="mviewPageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




