<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/utils.js"/>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="mvMsgs"
              class="oracle.sysman.db.rsc.schm.MViewMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="mviewForm"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/mview/indexStoragePage"/>

<uix:pageLayout titleBinding="header@objectBean@servletRequest"> 

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <uix:pageStatus>
    <uix:switcher childNameBinding="creating@objectBean@servletRequest">
      <uix:case name="true">
        <uix:tableLayout renderedBinding="versionEqualOrHigher10i@objectBean@servletRequest">
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:styledText textBinding="GET_RECOMMENDATION_INST@mvMsgs" styleClass="OraInstructionText"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:case>
    </uix:switcher>
  </uix:pageStatus>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs  --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/mview/subTabsInclude.jsp" />
      <uix:ref refID="mviewSubTabsInclude" />
    </uix:subTabs>


    <%-- START: TAB CONTENTS starts here --%>
    <uix:stackLayout>
      <uix:switcher childNameBinding="creating@objectBean@servletRequest">
       <uix:case name="true">
         <uix:tableLayout cellSpacing="5">

           <uix:rowLayout>
             <uix:messagePrompt prompt=""/>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:radioButton name="createIndex" value="no" 
                              textBinding="DONT_CREATE_DEFAULT_INDEX@mvMsgs"
                              selectedValueBinding="createIndex@objectBean@servletRequest"
                              onClick="submitForm('mviewForm', true, {event:'createDefaultIndex'})"/>
           </uix:rowLayout>

           <uix:rowLayout>
             <uix:radioButton name="createIndex" value="yes"
                              textBinding="CREATE_DEFAULT_INDEX@mvMsgs"
                              selectedValueBinding="createIndex@objectBean@servletRequest"
                              onClick="submitForm('mviewForm', true, {event:'createDefaultIndex'})"/>
           </uix:rowLayout>

           <uix:tableLayout> 
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" width="30"/> 
                     <uix:radioButton name="indexStorageChoice" value="sameAsMV"  
                                      selectedValueBinding="indexStorageChoice@objectBean@servletRequest" 
                                      textBinding="USE_SAME_STORAGE@mvMsgs"
                                      disabledBinding="disableCreateIndexOptions@objectBean@servletRequest"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" width="30"/> 
                <uix:radioButton name="indexStorageChoice" value="myOwnSetting"  
                                 selectedValueBinding="indexStorageChoice@objectBean@servletRequest" 
                                 textBinding="USE_STORAGE_SETTING@mvMsgs" 
                                 disabledBinding="disableCreateIndexOptions@objectBean@servletRequest"/>
             </uix:rowLayout>

            <uix:rowLayout> 
              <uix:cellFormat hAlign="left" width="30" vAlign="top" height="60"/>
                <uix:tableLayout>
                  <uix:rowLayout> 
                    <uix:cellFormat vAlign="top" hAlign="left"> 
                      <%-- Tablespace Name--%>
                      <uix:messagePrompt promptBinding="TABLESPACE@uixDBObjectBundle@servletRequest" labeledNodeId="TABLESPACE"/>
                    </uix:cellFormat> 
                  <uix:spacer width="5"/>
      
                    <uix:cellFormat hAlign="left"> 
                      <script language="javascript">
                        var destField;
                        function callBackLov()
                        {
                          return(destField);
                        }
                      </script>
                      <uix:stackLayout>
                          <uix:messageLovField name="tablespace" 
                                        id="TABLESPACE"
                                        textBinding="tablespace@indexSegmentBean@servletRequest"
                                        shortDescBinding="CLICKTOSELECTTABLESPACE@uixDBObjectBundle@servletRequest"
                                        searchDescBinding="CLICKTOSELECTTABLESPACE@uixDBObjectBundle@servletRequest"
                                        onClickBinding="indextblspclovdest@servletRequest"
                                        disabledBinding="disableCreateIndexOptions@objectBean@servletRequest" />
                         <uix:styledText styleClass="OraInlineInfoText"  textBinding="TABLESPACE_CONTROL_HINT@uixDBObjectBundle@servletRequest"/>
                       </uix:stackLayout>
                     </uix:cellFormat> 
                   <uix:spacer width="5"/>

                   <uix:cellFormat vAlign="top" hAlign="left"> 
                     <uix:submitButton textBinding="CHANGE@uixDBObjectBundle@servletRequest" name="event" value="changeIndexStorageTablespace"/>
                   </uix:cellFormat> 
                 </uix:rowLayout> 
               </uix:tableLayout>
            </uix:rowLayout>

             <uix:rowLayout>
                <uix:cellFormat hAlign="left" width="30"/> 
                <uix:dataScope currentDataBinding="indexSegmentBean@servletRequest">
                  <jsp:include page="/database/schema/utilities/storageContextInclude.jsp" />
                  <uix:ref refID="storageInclude" />
                </uix:dataScope>
             </uix:rowLayout>
           </uix:tableLayout> 
        </uix:tableLayout>
       </uix:case>

       <uix:case name="false">
          <uix:stackLayout>
<%--
            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                  <uix:radioButton name="indexStorageChoice" value="sameAsMV"  
                                   selectedValueBinding="indexStorageChoice@objectBean@servletRequest" 
                                   textBinding="USE_SAME_STORAGE@mvMsgs"/>
                </uix:cellFormat> 
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                  <uix:radioButton name="indexStorageChoice" value="myOwnSetting"  
                                   selectedValueBinding="indexStorageChoice@objectBean@servletRequest" 
                                   textBinding="USE_STORAGE_SETTING@mvMsgs" />


                 </uix:cellFormat> 
                </uix:rowLayout>
               </uix:tableLayout>
--%>

               <uix:tableLayout cellSpacing="15">
                <uix:cellFormat hAlign="left">
                <uix:dataScope currentDataBinding="indexSegmentBean@servletRequest">
                  <jsp:include page="/database/schema/utilities/storageContextInclude.jsp" />
                  <uix:ref refID="storageInclude" />
                </uix:dataScope>
                </uix:cellFormat>
               </uix:tableLayout>
             </uix:stackLayout>
           </uix:case>
         </uix:switcher>
       </uix:stackLayout>

  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/mview/pageButtonInclude.jsp" />
    <uix:ref refID="mviewPageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




