<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/utils.js"/>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="tblMsgs"
              class="oracle.sysman.db.rsc.schm.TableMsg"/>
  <uix:bundle name="mvMsgs"
              class="oracle.sysman.db.rsc.schm.MViewMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="mviewForm" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/mview/optionsPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <uix:pageStatus>
    <uix:switcher childNameBinding="creating@objectBean@servletRequest">
      <uix:case name="true">
        <uix:tableLayout renderedBinding="versionEqualOrHigher10i@objectBean@servletRequest">
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:styledText textBinding="GET_RECOMMENDATION_INST@mvMsgs" styleClass="OraInstructionText"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:case>
    </uix:switcher>
  </uix:pageStatus>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/mview/subTabsInclude.jsp" />
      <uix:ref refID="mviewSubTabsInclude" />
    </uix:subTabs>


    <%-- START: TAB CONTENTS starts here --%>
     <uix:spacer height="1"/>


     <uix:tableLayout  cellSpacing="10">
     <uix:cellFormat hAlign="left">

    <uix:stackLayout>  
      <%-- Parallel Option --%>
      <uix:spacer height="10" />
      <uix:checkBox name="isParallel"
                    checkedBinding="isParallel@objectBean@servletRequest" 
                    textBinding="PARALLEL_OPTION@tblMsgs"/>
      <uix:flowLayout>
        <uix:spacer width="21" height="1" />
        <uix:styledText styleClass="OraPromptText" 
                        textBinding="PARALLEL_DEGREE@uixTableBundle@servletRequest"/>
        <uix:spacer width="5"/>
        <oem:radioButton name="defaultDegree" 
                         value="yes" 
                         textBinding="DEFAULT@uixDBObjectBundle@servletRequest"
                         selectedValueBinding="defaultDegree@objectBean@servletRequest"/>
        <uix:spacer width="5" />
        <oem:radioButton name="defaultDegree"
                         value="no"
                         textBinding="VALUE@uixDBObjectBundle@servletRequest" 
                         selectedValueBinding="defaultDegree@objectBean@servletRequest"/>
        <uix:spacer width="5" />
        <uix:textInput name="degreeValue"
                       textBinding="degreeValue@objectBean@servletRequest" 
                       columns="10"
                       shortDescBinding="PARALLEL_DEGREE@tblMsgs">
          <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
        </uix:textInput>
      </uix:flowLayout>

      <%-- Cache --%>
      <uix:spacer height="5"/>
      <uix:checkBox name="cacheOption" 
                    checkedBinding="cacheOption@objectBean@servletRequest" 
                    textBinding="CACHE_OPTION@tblMsgs"/>
   
       </uix:stackLayout>

    </uix:cellFormat> 
    </uix:tableLayout>

      <uix:spacer height="1"/>     
 
    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/mview/pageButtonInclude.jsp" />
    <uix:ref refID="mviewPageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




