<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/utils.js"/>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="mvMsgs"
              class="oracle.sysman.db.rsc.schm.MViewMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="refreshHeader@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo"
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/mview/refreshOption"/>


<uix:pageLayout titleBinding="refreshHeader@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>
    <%-- START: TAB CONTENTS starts here --%>

<uix:tableLayout cellSpacing="10">
<uix:cellFormat hAlign="left">

  <uix:tableLayout cellSpacing="10">

  <uix:cellFormat hAlign="left">
    <uix:stackLayout>
      <uix:radioButton name="refreshOption" 
                       value="considerFresh"  
                       selectedValueBinding="refreshOption@objectBean@servletRequest" 
                       textBinding="MVIEW_CONSIDER_FRESH@mvMsgs"
                       onClick="submitForm('foo', true, {event:'changeRefreshType'})"/>

      <uix:spacer height="1"/>
      <uix:radioButton name="refreshOption" 
                       value="refreshFromMaster"  
                       selectedValueBinding="refreshOption@objectBean@servletRequest" 
                       textBinding="MVIEW_REFRESH_FROM_MASTER@mvMsgs"
                       onClick="submitForm('foo', true, {event:'changeRefreshType'})"/>


      <%-- refresh types --%>
      <uix:header textBinding="MVIEW_REFRESH_TYPE@mvMsgs" size="1">
        <uix:tableLayout cellSpacing="5">

          <uix:rowLayout>
            <uix:cellFormat  hAlign="left">
              <uix:radioButton name="refreshType" 
                               value="FORCE"  
                               selectedValueBinding="refreshType@objectBean@servletRequest" 
                               textBinding="MVIEW_FORCE_OPTION@mvMsgs"
                               disabledBinding="considerFresh@objectBean@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat  hAlign="left">
              <oem:radioButton name="refreshType" 
                               value="FAST"  
                               selectedValueBinding="refreshType@objectBean@servletRequest" 
                               textBinding="MVIEW_FAST_OPTION@mvMsgs"
                               disabledBinding="considerFresh@objectBean@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat  hAlign="left">
              <oem:radioButton name="refreshType" 
                               value="COMPLETE"  
                               selectedValueBinding="refreshType@objectBean@servletRequest" 
                               textBinding="MVIEW_COMPLETE_OPTION@mvMsgs"
                               disabledBinding="considerFresh@objectBean@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>

        </uix:tableLayout>  
      </uix:header>


      <%-- rollback segment --%>
      <uix:header textBinding="MVIEW_RBS@mvMsgs" size="1">
        <uix:tableLayout cellSpacing="5" >

          <%-- name --%>
          <uix:rowLayout vAlign="center">
            <uix:cellFormat hAlign="left">
              <oem:radioButton name="useDefaultRS" 
                               value="yes"  
                               selectedValueBinding="useDefaultRS@objectBean@servletRequest" 
                               textBinding="MVIEW_USE_DEFAULT_RBS@mvMsgs"
                               disabledBinding="considerFresh@objectBean@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout vAlign="center">
            <uix:cellFormat hAlign="left">
              <uix:rowLayout>
                <oem:radioButton name="useDefaultRS" 
                                 value="no" 
                                 selectedValueBinding="useDefaultRS@objectBean@servletRequest" 
                                 textBinding="MVIEW_SEGMENT@mvMsgs"
                                 disabledBinding="considerFresh@objectBean@servletRequest"/>
                <uix:spacer width="3"/>
                <uix:stackLayout>
                  <oem:choice name="rbSegLocal"
                              shortDescBinding="MVIEW_SEGMENT@mvMsgs"
                              optionsBinding="rbSegLocalOptions@objectBean@servletRequest"
                              selectedValueBinding="rbSegLocal@objectBean@servletRequest"/>
                  <uix:messageText messageBinding="segmentName@errors@servletRequest" 
                                   messageType="error"/>
                </uix:stackLayout>
              </uix:rowLayout>
            </uix:cellFormat>
          </uix:rowLayout>

          </uix:tableLayout>
        </uix:header>

        <%-- other options --%>
        <uix:header textBinding="MVIEW_OTHER_OPTIONS@mvMsgs" size="1">
                  
          <uix:tableLayout cellSpacing="5" >
            <uix:rowLayout vAlign="center">
              <uix:cellFormat hAlign="left">
                <uix:checkBox name="ignoreError" 
                              checkedBinding="ignoreError@objectBean@servletRequest" 
                              textBinding="MVIEW_CONTINUE_REFRESH@mvMsgs"
                              disabledBinding="considerFresh@objectBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout vAlign="center">
              <uix:cellFormat hAlign="left">
                <uix:checkBox name="pushToMasterBeforeRefresh"  
                              checkedBinding="pushToMasterBeforeRefresh@objectBean@servletRequest" 
                              textBinding="MVIEW_PUSH_CHANGES@mvMsgs"
                              disabledBinding="considerFresh@objectBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout vAlign="center">
              <uix:cellFormat hAlign="left">
                <uix:checkBox name="analyzeMVAfter" 
                              checkedBinding="analyzeMVAfter@objectBean@servletRequest" 
                              textBinding="MVIEW_ANALYZE_AFTER_CREATE@mvMsgs"
                              disabledBinding="considerFresh@objectBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

          </uix:tableLayout>
        </uix:header>

      <%-- page button bar --%>
      <uix:contentFooter>
        <uix:pageButtonBar>
          <uix:flowLayout>
            <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancelRefreshOption" />  
            <uix:spacer width="10"/>
            <uix:submitButton textBinding="OK@dbMsgs" name="event" value="okRefreshOption" />  
          </uix:flowLayout>
         </uix:pageButtonBar>
       </uix:contentFooter>

    </uix:stackLayout>

  </uix:cellFormat>
  </uix:tableLayout> 

</uix:cellFormat>
</uix:tableLayout> 

  <%-- END: TAB CONTENTS ends here --%>   
        
  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
    <uix:pageButtonBar>
      <uix:flowLayout>
        <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancelRefreshOption" />  
        <uix:spacer width="10"/>
        <uix:submitButton textBinding="OK@dbMsgs" name="event" value="okRefreshOption" />  
      </uix:flowLayout>
    </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




