<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        refreshPage.jsp
  -- Controller:  db/adm/schm/MViewController.java
  --
  -- Description: 
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.mview.MView" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="mvMsgs"
              class="oracle.sysman.db.rsc.schm.MViewMsg"/>
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="mviewForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/mview/refreshPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <uix:pageStatus>
    <uix:switcher childNameBinding="creating@objectBean@servletRequest">
      <uix:case name="true">
        <uix:tableLayout renderedBinding="versionEqualOrHigher10i@objectBean@servletRequest">
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:styledText textBinding="GET_RECOMMENDATION_INST@mvMsgs" styleClass="OraInstructionText"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:case>
    </uix:switcher>
  </uix:pageStatus>
  
  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/mview/subTabsInclude.jsp" />
      <uix:ref refID="mviewSubTabsInclude" />
    </uix:subTabs>


   <uix:switcher childNameBinding="creating@objectBean@servletRequest">
   <%-- Case: CREATE --%>
   <uix:case name="true">

           <uix:spacer height="2"/>
     
           <%-- populate MV immedately --%>
           <uix:header text="" size="1">
             <uix:tableLayout cellSpacing="0">
               <uix:rowLayout>
                 <uix:cellFormat  hAlign="left">
                 <uix:checkBox name="populateMV"  checkedBinding="populateMV@objectBean@servletRequest" 
                               textBinding="POPULATE_MV@mvMsgs" />
                 </uix:cellFormat>
               </uix:rowLayout>
             </uix:tableLayout>
            </uix:header>

    </uix:case>
   </uix:switcher>
   
    <%-- START: TAB CONTENTS starts here --%>
         <%-- refresh types --%>
         <uix:header textBinding="MVIEW_REFRESH_TYPE@mvMsgs" size="1">
           <uix:tableLayout cellSpacing="5">

              <uix:rowLayout>
                <uix:cellFormat  hAlign="left">
                   <uix:radioButton name="refreshType" value="FORCE"  selectedValueBinding="refreshType@objectBean@servletRequest" textBinding="MVIEW_FORCE_OPTION@mvMsgs"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat  hAlign="left">
                     <uix:radioButton name="refreshType" value="FAST" selectedValueBinding="refreshType@objectBean@servletRequest" textBinding="MVIEW_FAST_OPTION@mvMsgs"/>
                </uix:cellFormat>
              </uix:rowLayout>


              <uix:rowLayout>
                <uix:cellFormat  hAlign="left">
                     <uix:radioButton name="refreshType" value="COMPLETE" selectedValueBinding="refreshType@objectBean@servletRequest" textBinding="MVIEW_COMPLETE_OPTION@mvMsgs"/>
                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>  
          </uix:header>


         <%-- refresh methods --%>
         <uix:header textBinding="MVIEW_REFRESH_METHOD@mvMsgs" size="1">
           <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat  hAlign="left">
                   <uix:radioButton name="refreshMethod" 
                                    value="primaryKey"  
                                    selectedValueBinding="refreshMethod@objectBean@servletRequest" 
                                    textBinding="MVIEW_PRIMARY_KEY@mvMsgs" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat  hAlign="left">
                     <uix:radioButton name="refreshMethod" 
                                      value="rowID"  
                                      selectedValueBinding="refreshMethod@objectBean@servletRequest" 
                                      textBinding="MVIEW_ROW_ID@mvMsgs"
                                      disabledBinding="editing@objectBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>  
          </uix:header>

         <%-- refresh interval --%>
         <uix:header textBinding="MVIEW_REFRESH_INTERVAL@mvMsgs" size="1">

           <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat  hAlign="left">
                   <uix:radioButton name="refreshInterval" value="onDemand"   
                                    shortDescBinding="MVIEW_ON_DEMAND@mvMsgs"
                                    selectedValueBinding="refreshInterval@objectBean@servletRequest" 
                                    disabledBinding="disableOnDemand@objectBean@servletRequest" 
                                    textBinding="MVIEW_ON_DEMAND@mvMsgs" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat  hAlign="left">
                  <uix:radioButton name="refreshInterval" value="onEachCommit"   
                                   shortDescBinding="MVIEW_ON_EACH_COMMIT@mvMsgs"
                                   selectedValueBinding="refreshInterval@objectBean@servletRequest" 
                                   disabledBinding="disableOnCommit@objectBean@servletRequest" 
                                   textBinding="MVIEW_ON_EACH_COMMIT@mvMsgs"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat vAlign="top" hAlign="left">
                     <uix:radioButton name="refreshInterval" value="automaticallyOn"   
                                      shortDescBinding="MVIEW_AUTO@mvMsgs"
                                      selectedValueBinding="refreshInterval@objectBean@servletRequest" 
                                      disabledBinding="disableAuto@objectBean@servletRequest" 
                                      textBinding="MVIEW_AUTO@mvMsgs" />
                     <uix:spacer width="4" height="1"/>

                    <uix:dateField shortDescBinding="NEXT_DATE@dbMsgs" 
                                   valueBinding="scheduleDate@objectBean@servletRequest" 
                                   name="scheduleDate" 
                                      disabledBinding="disableAuto@objectBean@servletRequest" 
                                   columns="10" />

                    <uix:spacer width="4" height="2"/>            
                     <oem:choice  name="refreshHour" optionsBinding="hourOptions@objectBean@servletRequest" 
                                  shortDescBinding="INTERVAL_UNIT_OPTIONS_HOURS@mvMsgs"
                                      disabledBinding="disableAuto@objectBean@servletRequest" 
                                  selectedValueBinding="refreshHour@objectBean@servletRequest"/>
                     <uix:spacer width="2" height="2"/>            
                     <oem:choice  name="refreshMin" optionsBinding="minOptions@objectBean@servletRequest"  
                                  shortDescBinding="INTERVAL_UNIT_OPTIONS_MINUTES@mvMsgs"
                                      disabledBinding="disableAuto@objectBean@servletRequest" 
                                  selectedValueBinding="refreshMin@objectBean@servletRequest"/>
                     <uix:spacer width="2" height="2"/>            
                     <oem:choice  name="refreshSec" optionsBinding="secOptions@objectBean@servletRequest"  
                                  shortDescBinding="INTERVAL_UNIT_OPTIONS_SECONDS@mvMsgs"
                                      disabledBinding="disableAuto@objectBean@servletRequest" 
                                  selectedValueBinding="refreshSec@objectBean@servletRequest"/>
                     <uix:messagePrompt labeledNodeId="intervalNum"
                                        promptBinding="MVIEW_THEN_REFRESH@mvMsgs"/>

                     <uix:cellFormat vAlign="top">
                       <uix:tableLayout cellSpacing="2"> 
                         <uix:rowLayout>
                           <uix:radioButton textBinding="MVIEW_EVERY@mvMsgs" 
                                            name="refreshNext" 
                                            value="every"  
                                      disabledBinding="disableAuto@objectBean@servletRequest" 
                                            selectedValueBinding="refreshNext@objectBean@servletRequest"/> 
                            <uix:cellFormat>
                               <uix:textInput id="intervalNum"
                                              name="intervalNum" 
                                              textBinding="intervalNum@objectBean@servletRequest" 
                                      disabledBinding="disableAuto@objectBean@servletRequest" 
                                              columns="4">
                                 <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
                               </uix:textInput>
                            
                             <uix:choice  name="intervalUnit" 
                                          shortDescBinding="MVIEW_EVERY@mvMsgs"
                                          disabledBinding="disableAuto@objectBean@servletRequest" 
                                          selectedValueBinding="intervalUnit@objectBean@servletRequest">
                               <uix:option textBinding="INTERVAL_UNIT_OPTIONS_DAYS@mvMsgs" value="<%=MView.DAY%>"/>
                               <uix:option textBinding="INTERVAL_UNIT_OPTIONS_HOURS@mvMsgs" value="<%=MView.HOUR%>"/>
                               <uix:option textBinding="INTERVAL_UNIT_OPTIONS_MINUTES@mvMsgs" value="<%=MView.MINUTE%>"/>
                               <uix:option textBinding="INTERVAL_UNIT_OPTIONS_SECONDS@mvMsgs" value="<%=MView.SECOND%>"/>
                             </uix:choice>
                            </uix:cellFormat>
                         </uix:rowLayout>
                         <uix:rowLayout>
                           <uix:radioButton textBinding="MVIEW_ON@mvMsgs"
                                            name="refreshNext"
                                            value="on"
                                      disabledBinding="disableAuto@objectBean@servletRequest" 
                                            selectedValueBinding="refreshNext@objectBean@servletRequest"/>
                           <uix:cellFormat hAlign="left">
                             <uix:stackLayout>
                               <uix:textInput shortDescBinding="MVIEW_ON@mvMsgs"
                                              name="nextOnDate"
                                              textBinding="nextOnDate@objectBean@servletRequest"
                                      disabledBinding="disableAuto@objectBean@servletRequest" 
                                              columns="30"/>
                               <uix:messageText messageBinding="nextOnDate@errors@servletRequest" messageType="error"/> 
                             </uix:stackLayout>
                           </uix:cellFormat> 
                         </uix:rowLayout>
                       </uix:tableLayout>
                     </uix:cellFormat>
                  </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat  hAlign="left">
                     <uix:radioButton textBinding="MVIEW_NEVER@mvMsgs" 
                                      name="refreshInterval" 
                                      value="never"  
                                      selectedValueBinding="refreshInterval@objectBean@servletRequest" 
                                      disabledBinding="disableNever@objectBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>


            </uix:tableLayout>  
            </uix:header>


          <%-- rollback segment --%>
         <uix:header textBinding="MVIEW_RBS@mvMsgs" size="1">
                  
            <uix:tableLayout cellSpacing="5" >
                <%-- name --%>
                <uix:rowLayout vAlign="center">
                    <uix:cellFormat hAlign="right">
                        <uix:messagePrompt labeledNodeId="rbSegMaster"
                                           promptBinding="MVIEW_MASTER@mvMsgs"  
                                           required="no"/>
                    </uix:cellFormat>

                    <uix:cellFormat hAlign="left">
                      <uix:stackLayout>
                          <uix:textInput id="rbSegMaster"
                                         name="rbSegMaster" 
                                         textBinding="rbSegMaster@objectBean@servletRequest" 
                                         columns="60" />
                          <uix:messageText messageBinding="rbSegMaster@errors@servletRequest" messageType="error"/> 
                      </uix:stackLayout>
                    </uix:cellFormat>

                </uix:rowLayout>

                <uix:rowLayout vAlign="center">
                    <uix:cellFormat hAlign="right">
                         <uix:messagePrompt labeledNodeId="local" promptBinding="MVIEW_LOCAL@mvMsgs" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:stackLayout>
                        <oem:choice name="rbSegLocal" 
                                    id="local"
                                    optionsBinding="rbSegLocalOptions@objectBean@servletRequest"  
                                    selectedValueBinding="rbSegLocal@objectBean@servletRequest"/>
                      </uix:stackLayout>
                    </uix:cellFormat>

                </uix:rowLayout>

            </uix:tableLayout>
        </uix:header>

   <uix:switcher childNameBinding="creating@objectBean@servletRequest">
   <%-- Case: CREATE --%>
   <uix:case name="false">
        <%-- status --%>
         <uix:header textBinding="MVIEW_STATUS@mvMsgs" size="1">
           <uix:tableLayout cellSpacing="5">

           <uix:rowLayout>
               <uix:cellFormat hAlign="right">
                 <uix:messagePrompt promptBinding="MVIEW_LAST_REFRESH_DATE@mvMsgs"/> 
                    </uix:cellFormat>                     
                     <uix:cellFormat hAlign="left">
                       <uix:styledText styleClass="OraDataText" textBinding="lastRefreshDate@objectBean@servletRequest"/>    
                   </uix:cellFormat>
              </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="right">
                 <uix:messagePrompt promptBinding="MVIEW_REFRESH_GROUP@mvMsgs"/> 
                    </uix:cellFormat>                     
                     <uix:cellFormat hAlign="left">
                       <uix:styledText styleClass="OraDataText" textBinding="refreshGroup@objectBean@servletRequest"/>    
                   </uix:cellFormat>
              </uix:rowLayout>

  
            </uix:tableLayout>  
            </uix:header>
     </uix:case>
   </uix:switcher>

    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/mview/pageButtonInclude.jsp" />
    <uix:ref refID="mviewPageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
