<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/utils.js"/>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="mvMsgs"
              class="oracle.sysman.db.rsc.schm.MViewMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="mviewForm" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/mview/storagePage"/>

<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <uix:pageStatus>
    <uix:switcher childNameBinding="creating@objectBean@servletRequest">
      <uix:case name="true">
        <uix:tableLayout renderedBinding="versionEqualOrHigher10i@objectBean@servletRequest">
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:styledText textBinding="GET_RECOMMENDATION_INST@mvMsgs" styleClass="OraInstructionText"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:case>
    </uix:switcher>
  </uix:pageStatus>
  
  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/mview/subTabsInclude.jsp" />
      <uix:ref refID="mviewSubTabsInclude" />
    </uix:subTabs>


    <%-- START: TAB CONTENTS starts here --%>
    <uix:spacer height="5"/>
      <uix:dataScope currentDataBinding="segmentBean@servletRequest">
        <jsp:include page="/database/schema/utilities/storageContextInclude.jsp" />
        <uix:ref refID="storageInclude" />
      </uix:dataScope> 
 
    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/mview/pageButtonInclude.jsp" />
    <uix:ref refID="mviewPageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




