<%--
  -- Page:       subTabsInclude.jsp
  -- 
  -- Description: This handles all of the mview subtabs.
  --              All events should be named: subTab<tabName>.
  --              In onEvent any event that starts with "subTab"
  --              will be forwarded to the onSubTab function where
  --              it will be handled.
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="mviewSubTabsInclude">
<uix:subTabBar selectedIndexBinding="selectedTab@objectBean@servletRequest">

  <%-- General Tab --%>
  <db:link textBinding="MVIEW_GENERAL_TAB@uixMViewBundle@servletRequest"
           onClick="submitForm('mviewForm', true, {event:'gotoGeneralTab'})" 
           copyParams="target,type,cancelURL,sname,oname,otype"/>

  <%-- Refresh Tab --%>
  <db:link textBinding="MVIEW_REFRESH_TAB@uixMViewBundle@servletRequest"
           onClick="submitForm('mviewForm', true, {event:'gotoRefreshTab'})"
           copyParams="target,type,cancelURL,sname,oname,otype"/>

  <%-- Storage Tab --%>
  <db:link textBinding="MVIEW_STORAGE_TAB@uixMViewBundle@servletRequest"
           onClick="submitForm('mviewForm', true, {event:'gotoStorageTab'})" 
           copyParams="target,type,cancelURL,sname,oname,otype"/>

  <%-- Index Storage Tab --%>
  <uix:switcher childNameBinding="showIndexStorageTab@objectBean@servletRequest">
    <uix:case name="true">
      <db:link textBinding="MVIEW_INDEX_STORAGE_TAB@uixMViewBundle@servletRequest"
               onClick="submitForm('mviewForm', true, {event:'gotoIndexStorageTab'})"
               copyParams="target,type,cancelURL,sname,oname,otype"/>
    </uix:case>
  </uix:switcher>

  <%-- Options Tab --%>
  <db:link textBinding="MVIEW_OPTIONS_TAB@uixMViewBundle@servletRequest"
           onClick="submitForm('mviewForm', true, {event:'gotoOptionsTab'})" 
           copyParams="target,type,cancelURL,sname,oname,otype"/>

  <%-- Master Info Tab --%>
  <uix:switcher childNameBinding="creating@objectBean@servletRequest">
    <uix:case name="false">
      <db:link textBinding="MVIEW_MASTER_INFO_TAB@uixMViewBundle@servletRequest"
           onClick="submitForm('mviewForm', true, {event:'gotoMasterInfoTab'})"
           copyParams="target,type,cancelURL,sname,oname,otype"/>
    </uix:case>
  </uix:switcher>


  <%-- Space Usage Tab --%>
  <uix:switcher childNameBinding="versionEqualOrHigher10i@objectBean@servletRequest">
    <uix:case name="true">
      <uix:switcher childNameBinding="creating@objectBean@servletRequest">
        <uix:case name="false">
          <db:link textBinding="SEGMENTS@uixSchemaBundle@servletRequest"
                   onClick="submitForm('mviewForm', true, {event:'gotoSpaceUsageTab'})"
                   copyParams="target,type,cancelURL,sname,oname,otype"/>
        </uix:case>
      </uix:switcher>
    </uix:case>
  </uix:switcher>

</uix:subTabBar>
</uix:buildTree>

