<%@ include file="/sdk/oemTop.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="mvMsgs"
              class="oracle.sysman.db.rsc.schm.MViewMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="TUNE_MVIEW_RESULT@mvMsgs"/>
</uix:metaContainer>

<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/mview/tuneMViewResultsPage"/>
<uix:formValue name="fromSearch" valueBinding="fromSearch@servletRequest"/>
<uix:formValue name="backURL" valueBinding="backURL@servletRequest"/>
  <uix:pageLayout titleBinding="TUNE_MVIEW_RESULT@mvMsgs">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <%-- START: TAB CONTENTS starts here --%>
      <uix:tableLayout>
        <uix:rowLayout>
          <uix:spacer height="10"/>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:styledText textBinding="MVIEW_TUNE_TIP@mvMsgs" styleClass="OraInstructionText"/>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:spacer height="10"/>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:header textBinding="CREATE_SQL_FROM_RECOMMENDATION@mvMsgs">
            <db:sqlDisplay sqlListBinding="tuneMVSqls@objectBean@servletRequest"/> 
          </uix:header>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:spacer height="20"/>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:hideShow id="tuneHideShow"
                        undisclosedTextBinding="SHOW_ORIGINAL@mvMsgs"
                        disclosedTextBinding="HIDE_ORIGINAL@mvMsgs"
                        disclosedBinding="showOriginal@objectBean@servletRequest"
                        formName="foo"
                        formSubmitted="true" >
            <uix:header textBinding="CREATE_SQL_FROM_ORIGINAL@mvMsgs">
              <db:sqlDisplay sqlListBinding="originalCreateSQLs@objectBean@servletRequest"/> 
            </uix:header>
          </uix:hideShow>
        </uix:rowLayout>

      </uix:tableLayout>

    <%-- END: TAB CONTENTS ends here --%>   

  <%-- Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
     <uix:button name="cancel" textBinding="CANCEL@dbMsgs" destinationBinding="backURL@servletRequest"/>
     <uix:submitButton textBinding="IMPLEMENT_RECOMMENDATION@mvMsgs" 
                       shortDescBinding="IMPLEMENT_RECOMMENDATION@mvMsgs"
                       name="event"
                       value="apply" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




