<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="mvMsgs"
              class="oracle.sysman.db.rsc.schm.MViewMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo"
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype,guid,version,initMethod">
<uix:formValue name="pageName" value="/database/schema/mview/viewMVPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <%-- START: GENERAL PAGE CONTENTS starts here --%>

        <uix:header textBinding="GENERAL@dbMsgs">

            <uix:stackLayout>                      

              <uix:tableLayout cellSpacing="5">
       
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="180">
                      <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                    </uix:cellFormat> 
                      <uix:styledText styleClass="OraDataText" textBinding="name@objectBean@servletRequest"/>
                </uix:rowLayout>
                
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="180">
                      <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/> 
                    </uix:cellFormat> 
                      <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>   
                </uix:rowLayout>

                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="180">
                       <uix:messagePrompt promptBinding="TABLESPACE@uixDBObjectBundle@servletRequest"/> 
                    </uix:cellFormat> 
                    <uix:styledText styleClass="OraDataText" textBinding="tablespaceName@objectBean@servletRequest"/>   
                </uix:rowLayout>

        

                    <uix:rowLayout>
                     <uix:cellFormat hAlign="right" width="180">
                        <uix:messagePrompt promptBinding="MVIEW_LAST_ANALYZE_DATE@uixMViewBundle@servletRequest"/> 
                     </uix:cellFormat>                     
                     <uix:cellFormat hAlign="left">
                            <uix:styledText styleClass="OraDataText" textBinding="lastAnalyzeDate@objectBean@servletRequest"/>  
                     </uix:cellFormat>
                   </uix:rowLayout>

                    <uix:rowLayout>
                     <uix:cellFormat hAlign="right" width="180">
                        <uix:messagePrompt promptBinding="MVIEW_REFRESH_STATE@uixMViewBundle@servletRequest"/> 
                     </uix:cellFormat>                     
                     <uix:cellFormat hAlign="left">
                           <uix:styledText styleClass="OraDataText" textBinding="refreshState@objectBean@servletRequest"/>     
                     </uix:cellFormat>
                   </uix:rowLayout>

                    <uix:rowLayout>
                     <uix:cellFormat hAlign="right" width="180">
                        <uix:messagePrompt promptBinding="MVIEW_COMPILE_STATE@uixMViewBundle@servletRequest"/> 
                     </uix:cellFormat>                     
                     <uix:cellFormat hAlign="left">
                           <uix:styledText styleClass="OraDataText" textBinding="compileState@objectBean@servletRequest"/>  
                     </uix:cellFormat>
                   </uix:rowLayout>
                  
                <uix:rowLayout>
                   <uix:cellFormat hAlign="right" width="180">
                     <uix:messagePrompt promptBinding="MVIEW_UPDATABLE@uixMViewBundle@servletRequest"/>
                   </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="updatable@objectBean@servletRequest"/>
                </uix:rowLayout>

                <uix:rowLayout>
                   <uix:cellFormat hAlign="right" width="180">
                     <uix:messagePrompt promptBinding="MVIEW_BUILT_FROM_TABLE@uixMViewBundle@servletRequest"/> 
                   </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="fromExistingTable@objectBean@servletRequest"/>   
                </uix:rowLayout>

                <%-- Indexes --%>
                <uix:rowLayout>
                   <uix:cellFormat hAlign="right" width="180">
                     <uix:messagePrompt promptBinding="NUMBER_OF_INDEXES@uixDBObjectBundle@servletRequest"/>
                   </uix:cellFormat> 

                   <uix:switcher childNameBinding="hasIndex@objectBean@servletRequest">
                     <uix:case name="true">
                       <uix:link textBinding="numIndexes@objectBean@servletRequest"
                                 onClick="submitForm('foo', true, {event:'getIndexesForMView'})"/>
                     </uix:case>
                     <uix:case name="false">
                       <uix:styledText styleClass="OraDataText"
                                       textBinding="numIndexes@objectBean@servletRequest"/>
                     </uix:case>
                   </uix:switcher>
                </uix:rowLayout>

             </uix:tableLayout>

   
                <%-- SWITCHER: MV query --%>
                  <uix:tableLayout cellSpacing="5">
                    <uix:cellFormat hAlign="left">
                      <uix:rowLayout>
                       <uix:messagePrompt labeledNodeId="queryText"
                                          promptBinding="MVIEW_MV_QUERY@uixMViewBundle@servletRequest"/> 
                       <uix:spacer width="280" height="1"/>
                        <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
                         <uix:case name="false">
                           <uix:submitButton textBinding="MVIEW_EXPLAIN@mvMsgs" name="event" value="explain" unvalidated="true"/>
                         </uix:case>
                        </uix:switcher>
                      </uix:rowLayout>
                    </uix:cellFormat>
                 </uix:tableLayout>

                <uix:tableLayout cellSpacing="0">
                 <uix:cellFormat hAlign="left">
                     <uix:textInput id="queryText"
                                    name="queryText" 
                                    textBinding="queryText@objectBean@servletRequest" 
                                    columns="80" 
                                    rows="10" 
                                    readOnly="true" />
                 </uix:cellFormat>
                </uix:tableLayout>
   
            </uix:stackLayout>            

         </uix:header> <%-- general subheader --%>

    <%-- END: GENERAL PAGE CONTENTS ends here --%>   
        
    <%-- START: REFRESH CONTENTS starts here --%>
         <%-- refresh types --%>
         <uix:header textBinding="REFRESH@dbMsgs">

            <uix:stackLayout>                      

              <uix:tableLayout cellSpacing="5">
       
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="180">
                      <uix:messagePrompt promptBinding="MVIEW_REFRESH_TYPE@uixMViewBundle@servletRequest"/>
                    </uix:cellFormat> 
                      <uix:styledText styleClass="OraDataText" textBinding="refreshTypeText@objectBean@servletRequest"/>
                </uix:rowLayout>

                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="180">
                      <uix:messagePrompt promptBinding="MVIEW_REFRESH_METHOD@uixMViewBundle@servletRequest"/>
                    </uix:cellFormat> 
                      <uix:styledText styleClass="OraDataText" textBinding="refreshMethodText@objectBean@servletRequest"/>
                </uix:rowLayout>

                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="180">
                      <uix:messagePrompt promptBinding="MVIEW_REFRESH_INTERVAL@uixMViewBundle@servletRequest"/>
                    </uix:cellFormat> 
                      <uix:styledText styleClass="OraDataText" textBinding="refreshIntervalText@objectBean@servletRequest"/>
                </uix:rowLayout>

                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="180">
                      <uix:messagePrompt promptBinding="MVIEW_MASTER_RBS@uixMViewBundle@servletRequest"/>
                    </uix:cellFormat> 
                      <uix:styledText styleClass="OraDataText" textBinding="rbSegMaster@objectBean@servletRequest"/>
                </uix:rowLayout>

                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="180">
                      <uix:messagePrompt promptBinding="MVIEW_LOCAL_RBS@uixMViewBundle@servletRequest"/>
                    </uix:cellFormat> 
                      <uix:styledText styleClass="OraDataText" textBinding="rbSegLocal@objectBean@servletRequest"/>
                </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="right" width="180">
                 <uix:messagePrompt promptBinding="MVIEW_LAST_REFRESH_DATE@uixMViewBundle@servletRequest"/> 
                    </uix:cellFormat>                     
                     <uix:cellFormat hAlign="left">
                       <uix:styledText styleClass="OraDataText" textBinding="lastRefreshDate@objectBean@servletRequest"/>    
                   </uix:cellFormat>
              </uix:rowLayout>

             <uix:rowLayout>
               <uix:cellFormat hAlign="right" width="180">
                 <uix:messagePrompt promptBinding="MVIEW_REFRESH_GROUP@uixMViewBundle@servletRequest"/> 
                    </uix:cellFormat>                     
                     <uix:cellFormat hAlign="left">
                       <uix:styledText styleClass="OraDataText" textBinding="refreshGroup@objectBean@servletRequest"/>    
                   </uix:cellFormat>
              </uix:rowLayout>

   
             </uix:tableLayout>

       </uix:stackLayout>


   </uix:header>
   <%-- END: REFRESH CONTENTS ends here --%>   

    <%-- START: STORAGE CONTENTS starts here --%>
    <uix:header textBinding="STORAGE@dbMsgs">

      <%-- SHARED STORAGE UI --%>
      <uix:dataScope currentDataBinding="segmentBean@servletRequest">
        <jsp:include page="/database/schema/utilities/viewStorageContextInclude.jsp" />
         <uix:ref refID="viewStorageInclude" />
      </uix:dataScope> 
    </uix:header>
    <%-- END: STORAGE CONTENTS ends here --%>   


    <%-- START: INDEX STORAGE CONTENTS starts here --%>
    <uix:header textBinding="INDEX_STORAGE@dbMsgs" renderedBinding="hasIndex@objectBean@servletRequest">
      <uix:dataScope currentDataBinding="indexSegmentBean@servletRequest">
        <jsp:include page="/database/schema/utilities/viewStorageContextInclude.jsp"/>
         <uix:ref refID="viewStorageInclude" />
      </uix:dataScope> 
    </uix:header>
    <%-- END: INDEX STORAGE CONTENTS ends here --%>   

    <%-- START: OPTION CONTENTS starts here --%>

     <uix:header textBinding="OPTIONS@dbMsgs">

              <uix:tableLayout cellSpacing="5">

                <uix:rowLayout>
                   <uix:cellFormat hAlign="right" width="180">
                     <uix:messagePrompt promptBinding="MVIEW_REWRITABLE@uixMViewBundle@servletRequest"/> 
                   </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="queryRewrite@objectBean@servletRequest"/>   
                </uix:rowLayout>

                <uix:rowLayout>
                   <uix:cellFormat hAlign="right" width="180">
                       <uix:messagePrompt promptBinding="MVIEW_UPDATABLE@uixMViewBundle@servletRequest"/> 
                   </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="fromExistingTable@objectBean@servletRequest"/>   
                </uix:rowLayout>
   

       
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="180">
                      <uix:messagePrompt promptBinding="PARELLEL@uixDBObjectBundle@servletRequest"/>
                    </uix:cellFormat> 
                    <uix:styledText styleClass="OraDataText" textBinding="parallelOptionText@objectBean@servletRequest"/>
                </uix:rowLayout>

                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="180">
                      <uix:messagePrompt promptBinding="CACHING@uixDBObjectBundle@servletRequest"/>
                    </uix:cellFormat> 
                    <uix:styledText styleClass="OraDataText" textBinding="cachingOptionText@objectBean@servletRequest"/>
                </uix:rowLayout>
             </uix:tableLayout>

    </uix:header> 
    <%-- END: OPTION CONTENTS ends here --%>   

    <%-- START: MASTER INFO CONTENTS starts here --%>
 
          <uix:spacer height="1"/>
          <uix:header textBinding="MVIEW_MASTER_INFORMATION@mvMsgs">
            <oem:table name="masterInfoUI" 
                       beanKey="masterInfoBean"
                       dataSourceProp="masterInfoUI"
                       width="100%" 
                       summaryBinding="MVIEW_MASTER_INFORMATION@mvMsgs"
                       copyParams="target,type,cancelURL,sname,oname,otype,guid,version,initMethod"/>
          </uix:header>
          <uix:spacer height="1"/>
 
    <%-- END:  MASTER INFO CONTENTS ends here --%>   

    <%-- Create/Edit Buttons --%>
    <uix:pageButtons>
      <uix:pageButtonBar>
          <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
            <uix:case name="false">
                <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
                <uix:ref refID="pageButtonViewInclude" />
            </uix:case>
            <uix:case name="true">
            <%-- OK Button --%>
            <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
            </uix:case>
          </uix:switcher>
      </uix:pageButtonBar>
    </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




