<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.mvlog.MViewLog"/>

<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<script>
  window.onerror = handleError;
  function handleError()
  {
    return true;
  }
</script>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsg"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="mvlogMsg"
              class="oracle.sysman.db.rsc.schm.MViewLogMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<db:form name="mvLogForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:formValue name="pageName" value="<%= SchemaPages.MVLOG_GENERAL_PG%>"/>
<uix:formValue name="currentUser" valueBinding="schemaName@objectBean@servletRequest"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%@ include file="/database/global.jspf" %>

  <!-- ERROR display -->
  <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

        <!-- Selected Object -->
        <uix:subTabLayout>

        <%-- SubTabs  --%>
        <uix:subTabs>
          <jsp:include page="/database/schema/mvlog/subTabsInclude.jsp" />
          <uix:ref refID="mvLogSubTabsInclude" />
        </uix:subTabs>
        <%-- SubTabs --%>

          <uix:tableLayout cellSpacing="5">
            <!-- Name -->
            <uix:switcher childNameBinding="creating@objectBean@servletRequest">
              <uix:case name="true">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="120">
                    <uix:messagePrompt labeledNodeId="master" required="yes"  promptBinding="SCHEMA_TABLE_LABEL@mvlogMsg"/> 
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:stackLayout>
                      <uix:rowLayout>
                        <uix:messageLovField name="onSchemaAndObject" 
                                             id="master" 
                                             shortDescBinding="SCHEMA_TABLE_LABEL@mvlogMsg"
                                             searchDescBinding="SCHEMA_TABLE_LABEL@mvlogMsg"
                                             textBinding="onSchemaAndObject@objectBean@servletRequest" 
                                             onClick="setSearchFilter('currentUser');startLov('onSchemaAndObject','ListMVLogSchemaTable')"
                                             disabledBinding="disabled@objectBean@servletRequest"
                                             columns="40"/>
                        <uix:submitButton textBinding="MVLOG_POPULATE_COLUMNS@mvlogMsg" 
                                          name="event" 
                                          value="populateColumns"/>
                      </uix:rowLayout>
                      <uix:messageText messageBinding="onSchemaAndObject@errors@servletRequest"
                                       messageType="error"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case> 
            </uix:switcher> 

            <uix:switcher childNameBinding="creating@objectBean@servletRequest">
              <uix:case name="true">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="120">
                    <uix:messagePrompt prompt=""/> 
                  </uix:cellFormat>
                  <uix:styledText styleClass="OraInlineInfoText" 
                    textBinding="SELECT_TABLE_INST@mvlogMsg"/>
                </uix:rowLayout>
              </uix:case> 
            </uix:switcher> 

            <%-- TABLE --%>
            <uix:switcher childNameBinding="creating@objectBean@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="120">
                    <uix:messagePrompt labeledNodeId="table"
                                       promptBinding="TABLE@dbMsg"/> 
                  </uix:cellFormat> 
                  <uix:cellFormat> 
                    <uix:textInput id="table"
                                   name="table" 
                                   textBinding="onTableName@objectBean@servletRequest" 
                                   disabled="true"/>
                  </uix:cellFormat> 
                </uix:rowLayout>
              </uix:case> 
            </uix:switcher> 

            <%-- SCHEMA --%>
            <uix:switcher childNameBinding="creating@objectBean@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="120">
                    <uix:messagePrompt labeledNodeId="schema"
                                       promptBinding="SCHEMA@dbMsg"/> 
                  </uix:cellFormat> 
                  <uix:textInput id="schema"
                                 name="schema" 
                                 textBinding="onSchemaName@objectBean@servletRequest" 
                                 disabled="true"/>
                </uix:rowLayout>
              </uix:case> 
            </uix:switcher> 

                <%-- LOG TABLE --%>
            <uix:switcher childNameBinding="creating@objectBean@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="120">
                    <uix:messagePrompt labeledNodeId="logTable"
                                       promptBinding="LOG_TABLE@mvlogMsg"/> 
                  </uix:cellFormat> 
                  <uix:textInput id="logTable"
                                 name="logTable" 
                                 textBinding="name@objectBean@servletRequest"  
                                 disabled="true"/>
                </uix:rowLayout>
              </uix:case> 
            </uix:switcher> 
 
            <!-- Tablespace Name -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="120">
                <uix:messagePrompt labeledNodeId="tablespace"
                                   required="<%=objectBean.isRequired()%>" 
                                   promptBinding="TABLESPACE@dbMsg"/> 
              </uix:cellFormat>
              <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                <uix:case name="true">
                  <uix:stackLayout>
                    <uix:messageLovField name="tablespace" id="tablespace" 
                                         shortDescBinding="TABLESPACE@dbMsg"
                                         searchDescBinding="TABLESPACE@dbMsg"
                                         textBinding="tablespace@objectBean@servletRequest"
                                         onClick="startLov('tablespace','ListTablespaceAll')"
                                         disabledBinding="disabled@objectBean@servletRequest"/> 
                    <uix:messageText messageBinding="tablespace@errors@servletRequest" 
                                     messageType="error"/>
                  </uix:stackLayout>
                </uix:case> 
                <uix:case name="false">
                  <uix:textInput id="tablespace"
                                 name="tablespace" 
                                 textBinding="tablespace@objectBean@servletRequest" 
                                 disabled="true"/>
                </uix:case> 
              </uix:switcher> 
            </uix:rowLayout>

            <!-- Supported Refresh Types-->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="120">
                <uix:messagePrompt required="<%=objectBean.isRequired()%>"
                                   promptBinding="REFRESH_TYPES@mvlogMsg"/> 
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:stackLayout>
                  <uix:rowLayout>
                    <uix:checkBox name="useRowID" textBinding="ROW_ID@mvlogMsg" 
                                  shortDescBinding="ROW_ID@mvlogMsg"
                                  disabledBinding="disableRowID@objectBean@servletRequest"
                                  checkedBinding="useRowID@objectBean@servletRequest"/>
                    <uix:spacer width="3"/>
                    <uix:checkBox name="usePrimaryKey" textBinding="PRIMARY_KEY@mvlogMsg" 
                                  shortDescBinding="PRIMARY_KEY@mvlogMsg"
                                  disabledBinding="disablePrimaryKey@objectBean@servletRequest" 
                                  checkedBinding="usePrimaryKey@objectBean@servletRequest"/>
                  </uix:rowLayout>
                  <uix:messageText messageBinding="refreshTypes@errors@servletRequest" messageType="error"/>
                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>

            <!-- Value Options -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" vAlign="top" width="120">
                <uix:messagePrompt  prompt=""/> 
              </uix:cellFormat >
              <uix:cellFormat >
              <uix:stackLayout>
                <uix:checkBox name="useNewValue" textBinding="INCLUDE_NEW_VALUES@mvlogMsg" 
                              shortDescBinding="INCLUDE_NEW_VALUES@mvlogMsg"
                              checkedBinding="useNewValue@objectBean@servletRequest"/>
                <uix:checkBox name="useSequenceValue" textBinding="WITH_SEQUENCE_VALUES@mvlogMsg" 
                              shortDescBinding="WITH_SEQUENCE_VALUES@mvlogMsg"
                              checkedBinding="useSequenceValue@objectBean@servletRequest" 
                              disabledBinding="editing@objectBean@servletRequest"/>
              </uix:stackLayout>
              </uix:cellFormat >
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="2"/>
            </uix:rowLayout>

            <!-- Filter Columns -->
            <uix:header size="2" textBinding="FILTER_COLUMNS@mvlogMsg">
              <uix:tableLayout cellSpacing="5">
                <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="true">
                    <uix:rowLayout>
                      <uix:cellFormat width="10"/>
                        <uix:messagePrompt promptBinding="SELECT_COLUMN_INST@mvlogMsg"/>
                    </uix:rowLayout>
                  </uix:case> 
                </uix:switcher>
                <uix:rowLayout>
                  <uix:cellFormat width="10"/>
                  <oem:shuttle name="tableColumns" leadingHeaderBinding="AVAILABLE_COLUMNS@dbMsg" 
                               trailingHeaderBinding="FILTER_COLUMNS@mvlogMsg" size="5" reorderable="true">
                    <uix:leading>
                      <oem:list name="availableColumns" 
                                shortDescBinding="AVAILABLE_COLUMNS@dbMsg"
                                optionsBinding="availableColumns@objectBean@servletRequest" 
                                multiple="true"/> 
                    </uix:leading>
                    <uix:trailing>
                      <oem:list name="filterColumns" 
                                shortDescBinding="SELECTED_COLUMNS@dbMsg"
                                optionsBinding="filterColumns@objectBean@servletRequest"
                                multiple="true"/> 
                    </uix:trailing>
                  </oem:shuttle>
                  <uix:messageText messageBinding="filterColumns@errors@servletRequest" 
                                   messageType="error"/>
                </uix:rowLayout>
              </uix:tableLayout> 
            </uix:header> 

          </uix:tableLayout>
          <uix:spacer height="15"/>
        </uix:subTabLayout>

        <!-- Page Buttons -->
        <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonInclude.jsp" />
          <uix:ref refID="pageButtonInclude" />
        </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>


