<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<jsp:useBean id="segmentBean" scope="request"
   type="oracle.sysman.emo.adm.schema.mvlog.MViewLogSegment"/>
<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.mvlog.MViewLog"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="schmMsg"
              class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<db:form name="mvLogForm"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.MVLOG_OPTIONS_PG%>"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">
  
  <%@ include file="/database/global.jspf" %>

  <!-- ERROR display -->
  <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>


        <uix:subTabLayout>

        <%-- SubTabs  --%>
        <uix:subTabs>
          <jsp:include page="/database/schema/mvlog/subTabsInclude.jsp" />
          <uix:ref refID="mvLogSubTabsInclude" />
        </uix:subTabs>
        <%-- SubTabs --%>

          <uix:tableLayout cellSpacing="3">
         
          <%-- Parallel --%>
          <uix:rowLayout>
            <uix:checkBox name="parallel" checkedBinding="parallel@objectBean@servletRequest" 
                          textBinding="PARALLEL_OPTION@uixMViewLogBundle@servletRequest"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:tableLayout cellSpacing="3">
          <uix:rowLayout>
          <uix:cellFormat width="20"/>
            <uix:messagePrompt labeledNodeId="degree"
                               promptBinding="PARALLEL_DEGREE@schmMsg"/>
            <oem:radioButton name="defaultDegree" value="true" 
                             textBinding="DEFAULT@uixDBObjectBundle@servletRequest" 
                             selectedValueBinding="defaultDegree@objectBean@servletRequest"/>
            <oem:radioButton name="defaultDegree" value="false" 
                             textBinding="VALUE@uixDBObjectBundle@servletRequest" 
                             selectedValueBinding="defaultDegree@objectBean@servletRequest"/>
            <uix:textInput id="degree"
                           name="degree" 
                           textBinding="degree@objectBean@servletRequest" 
                           columns="5" > <!--suppressedValues="-1"/-->
              <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
            </uix:textInput>  
          </uix:rowLayout>
            </uix:tableLayout>
          </uix:rowLayout>

          <%-- CACHE --%>
          <uix:rowLayout>
            <uix:checkBox name="cache" 
                          textBinding="CACHE_OPTION@uixMViewLogBundle@servletRequest"
                          checkedBinding="cache@objectBean@servletRequest"/>
          </uix:rowLayout>
        </uix:tableLayout> 

        <uix:spacer height="20"/>
        </uix:subTabLayout>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>

