<%--
  -- Page:       subTabsInclude.jsp
  -- 
  -- Description: This handles all of the mview log subtabs.
  --              In onEvent any event that starts with "subTab"
  --              will be forwarded to the onSubTab function where
  --              it will be handled.
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="mvLogSubTabsInclude">
<uix:subTabBar selectedIndexBinding="selectedTab@objectBean@servletRequest">

  <%-- General Tab --%>
  <db:link textBinding="GENERAL@uixDBObjectBundle@servletRequest"
           onClick="submitForm('mvLogForm', true, {event:'goto',source:'mvLogNav',value:'1'})"
           copyParams="target,type,cancelURL,sname,oname,otype" />

  <%-- Storage Tab --%>
  <db:link textBinding="STORAGE@uixDBObjectBundle@servletRequest"
           onClick="submitForm('mvLogForm', true, {event:'goto',source:'mvLogNav',value:'2'})"
           copyParams="target,type,cancelURL,sname,oname,otype" />

  <%-- Options Tab --%>
  <db:link textBinding="OPTIONS@uixDBObjectBundle@servletRequest"
           onClick="submitForm('mvLogForm', true, {event:'goto',source:'mvLogNav',value:'3'})"
           copyParams="target,type,cancelURL,sname,oname,otype" />


  <%-- Space Usage Tab --%>
  <uix:switcher childNameBinding="versionEqualOrHigher10i@objectBean@servletRequest">
    <uix:case name="true">
      <uix:switcher childNameBinding="creating@objectBean@servletRequest">
        <uix:case name="false">
          <db:link textBinding="SEGMENTS@uixSchemaBundle@servletRequest"
                   onClick="submitForm('mvLogForm', true, {event:'goto', source:'mvLogNav', value:'4'})"
                   copyParams="target,type,cancelURL,sname,oname,otype"/>
        </uix:case>
      </uix:switcher>
    </uix:case>
  </uix:switcher>

</uix:subTabBar>
</uix:buildTree>

