<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.mvlog.MViewLog"/>
<jsp:useBean id="segmentBean" scope="request"
   type="oracle.sysman.emo.adm.schema.mvlog.MViewLogSegment"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsg"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="schmMsg"
              class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
  <uix:bundle name="mvlogMsg"
              class="oracle.sysman.db.rsc.schm.MViewLogMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="mvLogForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest" 
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.MVLOG_VIEW_PG%>"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

        <!-- GENERAL -->
        <uix:header textBinding="GENERAL@uixDBObjectBundle@servletRequest">

          <!-- Name -->
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="LOG_TABLE@mvlogMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
                <uix:styledText styleClass="OraDataText"
                                textBinding="name@objectBean@servletRequest" />
            </uix:rowLayout>


            <!-- Schema -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/> 
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText"
                              textBinding="onSchemaName@objectBean@servletRequest" />
            </uix:rowLayout>

            <!-- Master Table -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="MASTER_TABLE@mvlogMsg"/> 
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText"
                              textBinding="onTableName@objectBean@servletRequest" />
            </uix:rowLayout>

            <!-- Tablespace Name -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="TABLESPACE@uixDBObjectBundle@servletRequest"/> 
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText"
                              textBinding="tablespace@objectBean@servletRequest" />
            </uix:rowLayout>


            <!-- Supported Refresh Types-->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150" wrappingDisabled="true">
                <uix:messagePrompt promptBinding="REFRESH_TYPES@mvlogMsg"/> 
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText"
                              textBinding="refreshTypesText@objectBean@servletRequest" />
            </uix:rowLayout>


            <!-- Value Options -->
            <uix:switcher childNameBinding="hasValueOptions@objectBean@servletRequest">
              <uix:case name="true">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="150">
                    <uix:messagePrompt promptBinding="VALUE_OPTIONS@mvlogMsg"/> 
                  </uix:cellFormat >
                  <uix:cellFormat>
                    <uix:spacer height="2" width="5" />
                  </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="valueOptionsText@objectBean@servletRequest" />
                </uix:rowLayout>
              </uix:case> 
            </uix:switcher> 
            </uix:tableLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right" vAlign="top" width="150">
                <uix:messagePrompt promptBinding="FILTER_COLUMNS@mvlogMsg"/> 
              </uix:cellFormat >
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText"
                              textBinding="filterColumnsText@objectBean@servletRequest" />
            </uix:rowLayout>
          </uix:header>
          <!-- END GENERAL -->

        <!-- OPTIONS TAB -->
        <uix:header textBinding="OPTIONS@dbMsg">

          <!-- Parallel -->
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="PARALLEL_DEGREE@schmMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:switcher childNameBinding="parallel@objectBean@servletRequest">
                <uix:case name="true">
                  <uix:switcher childNameBinding="defaultDegree@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:styledText styleClass="OraDataText"
                                      textBinding="DEFAULT@mvlogMsg" />
                    </uix:case>
                    <uix:case name="false">
                      <uix:styledText styleClass="OraDataText"
                                      textBinding="degree@objectBean@servletRequest" />
                    </uix:case>
                  </uix:switcher> 
                </uix:case> 
                <uix:case name="false"> 
                  <uix:styledText styleClass="OraDataText" textBinding="DISABLED@dbMsg"/>
                </uix:case> 
              </uix:switcher>
            </uix:rowLayout>

            <!-- Cache -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="CACHE@dbMsg"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText"
                              textBinding="cache@objectBean@servletRequest" />
            </uix:rowLayout>
          </uix:tableLayout>
    </uix:header>
    <!-- END: STORAGE TAB -->

    <!-- STORAGE TAB -->
    <uix:header textBinding="STORAGE@uixDBObjectBundle@servletRequest">
      <uix:dataScope currentDataBinding="segmentBean@servletRequest">
         <jsp:include page="/database/schema/utilities/viewStorageContextInclude.jsp" />
         <uix:ref refID="viewStorageInclude" />
      </uix:dataScope> 
    </uix:header>

  <%-- View Buttons --%>
  <uix:pageButtons>
     <uix:pageButtonBar>
       <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
         <uix:case name="false">
           <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
           <uix:ref refID="pageButtonViewInclude" />
        </uix:case>
         <uix:case name="true">
         <%-- OK Button --%>
         <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
         </uix:case>
       </uix:switcher>
     </uix:pageButtonBar>
   </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>

