<%@ include file="/sdk/oemTop.jspf" %>

<%--
  -- Page:       objPrivsDeleteOptionsPage.jsp
  -- Controller: db/adm/schm/ObjPrivsController.java
  --
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<db:script src="/database/utils.js"/>

<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="schmMsgs" class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>

  <uix:body>
    <db:form name="delOptionsForm" 
             method="post" 
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype" >
    <uix:formValue name="pageName" 
                   value="<%= SchemaPages.REVOKE_OBJ_PRIV_OPT_PG%>"/>
    <uix:contents>
    <uix:pageLayout titleBinding="header@objectBean@servletRequest"> 

      <%-- Oracle Logo and Tabs --%>
      <%@ include file="/database/globalPopup.jspf" %>

        <uix:tableLayout> 
          <uix:spacer height="8"/> 

        <%-- Add Button --%>
          <uix:rowLayout>
            <uix:cellFormat width="20"/>
            <uix:messagePrompt promptBinding="revokeOptionsText@objectBean@servletRequest"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer height="5"/> 
          </uix:rowLayout>
          <uix:rowLayout renderedBinding="removingRefPriv@objectBean@servletRequest">
            <uix:cellFormat width="20"/>
            <uix:checkBox name="cascade" 
                          textBinding="REVOKE_PRIV_CASCADE_OPT@schmMsgs"
                          checked="true"/>
          </uix:rowLayout>
          <uix:rowLayout renderedBinding="removingExecPriv@objectBean@servletRequest">
            <uix:cellFormat width="20"/>
            <uix:checkBox name="force" 
                          textBinding="REVOKE_PRIV_FORCE_OPT@schmMsgs"
                          checked="true"/>
          </uix:rowLayout>
        </uix:tableLayout>

      <%-- Create/Edit Buttons --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout>
              <uix:submitButton textBinding="RETURN@dbMsgs"
                                shortDescBinding="RETURN@dbMsgs"
                                name="event" 
                                value="cancelOp"/>
              <uix:submitButton textBinding="CONTINUE@dbMsgs" 
                                shortDescBinding="CONTINUE@dbMsgs"
                                name="event" 
                                value="applyRevokeOption"/>
            </uix:rowLayout>
          </uix:tableLayout> 
        </uix:pageButtonBar>
      </uix:pageButtons>

    </uix:pageLayout>
    </uix:contents>
  </db:form>
</uix:body>
</uix:document>
</uix:renderingContext>

