<%@ include file="/sdk/oemTop.jspf" %>

<%--
  -- Page:       objPrivsMainPage.jsp
  -- Controller: db/adm/schm/ObjPrivsController.java
  --
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/utils.js"/>

<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="schmMsgs" class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
  <db:script src="/database/utils.js"/>   
</uix:metaContainer>

  <uix:body>
    <db:form name="objPrivsForm" 
             method="post" 
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype" >
    <uix:formValue name="pageName" value="<%= SchemaPages.OBJECT_PRIVS_MAIN_PG%>"/>
    <uix:pageLayout titleBinding="header@objectBean@servletRequest">

      <%-- Oracle Logo and Tabs --%>
      <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" 
                        mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest" 
                        titleTextKey="titleText" 
                        mainTextKey="mainText"/>

        <uix:tableLayout> 
          <uix:spacer height="10"/> 

          <%-- Add Button --%>
          <uix:rowLayout>
            <uix:cellFormat width="100%"/>
            <uix:cellFormat hAlign="right" width="100%">
              <uix:submitButton textBinding="ADD@dbMsgs"
                                shortDescBinding="GRANT_NEW_PRIV_TXT@schmMsgs"
                                name="event"
                                value="grantNewPriv"/> 
            </uix:cellFormat> 
          </uix:rowLayout>

          <uix:tableLayout>
            <uix:dataScope currentDataBinding="objPrivsDS@servletRequest">
              <uix:table id="objPrivsTable"
                         alternateTextBinding="NO_PRIVS_GRANTED_ON_OBJ@dbMsgs"
                         formSubmitted="true"
                         width="100%"
                         tableDataBinding="rowData"
                         minValue="1"
                         valueBinding="startIndex"
                         maxValueBinding="numRows"
                         blockSizeBinding="blockSize"
                         summary="Object Privileges">
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:tableSelection>
                  <uix:multipleSelection selectedBinding="select" shortDescBinding="SELECT@dbMsgs">
                    <uix:submitButton textBinding="DELETE@dbMsgs"
                                      shortDescBinding="DELETE_OBJ_PRIV_TXT@schmMsgs"
                                      name="event"
                                      value="revokePriv"/>
                  </uix:multipleSelection >
                </uix:tableSelection>

                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="PRIVILEGE@schmMsgs"
                                        sortableBinding="privilegeSort"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="privilege"/>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="GRANTEE@schmMsgs"
                                        sortableBinding="granteeSort"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="grantee"/>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="GRANTOR@schmMsgs"
                                        sortableBinding="grantorSort"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="grantor"/>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="GRANT_OPTION@schmMsgs"
                                        sortableBinding="grantOptSort"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                  <uix:checkBox name="grant"
                                shortDescBinding="GRANT_OPTION@schmMsgs"
                                checkedBinding="grantable"/>
                </uix:column>
              </uix:table>
            </uix:dataScope> 
          </uix:tableLayout>
      </uix:tableLayout>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
    <uix:pageButtonBar>
      <uix:tableLayout cellSpacing="5">
        <uix:rowLayout>
          <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" 
                            shortDescBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                            name="event" 
                            value="showSql" />
          <uix:submitButton textBinding="REVERT@uixDBObjectBundle@servletRequest"
                            shortDescBinding="REVERT@uixDBObjectBundle@servletRequest"
                            name="event" 
                            value="revert" />
          <uix:submitButton textBinding="APPLY@uixDBObjectBundle@servletRequest" 
                            shortDescBinding="APPLY@uixDBObjectBundle@servletRequest"
                            name="event" 
                            value="apply"/>
          <uix:button textBinding="RETURN@dbMsgs" 
                            destinationBinding="cancelURL@servletRequest"/>
        </uix:rowLayout>
      </uix:tableLayout> 
    </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
</uix:body>
</uix:document>
</uix:renderingContext>

