<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/objecttype/OTAttrAddPage"/>
<uix:formValue name="action" valueBinding="action@servletRequest"/>
<uix:pageLayout titleBinding="ADD_PREDEFINED_ATR@uixObjecttypeBundle@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <%-- START: TAB CONTENTS starts here --%>

            <uix:labeledFieldLayout labelWidth="1%">
              <uix:contents>
                <%-- name --%>
                  <uix:messagePrompt labeledNodeId="OTAttrName"
                                     promptBinding="NAME@uixDBObjectBundle@servletRequest" 
                                     required="yes"/>
                  <uix:rowLayout>
                   <uix:contents>
                     <uix:stackLayout>
                     <uix:textInput name="OTAttrName" 
                                    id="OTAttrName" 
                                    textBinding="OTAttrName@objectBean@servletRequest" 
                                    columns="30"/>
                     <uix:messageText messageBinding="OTAttrName@errors@requestServlet" messageType="error"/>
                   </uix:stackLayout>
                  </uix:contents>
                </uix:rowLayout>
                
                <%-- type --%>
                  <uix:messagePrompt promptBinding="TYPE@uixDBObjectBundle@servletRequest" labeledNodeId="TYPE"/>
                  <oem:choice name="OTAttrTypeName" 
                              selectedValueBinding="OTAttrTypeName@objectBean@servletRequest"
                              id="TYPE"
                              optionsBinding="predefinedTypes@objectBean@servletRequest"/>


 		  <%-- type length --%>
                  <uix:messagePrompt labeledNodeId="OTAttrTypeLength"
                                     promptBinding="LENGTH@uixObjecttypeBundle@servletRequest"/>
                  <uix:rowLayout>
                   <uix:contents>
                    <uix:stackLayout>
                     <uix:contents>
                      <uix:textInput id="OTAttrTypeLength"
                                     name="OTAttrTypeLength" 
                                     textBinding="OTAttrTypeLength@objectBean@servletRequest" 
                                     columns="30"/>
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="APPLIES_LENGTH@uixDBObjectBundle@servletRequest"/>
                     </uix:contents>
                    </uix:stackLayout>
                    <uix:messageText  messageBinding="OTAttrTypeLength@errors@requestServlet" messageType="error"/>
                   </uix:contents>
                  </uix:rowLayout>
                
                  <%-- precision --%>
                       <uix:messagePrompt labeledNodeId="precision"
                                          promptBinding="PRECISION@uixObjecttypeBundle@servletRequest"/>
                    <uix:rowLayout>
                    <uix:contents>
                    <uix:stackLayout>
                     <uix:contents>
                      <uix:textInput id="precision"
                                     name="OTAttrTypePrecision"
                                     textBinding="OTAttrTypePrecision@objectBean@servletRequest"
                                     columns="30"/>
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="APPLIES_NUMBER@uixDBObjectBundle@servletRequest"/>
                     </uix:contents>
                    </uix:stackLayout>
                   <uix:messageText messageBinding="OTAttrTypePrecision@errors@requestServlet" messageType="error"/>
                  </uix:contents>
                </uix:rowLayout>
         
              </uix:contents>
            </uix:labeledFieldLayout>


    <%-- END: TAB CONTENTS ends here --%>   
        

  
<uix:pageButtons>
<uix:pageButtonBar>

<uix:switcher childNameBinding="action@servletRequest">
  <uix:case name="add">
    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelAddAttr"/>
  </uix:case>
  <uix:case name="edit">
    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelEditAttr" />
  </uix:case>
</uix:switcher>
<uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="finishAttr" />

</uix:pageButtonBar>
</uix:pageButtons>


</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




