<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="otypeMsgs"
            class="oracle.sysman.db.rsc.schm.ObjectTypeMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/objecttype/OTAttrUDPage"/>
<uix:formValue name="action" valueBinding="action@servletRequest"/>
<uix:formValue name="schemaName" valueBinding="schemaName@objectBean@servletRequest"/>
<uix:pageLayout titleBinding="EDIT_USERDEFINED_ATR@otypeMsgs">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <%-- START: TAB CONTENTS starts here --%>
    <uix:labeledFieldLayout fieldWidth="0%" labelWidth="0%" width="0%">
      <uix:contents>
      
        <%-- name --%>
        <uix:messagePrompt labeledNodeId="OTAttrName"
                           promptBinding="NAME@dbMsgs"
                           required="yes"/>
        <uix:stackLayout>
          <uix:contents>
            <uix:textInput id="OTAttrName"
                           name="OTAttrName" 
                           textBinding="OTAttrName@objectBean@servletRequest" 
                           columns="30"/>
            <uix:messageText messageBinding="OTAttrName@errors@servletRequest" messageType="error"/>
          </uix:contents>
        </uix:stackLayout>
                
        <%-- type name --%>
        <uix:messagePrompt labeledNodeId="STYPE"
                           promptBinding="SCHEMA_TYPE@otypeMsgs" required="yes"/>
        <uix:stackLayout>
          <uix:contents>  
            <uix:lovField name="OTAttrFullObjectName"
                          id="STYPE"
                          shortDescBinding="SCHEMA_TYPE@otypeMsgs"
                          textBinding="OTAttrFullObjectName@objectBean@servletRequest" 
                          onClick="setSearchFilter('schemaName');startLov('OTAttrFullObjectName','ListObjecttype')"/>
            <uix:messageText messageBinding="fullObjectName@errors@servletRequest" messageType="error"/>
          </uix:contents>
        </uix:stackLayout>
        
         <%-- Ref --%>
        <uix:checkBox name="OTAttrTypeRef" 
                      shortDescBinding="TYPE_REF@otypeMsgs"
                      checkedBinding="OTAttrTypeRef@objectBean@servletRequest" />
        <uix:messagePrompt promptBinding="TYPE_REF@otypeMsgs"/>

      </uix:contents>
    </uix:labeledFieldLayout>
    <%-- END: TAB CONTENTS ends here --%>   
        

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
                <uix:switcher childNameBinding="action@servletRequest">
                <uix:case name="add">
                    <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancelAddAttr"/>  
                  </uix:case>
                  <uix:case name="edit">
                    <uix:submitButton  textBinding="CANCEL@dbMsgs" name="event" value="cancelEditAttr"/>  
                  </uix:case>
                </uix:switcher> 
                <uix:submitButton textBinding="OK@dbMsgs" name="event" value="finishAttrEdit"/>
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




