<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="otypeMsgs"
            class="oracle.sysman.db.rsc.schm.ObjectTypeMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/objecttype/OTMethMainPage"/>
<uix:formValue name="s_name" valueBinding="schemaName@objectBean@servletRequest"/>
<uix:formValue name="action" valueBinding="action@servletRequest"/>
<uix:pageLayout titleBinding="methodHeader@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
                <uix:subTabBar selectedIndex="0">
                  <uix:contents>
                    <db:link textBinding="GENERAL@otypeMsgs"
                             copyParams="target,type,cancelURL,sname,oname,otype" />
                    <db:link textBinding="BODY@otypeMsgs"
                             onClick="submitForm('foo', true, {event:'gotoValue2'})"
                             copyParams="target,type,cancelURL,sname,oname,otype" />
                    <db:link textBinding="PRAGMA@otypeMsgs"
                             onClick="submitForm('foo', true, {event:'gotoValue3'})"
                             copyParams="target,type,cancelURL,sname,oname,otype" />
                  </uix:contents>
                </uix:subTabBar>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>

                <uix:header textBinding="GENERAL@dbMsgs"/>
                  <uix:tableLayout cellSpacing="5">
                    <%-- name --%>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat hAlign="right">
                            <uix:messagePrompt labeledNodeId="OTMethName"
                                               promptBinding="NAME@dbMsgs" 
                                               required="yes"/>
                          </uix:cellFormat>
                          <uix:stackLayout>
                            <uix:textInput id="OTMethName"
                                           name="OTMethName" 
                                           textBinding="OTMethName@objectBean@servletRequest"
                                           columns="30"/>
                            <uix:messageText messageBinding="OTMethName@errors@servletRequest" messageType="error"/>
                          </uix:stackLayout>
                        </uix:contents>
                      </uix:rowLayout>
                      <%-- method type --%>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat hAlign="right">
                            <uix:messagePrompt promptBinding="METHOD_TYPE@otypeMsgs" labeledNodeId="METHOD_TYPE"/>
                          </uix:cellFormat>
                          <oem:choice name="OTMethType"
                              id="METHOD_TYPE"
                              selectedValueBinding="OTMethType@objectBean@servletRequest" optionsBinding="OTMethTypeChoices@objectBean@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
                    </uix:tableLayout>

                <%-- Parameters --%>
                <uix:header textBinding="PARAMETERS@otypeMsgs">
                  <%-- add --%>
                  <uix:rowLayout hAlign="right">
                    <uix:messagePrompt promptBinding="PARAMETER_TYPE@otypeMsgs" labeledNodeId="PARAMETER_TYPE"/>
                    <uix:spacer width="5"/>
<%--
                    <oem:choice name="tempType"
                          selectedValueBinding="tempType@objectBean@servletRequest" optionsBinding="allPredefinedTypes@objectBean@servletRequest"/>
--%>
                    <oem:choice name="predefinedType"
                          id="PARAMETER_TYPE"
                          selectedValueBinding="predefinedType@objectBean@servletRequest" optionsBinding="allPredefinedTypes@objectBean@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:submitButton textBinding="ADD@dbMsgs" name="event" value="addParam"/>
                  </uix:rowLayout>
                  <uix:spacer height="25"/>
              
                  <uix:spacer height="25"/>
                  <oem:table name="OTMethParameterUIDataSource" 
                             beanKey="objectBean" 
                             destinationBinding="destination@objectBean@servletRequest"
                             formSubmitted="true" 
                             dataSourceProp="OTMethParameterUIDataSource" 
                             width="100%"
                             blockSize="10"
                             summaryBinding="PARAMETERS@otypeMsgs"
                             copyParams="target,type,cancelURL,sname,oname,otype">
                    <uix:tableSelection>
                    <uix:singleSelection shortDescBinding="SELECT_A_VALUE@dbMsgs"
                                         selectedIndexBinding="OTMethParamSelectedIndexUI@objectBean@servletRequest">
                      <uix:submitButton textBinding="EDIT@dbMsgs" name="event" value="editParam"/>
                      <uix:submitButton textBinding="DELETE@dbMsgs" name="event" value="deleteParam"/>
                    </uix:singleSelection>
                   </uix:tableSelection>
                  </oem:table>
                </uix:header>
                
                <%-- RETURN TYPE --%>
                <uix:header textBinding="RETURN_TYPE@otypeMsgs">
                  <%--  choose predefined type  --%>
                  <uix:rowLayout>
                    <uix:contents>
                      <oem:radioButton 
                          name="OTMethUserRetType" value="false"
                          textBinding="CHOOSE_PREDEF_TYPE@otypeMsgs"
                          selectedValueBinding="OTMethUserRetType@objectBean@servletRequest"/>
                    </uix:contents>
                  </uix:rowLayout>
                
                <uix:tableLayout cellSpacing="5">
              <uix:contents>
              
              <%-- predefined type name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat width="10">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="TYPE@otypeMsgs" labeledNodeId="RETURN_TYPE"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <oem:choice name="OTMethRetTypeName" 
                          id="RETURN_TYPE"
                          selectedValueBinding="OTMethRetTypeName@objectBean@servletRequest" optionsBinding="predefinedTypes@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:tableLayout>
              
              <%-- user types--%>
                <uix:rowLayout>
                  <uix:contents>
                     <oem:radioButton 
                    	name="OTMethUserRetType" value="true"
                      textBinding="CHOOSE_USER_TYPE@otypeMsgs" 
                      selectedValueBinding="OTMethUserRetType@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

            <uix:tableLayout cellSpacing="5">
              <uix:contents>

                 <%-- type name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat width="10">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="TYPE" 
                                           promptBinding="TYPE@otypeMsgs"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:lovField name="OTMethRetFullObject" 
                                  id="TYPE"
                                  shortDescBinding="TYPE@otypeMsgs" 
                                  searchDescBinding="TYPE@otypeMsgs" 
                                  textBinding="OTMethRetFullObject@objectBean@servletRequest" 
                                  onClick="setSearchFilter('s_name');startLov('OTMethRetFullObject','ListObjecttype')"/>
                    <uix:messageText messageBinding="OTMethRetFullObject@errors@servletRequest" messageType="error"/>
                  </uix:contents>
                </uix:rowLayout>

              <%-- ref --%>
                <uix:rowLayout>
            				<uix:contents>
                    <uix:cellFormat width="10">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
               	      <uix:checkBox name="OTMethRetTypeRef" 
                                    shortDescBinding="TYPE_REF@otypeMsgs"
                                    checkedBinding="OTMethRetTypeRef@objectBean@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                     <uix:contents>
                      <uix:messagePrompt promptBinding="TYPE_REF@otypeMsgs"/>
                     </uix:contents>
                    </uix:cellFormat>
                    </uix:contents>
        				</uix:rowLayout>
                
              </uix:contents>
            </uix:tableLayout>
            
                <%-- test --%>
                <uix:spacer height="10"/>
                 <uix:rowLayout>
                  <uix:contents>
                    <uix:tip>
                    <uix:messagePrompt
                        promptBinding="NOT_PROCEDURE@otypeMsgs" required="no"/> 
                    </uix:tip>                 
                  </uix:contents>
                </uix:rowLayout>
                </uix:header>


    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:switcher childNameBinding="action@servletRequest">
      <uix:case name="add">
        <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancelAddMeth"/>  
      </uix:case>
      <uix:case name="edit">
        <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancelEditMeth"/>  
      </uix:case>
    </uix:switcher> 
    <uix:submitButton textBinding="OK@dbMsgs" name="event" value="finishMeth"/>
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




