<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="header@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo"
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/objecttype/OTMethPragmaPage"/>
<uix:formValue name="action" valueBinding="action@servletRequest"/>

<uix:pageLayout titleBinding="methodHeader@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
              <uix:subTabBar selectedIndex="2">
                <uix:contents>
                  <db:link textBinding="GENERAL@uixObjecttypeBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'gotoValue1'})"
                           copyParams="target,type,cancelURL,sname,oname,otype" />
                  <db:link textBinding="BODY@uixObjecttypeBundle@servletRequest"
                           onClick="submitForm('foo', true, {event:'gotoValue2'})"
                           copyParams="target,type,cancelURL,sname,oname,otype" />
                  <db:link textBinding="PRAGMA@uixObjecttypeBundle@servletRequest"
                           copyParams="target,type,cancelURL,sname,oname,otype" />
                </uix:contents>
              </uix:subTabBar>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>
            <uix:tableLayout cellSpacing="5">

                <%-- WNDS --%>

                  <uix:rowLayout>
            				<uix:contents>
               				<uix:checkBox name="OTMethWNDS" 
                       textBinding="WNDS@uixObjecttypeBundle@servletRequest"
                        checkedBinding="OTMethWNDS@objectBean@servletRequest"/>
                    </uix:contents>
                  </uix:rowLayout>

                <%-- WNPS --%>

                  <uix:rowLayout>
            				<uix:contents>
               				<uix:checkBox name="OTMethWNPS" 
                       textBinding="WNPS@uixObjecttypeBundle@servletRequest"
                        checkedBinding="OTMethWNPS@objectBean@servletRequest"/>
                    </uix:contents>
                  </uix:rowLayout>

                <%-- RNDS --%>

                  <uix:rowLayout>
            				<uix:contents>
               				<uix:checkBox name="OTMethRNDS" 
                       textBinding="RNDS@uixObjecttypeBundle@servletRequest"
                        checkedBinding="OTMethRNDS@objectBean@servletRequest"/>
                    </uix:contents>
                  </uix:rowLayout>


                <%-- RNPS --%>

                  <uix:rowLayout>
            				<uix:contents>
               				<uix:checkBox name="OTMethRNPS" 
                       textBinding="RNPS@uixObjecttypeBundle@servletRequest"
                        checkedBinding="OTMethRNPS@objectBean@servletRequest"/>
                    </uix:contents>
                  </uix:rowLayout>

              </uix:tableLayout>

    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
                  <uix:switcher childNameBinding="action@servletRequest">
                <uix:case name="add">
                    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelAddMeth"/>  
                  </uix:case>
                  <uix:case name="edit">
                    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelEditMeth"/>  
                  </uix:case>
                </uix:switcher> 
                <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="finishMeth"/>
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




