<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="paramTitle@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/objecttype/OTParamPredefPage"/>
<uix:formValue name="action" valueBinding="action@servletRequest"/>
<uix:pageLayout titleBinding="paramHeader@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>


         <uix:labeledFieldLayout labelWidth="1%">
           <%-- name --%>
           <uix:messagePrompt labeledNodeId="OTMethParamName"
                              promptBinding="NAME@uixDBObjectBundle@servletRequest" 
                              required="yes"/>
           <uix:rowLayout>
             <uix:stackLayout>
               <uix:textInput id="OTMethParamName"
                              name="OTMethParamName" 
                              textBinding="OTMethParamName@objectBean@servletRequest"
                              columns="30"/>           
               <uix:messageText messageBinding="OTMethParamName@errors@servletRequest" messageType="error"/>
             </uix:stackLayout>
           </uix:rowLayout>
                
           <%-- type --%>
           <uix:messagePrompt promptBinding="TYPE@uixDBObjectBundle@servletRequest" labeledNodeId="TYPE"/>
<%--
           <uix:switcher childNameBinding="action@servletRequest">
             <uix:case name="add">
               <oem:choice name="OTMethParamPredefTypeName" 
                           selectedValueBinding="paramType@objectBean@servletRequest"
                           optionsBinding="predefinedTypes@objectBean@servletRequest"/>
                           
             </uix:case>
             <uix:case name="edit">
             <oem:choice name="OTMethParamPredefTypeName"
                              selectedValueBinding="paramType@objectBean@servletRequest"
                              optionsBinding="predefinedTypes@objectBean@servletRequest"/>
             </uix:case>
           </uix:switcher> 
--%>
             <oem:choice name="OTMethParamPredefTypeName"
                         id="TYPE"
                         shortDescBinding="TYPE@uixObjecttypeBundle@servletRequest"
                              selectedValueBinding="paramType@objectBean@servletRequest"
                              optionsBinding="predefinedTypes@objectBean@servletRequest"/>
                

 	   <%-- direction --%>
           <uix:messagePrompt promptBinding="DIRECTION@uixObjecttypeBundle@servletRequest" labeledNodeId="DIRECTION"/>
           <oem:choice name="OTMethParamDirection"
                       id="DIRECTION"
                       shortDescBinding="DIRECTION@uixObjecttypeBundle@servletRequest"
                       selectedValueBinding="direction@objectBean@servletRequest"
                       optionsBinding="directions@objectBean@servletRequest"/>
         </uix:labeledFieldLayout>

         <%-- Create/Edit Buttons --%>
         <uix:pageButtons>
           <uix:pageButtonBar>
             <uix:switcher childNameBinding="action@servletRequest">
               <uix:case name="add">
                 <uix:submitButton  textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelAddParam"/>  
               </uix:case>
               <uix:case name="edit">
                 <uix:submitButton  textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelEditParam"/>  
               </uix:case>
             </uix:switcher> 
             <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="finishParam"/>
           </uix:pageButtonBar>
         </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




