<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="otypeMsgs"
            class="oracle.sysman.db.rsc.schm.ObjectTypeMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="paramTitle@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/objecttype/OTParamUserDefPage"/>
<uix:formValue name="schemaName" valueBinding="schemaName@objectBean@servletRequest"/>
<uix:formValue name="action" valueBinding="action@servletRequest"/>
<%--uix:pageLayout titleBinding="ADD_USERDEFINED_PARAM@otypeMsgs"--%>
<uix:pageLayout titleBinding="paramHeader@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>


  <uix:labeledFieldLayout fieldWidth="0%" labelWidth="0%" width="0%">
    <%-- name --%>
    <uix:messagePrompt labeledNodeId="OTMethParamName"
                       promptBinding="NAME@dbMsgs" 
                       required="yes"/>
    <uix:stackLayout>
      <uix:textInput id="OTMethParamName"
                     name="OTMethParamName"
                     textBinding="OTMethParamName@objectBean@servletRequest"
                     columns="30"/>
      <uix:messageText messageBinding="OTMethParamName@errors@servletRequest" messageType="error"/>
    </uix:stackLayout>
                
    <%-- type name --%>
    <uix:messagePrompt labeledNodeId="STYPE"
                       promptBinding="SCHEMA_TYPE@otypeMsgs"required="yes"/>
    <uix:rowLayout>
      <uix:stackLayout>
        <uix:lovField name="OTMethParamFullObjectName" 
                      id="STYPE"
                      shortDescBinding="SCHEMA_TYPE@otypeMsgs"
                      searchDescBinding="SCHEMA_TYPE@otypeMsgs"
                      textBinding="OTMethParamFullObjectName@objectBean@servletRequest"
                      onClick="setSearchFilter('schemaName');startLov('OTMethParamFullObjectName','ListObjecttype')"/>
        <uix:messageText messageBinding="OTMethParamFullObjectName@errors@servletRequest" messageType="error"/>
      </uix:stackLayout>
    </uix:rowLayout>

<%--
    <uix:switcher childNameBinding="action@servletRequest">
      <uix:case name="edit">
        <uix:checkBox name="OTMethParamTypeRef" 
                      shortDescBinding="TYPE_REF@otypeMsgs"
                      checkedBinding="OTMethParamTypeRef@objectBean@servletRequest"/>
      </uix:case>
      <uix:case name="add">
        <uix:checkBox name="OTMethParamTypeRef" 
                      shortDescBinding="TYPE_REF@otypeMsgs"
                      checked="false"/>
      </uix:case>
    </uix:switcher>     
--%>
        <uix:checkBox name="OTMethParamTypeRef" 
                      shortDescBinding="TYPE_REF@otypeMsgs"
                      checkedBinding="OTMethParamTypeRef@objectBean@servletRequest"/>
    <uix:messagePrompt promptBinding="TYPE_REF@otypeMsgs"/>
        	
    <%-- direction --%>
    <uix:messagePrompt promptBinding="DIRECTION@otypeMsgs" labeledNodeId="DIRECTION"/>
    <oem:choice name="OTMethParamDirection"
                id="DIRECTION"
                selectedValueBinding="direction@objectBean@servletRequest"
                optionsBinding="directions@objectBean@servletRequest"/>
  </uix:labeledFieldLayout>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:switcher childNameBinding="action@servletRequest">
      <uix:case name="add">
        <uix:submitButton  textBinding="CANCEL@dbMsgs" name="event" value="cancelAddParam"/>  
      </uix:case>
      <uix:case name="edit">
        <uix:submitButton  textBinding="CANCEL@dbMsgs" name="event" value="cancelEditParam"/>  
      </uix:case>
    </uix:switcher> 
    <uix:submitButton textBinding="OK@dbMsgs" name="event" value="finishParam"/>

  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




