<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.objtype.objecttype.ObjectType"/>


<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="objectTypeMsgs"
            class="oracle.sysman.db.rsc.schm.ObjectTypeMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>

<uix:body>
<%-- HTML Form --%>
<db:form name="foo" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/objecttype/editObjectTypePage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>


    <%-- START: TAB CONTENTS starts here --%>

      <uix:header  textBinding="GENERAL@dbMsgs">

                    <uix:switcher childNameBinding="creatingObject@objectBean@servletRequest">
                      <uix:case name="true">
                      <uix:tableLayout cellSpacing="5">
                       <uix:contents>

                        <%-- name --%>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:messagePrompt labeledNodeId="objectName"
                                                 promptBinding="NAME@dbMsgs" 
                                                 required="yes"/>
                            </uix:cellFormat>
                            <uix:stackLayout>
                              <uix:textInput id="objectName"
                                             name="objectName" 
                                             textBinding="objectName@objectBean@servletRequest"
                                             columns="30"/>
                              <uix:messageText messageBinding="objectName@errors@servletRequest" messageType="error"/>
                            </uix:stackLayout>
                          </uix:contents>
                        </uix:rowLayout>
                        <%-- schema name --%>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right">
                              <uix:messagePrompt labeledNodeId="SCHEMA"
                                                 promptBinding="SCHEMA@dbMsgs" 
                                                 required="yes"/>
                            </uix:cellFormat>
                            <uix:lovField name="schemaName"
                                          id="SCHEMA"
                                          shortDescBinding="SCHEMA@dbMsgs"
                                          searchDescBinding="SCHEMA@dbMsgs"
                                          textBinding="schemaName@objectBean@servletRequest"
                                          onClick="startLov('schemaName','ListSchema')"/>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                      </uix:tableLayout>
                      </uix:case>
                       
                      <uix:case name="false">
    
                   <uix:tableLayout cellSpacing="5">
                     <uix:contents>

                      <%-- name --%>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat hAlign="right">
                            <uix:messagePrompt promptBinding="NAME@dbMsgs"/>
                          </uix:cellFormat>
                          <uix:styledText styleClass="OraDataText" textBinding="objectName@objectBean@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
                      <%-- schema name --%>
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat hAlign="right">
                            <uix:messagePrompt promptBinding="SCHEMA@dbMsgs"/>
                          </uix:cellFormat>
                          <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>
                        </uix:contents>
                      </uix:rowLayout>
                     </uix:contents>
                   </uix:tableLayout>
                   </uix:case>
                  </uix:switcher>
                  <uix:rowLayout renderedBinding="areErrors@objectBean@servletRequest" hAlign="right">
                    <uix:submitButton textBinding="SHOW_ERRORS@dbMsgs"
                                      name="event" 
                                      value="showErrors"/>   
                  </uix:rowLayout>
            </uix:header>


          <uix:header textBinding="ATTRIBUTES@uixObjecttypeBundle@servletRequest">
            <uix:stackLayout>
             <uix:rowLayout hAlign="right">
              <uix:flowLayout>
                <uix:styledText styleClass="OraPromptText" textBinding="DATATYPE@objectTypeMsgs"/>
                <oem:choice name="addOTAttrType"
                            shortDescBinding="ATTRIBUTES@uixObjecttypeBundle@servletRequest"
                            optionsBinding="OTAttrObjectTypeChoices@objectBean@servletRequest"/>
                <uix:submitButton textBinding="ADD@dbMsgs" name="event" value="addAttr"/>
              </uix:flowLayout>
             </uix:rowLayout>
             <uix:messageText messageBinding="Attributes@errors@servletRequest" messageType="error"/>
            </uix:stackLayout>
              
               
              <uix:spacer height="25"/>
              <oem:table name="OTAttrUIDataSource"  
                         beanKey="objectBean" 
                         destinationBinding="destination@objectBean@servletRequest"
                         formSubmitted="true" 
                         dataSourceProp="OTAttrUIDataSource" 
                         blockSize="10" 
                         width="100%"
                         summaryBinding="ATTRIBUTES@uixObjecttypeBundle@servletRequest"
                         copyParams="target,type,cancelURL,sname,oname,otype">
               <uix:tableSelection >
                <uix:singleSelection shortDescBinding="SELECT_A_VALUE@dbMsgs"
                                     selectedIndexBinding="OTAttrSelectedIndexUI@objectBean@servletRequest">
                  <%-- <uix:submitButton text="Insert Before" name="event" value="insert"/> --%>
                  <uix:submitButton textBinding="EDIT@dbMsgs" name="event" value="editAttr"/>
                  <uix:submitButton textBinding="DELETE@dbMsgs" name="event" value="deleteAttr"/>
                </uix:singleSelection>
               </uix:tableSelection>
              </oem:table>
          </uix:header>
          
            <uix:header textBinding="METHODS@uixObjecttypeBundle@servletRequest">
						
             <uix:rowLayout hAlign="right">
                <uix:submitButton textBinding="ADD@dbMsgs" name="event" value="addMeth"/>
              </uix:rowLayout>
              <uix:spacer height="25"/>
              <oem:table name="OTMethUIDataSource" 
                         beanKey="objectBean" 
                         destinationBinding="destination@objectBean@servletRequest"
                         formSubmitted="true" 
                         summaryBinding="METHODS@uixObjecttypeBundle@servletRequest"
                         dataSourceProp="OTMethUIDataSource" 
                         blockSize="10" 
                         width="100%"
                         copyParams="target,type,cancelURL,sname,oname,otype">
                <uix:tableSelection >
                <uix:singleSelection selectedIndexBinding="OTMethSelectedIndexUI@objectBean@servletRequest" shortDescBinding="SELECT_A_VALUE@dbMsgs">
                  <uix:submitButton textBinding="EDIT@dbMsgs" name="event" value="editMeth"/>
                  <uix:submitButton textBinding="DELETE@dbMsgs" name="event" value="deleteMeth"/>
                </uix:singleSelection>
               </uix:tableSelection>
              </oem:table>
              </uix:header>

    <%-- END: TAB CONTENTS ends here --%>   
        

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons> 
  <uix:pageButtonBar> 
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




