<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.objtype.objecttype.ObjectType"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>


<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>

<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/objecttype/viewObjectTypePage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>


    <%-- START: TAB CONTENTS starts here --%>

     <uix:header textBinding="GENERAL@uixObjecttypeBundle@servletRequest">
            <uix:tableLayout cellSpacing="5">
              <uix:contents>
                <%-- name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="objectName@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>
                <%-- schema name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                     <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>
            </uix:header>

           <%-- Attributes --%>
            <uix:header textBinding="ATTRIBUTES@uixObjecttypeBundle@servletRequest">
              <oem:table name="OTAttrUIDataSource" 
                         beanKey="objectBean"
                         destinationBinding="destination@objectBean@servletRequest"
                         formSubmitted="true"
                         dataSourceProp="OTAttrUIDataSource" 
                         blockSize="10" 
                         width="100%"
                         summaryBinding="ATTRIBUTES@uixObjecttypeBundle@servletRequest"
                         copyParams="target,type,cancelURL,sname,oname,otype">
              </oem:table>

            </uix:header>

           <%-- Methods --%>
            <uix:header textBinding="METHODS@uixObjecttypeBundle@servletRequest">
              <oem:table name="viewOTMethUIDataSource"
                         beanKey="objectBean"
                         destinationBinding="destination@objectBean@servletRequest"
                         formSubmitted="true"
                         dataSourceProp="viewOTMethUIDataSource" 
                         blockSize="10" 
                         width="100%" 
                         summaryBinding="METHODS@uixObjecttypeBundle@servletRequest"
                         alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                         copyParams="target,type,cancelURL,sname,oname,otype">
              </oem:table>
  
            </uix:header> 



            <uix:header textBinding="BODY@uixObjecttypeBundle@servletRequest">            
            <uix:tableLayout cellSpacing="5">

                <%-- body header--%>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="left">
                      <uix:contents>
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="typeBodyHeader@objectBean@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
              </uix:tableLayout> 

            <uix:tableLayout cellSpacing="5">
                <%-- body --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="left">
                      <uix:contents>
                      <uix:textInput 
                                     name="typeBody" 
                                     readOnly="true"
                                     textBinding="typeBody@objectBean@servletRequest" 
                                     columns="120" 
                                     rows="<%= objectBean.getNumRows()%>"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout> 
                </uix:tableLayout> 
                
              <uix:tableLayout cellSpacing="5">
                <%-- body footer--%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="left">
                      <uix:contents>
                        <uix:styledText
                          styleClass="OraDataText" textBinding="typeBodyFooter@objectBean@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
              </uix:tableLayout>  
           
            </uix:header>

    <%-- END: TAB CONTENTS ends here --%>   
        
  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
    <uix:ref refID="pageButtonViewInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




