<%--
  -- Page:        dataExchPMOPOpt.jsp
  -- Controller:  db/adm/schm/DataPartitionsController.java
  --
  -- Description: Options for data partition EXCHANGE operation
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<script language="JavaScript" src="/em/database/LOV.js"></script>

<script language="javascript">
function setParallel2()
{
  if (document.forms[0].parallel != null)
  {
    document.forms[0].parallel.disabled = !document.forms[0].updateIndexes.checked;
    document.forms[0].defaultDegree[0].disabled = (!document.forms[0].parallel.checked || document.forms[0].parallel.disabled);
    document.forms[0].defaultDegree[1].disabled = (!document.forms[0].parallel.checked || document.forms[0].parallel.disabled);
    document.forms[0].degree.disabled = (document.forms[0].defaultDegree[0].checked || document.forms[0].defaultDegree[0].disabled);
  }
}
</script>

<uix:buildTree nodeID="dataExchPMOPOpt">

  <%-- START: EXCHANGE OPTIONS CONTENTS starts here --%>
  <uix:spacer height="20"/>
  <uix:header textBinding="OPTIONS@partitionsBundle">
    <uix:stackLayout>

      <%-- Update Indexes Option --%>
      <uix:stackLayout renderedBinding="canUpdateIndexes@dataPartitionsBean@servletRequest">
        <uix:spacer height="10" />

        <uix:switcher childNameBinding="is10i@dataPartitionsBean@servletRequest">
          <%-- Update Indexes Option --%>
          <uix:case name="true">   
            <uix:stackLayout>
              <uix:checkBox name="updateIndexes" 
                            checked="true" 
                            onClick="setParallel2()"
                            textBinding="UPDINDEXES@partitionsBundle"/>

              <uix:flowLayout>
                <uix:spacer width="21" height="1" />
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="UPDINDEXES_HINT@partitionsBundle"/>
              </uix:flowLayout>
            </uix:stackLayout>
          </uix:case>

          <%-- Update Global Indexes Option --%>
          <uix:case name="false">  
            <uix:stackLayout>
              <uix:checkBox name="updateIndexes" 
                            checked="true" 
                            onClick="setParallel2()"
                            textBinding="UPDGINDEXES@partitionsBundle"/>
              <uix:flowLayout>
                <uix:spacer width="21" height="1" />
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="UPDGINDEXES_HINT@partitionsBundle"/>
              </uix:flowLayout>
            </uix:stackLayout>
          </uix:case>
        </uix:switcher>
      </uix:stackLayout>

      <%-- Parallel Option --%>
      <uix:stackLayout renderedBinding="canParallel@dataPartitionsBean@servletRequest">
      <uix:spacer height="10" />

      <uix:stackLayout>
        <uix:checkBox name="parallel" 
                      checkedBinding="parallel@dataPartitionsBean@servletRequest"
                      textBinding="PARALLEL@partitionsBundle"
                      onClick="setParallel2()" />

        <uix:flowLayout>
          <uix:spacer width="21" height="1" />
          <uix:styledText styleClass="OraInlineInfoText"
                          textBinding="PARALLEL_HINT@partitionsBundle"/>
        </uix:flowLayout>
      </uix:stackLayout>

      <uix:flowLayout>
        <uix:spacer width="21" height="1" />
        <uix:styledText styleClass="OraPromptText"
                        textBinding="PARALLEL_DEGREE@tableBundle"/>
        <uix:spacer width="5"/>
        <oem:radioButton name="defaultDegree" 
                         value="true" 
                         textBinding="DEFAULT@DBObjectBundle"
                         onClick="setParallel2()"
                         selectedValueBinding="defaultDegree@dataPartitionsBean@servletRequest"/>
        <uix:spacer width="5" />
        <oem:radioButton name="defaultDegree"
                         value="false"
                         textBinding="VALUE@DBObjectBundle"
                         onClick="setParallel2()"
                         selectedValueBinding="defaultDegree@dataPartitionsBean@servletRequest"/>
        <uix:spacer width="5" />
        <uix:textInput name="degree" id="PARALLEL_DEGREE" shortDescBinding="PARALLEL_DEGREE@tableBundle"
                       textBinding="degree@dataPartitionsBean@servletRequest"
                       columns="10">
          <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
        </uix:textInput>
      </uix:flowLayout>
      </uix:stackLayout>

      <%-- Exchange Indexes Option --%>
      <uix:spacer height="10" />
      <uix:checkBox name="exchangeIndexes" 
                    checkedBinding="exchangeIndexes@dataPartitionsBean@servletRequest" 
                    textBinding="EXCH_INDEXES_OPT@partitionsBundle"/>

      <%-- Exchange Row Mapping Option --%>
      <uix:spacer height="10" />
      <uix:checkBox name="mapRows" 
                    checkedBinding="mapRows@dataPartitionsBean@servletRequest" 
                    textBinding="EXCH_MAPPING_OPT@partitionsBundle"/>

      <%-- Exchange Store Exceptions Option --%>
      <uix:spacer height="10" />
      <uix:checkBox name="storeExceptions" 
                    checkedBinding="storeExceptions@dataPartitionsBean@servletRequest" 
                    textBinding="EXCH_EXCEPTIONS_OPT@partitionsBundle"/>
 
                  <%-- SCHEMA.TABLE --%>
                  <uix:rowLayout>
                  <uix:spacer width="21" height="1" />

                        <uix:messageLovField name="exceptionsTable"
                                             promptBinding="ETABLE@partitionsBundle"
                                             textBinding="exceptionsTable@dataPartitionsBean@servletRequest"
                                             searchDescBinding="SELECT_EXCP_TABLE@partitionsBundle"
                                             tipBinding="TABLE_TIP@partitionsBundle"
                                             onClick = "startLov('exceptionsTable', 'ListSchemaTable')"/>
<%--
                                             onClickBinding="exceptionlovdest@servletRequest" />
--%>
                  </uix:rowLayout>

    </uix:stackLayout>
  </uix:header>

  <%-- END: EXCHANGE OPTIONS CONTENTS ends here --%>   

</uix:buildTree>
       


