<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       dataPMOP.jsp
  -- Controller: db/adm/schm/DataPartitionsController.java
  --
  -- Description: Partition Maintenance Operation (PMOP) property
  --              pages for data [sub]partitions
  --              Launched when necessary by selecting an Action
  --              from the Actions choice box [EDIT only]
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<script language="JavaScript" src="/em/database/LOV.js"></script>

<script language="javascript">
function setParallel()
{
  if (document.forms[0].parallel != null)
  {
    document.forms[0].defaultDegree[0].disabled = !document.forms[0].parallel.checked;
    document.forms[0].defaultDegree[1].disabled = !document.forms[0].parallel.checked;
    document.forms[0].degree.disabled = (document.forms[0].defaultDegree[0].checked || document.forms[0].defaultDegree[0].disabled);
  }
}
</script>


<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">

  <uix:bundle name="partitionsBundle"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="tableBundle"
              class="oracle.sysman.db.rsc.schm.TableMsg"/>
  <uix:bundle name="DBObjectBundle"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
  
    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body onLoad="setParallel()">

    <%-- HTML Form --%>
    <db:form name="tblForm" 
             method="post"
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_PMOP_PG %>"/>
        <uix:pageLayout titleBinding="PMOPHdr@dataPartitionsBean@servletRequest">
          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>

          <uix:pageStatus> 
            <uix:switcher childNameBinding="selectedAction@dataPartitionsBean@servletRequest">

              <!-- CASE: MERGE operation -->
              <uix:case name="1">
                <uix:switcher childNameBinding="selectedTypeInt@dataPartitionsBean@servletRequest">
                  <!-- CASE: Range partitions -->
                  <uix:case name="0">   
                    <uix:styledText styleClass="OraInstructionText"
                                   textBinding="RMERGE_DESC@partitionsBundle"/>
                  </uix:case>
                  <!-- CASE: List partitions -->
                  <uix:case name="2">   
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="LMERGE_DESC@partitionsBundle"/>
                  </uix:case>
                  <!-- CASE: Range-Hash partitions -->
                  <uix:case name="3">   
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="RMERGE_DESC@partitionsBundle"/>
                  </uix:case>
                  <!-- CASE: Range-List partitions -->
                  <uix:case name="4">   
                    <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                      <uix:case name="true">          
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="RMERGE_DESC@partitionsBundle"/>
                      </uix:case>
                      <uix:case name="false">          
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="LSMERGE_DESC@partitionsBundle"/>
                      </uix:case>
                    </uix:switcher>
                  </uix:case>
                </uix:switcher>
              </uix:case>

              <!-- CASE: SPLIT operation -->
              <uix:case name="2"> 
                <uix:switcher childNameBinding="selectedTypeInt@dataPartitionsBean@servletRequest">
                  <!-- CASE: Range partitions -->
                  <uix:case name="0">   
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="RSPLIT_DESC@partitionsBundle"/>
                  </uix:case>
                  <!-- CASE: List partitions -->
                  <uix:case name="2">   
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="LSPLIT_DESC@partitionsBundle"/>
                  </uix:case>
                  <!-- CASE: Range-Hash partitions -->
                  <uix:case name="3">   
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="RSPLIT_DESC@partitionsBundle"/>
                  </uix:case>
                  <!-- CASE: Range-List partitions -->
                  <uix:case name="4">   
                    <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                      <uix:case name="true">          
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="RSPLIT_DESC@partitionsBundle"/>
                      </uix:case>
                      <uix:case name="false">          
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="SUB_SPLIT_DESC@partitionsBundle"/>
                      </uix:case>
                    </uix:switcher>
                  </uix:case>
                </uix:switcher>
              </uix:case>
     
              <!-- CASE: MOVE operation -->
              <uix:case name="4">      
                <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                  <uix:case name="true">          
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="MOVE_DESC@partitionsBundle"/>
                  </uix:case>
                  <uix:case name="false">          
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="SUB_MOVE_DESC@partitionsBundle"/>
                  </uix:case>
                </uix:switcher>
              </uix:case>

              <!-- CASE: EXCHANGE operation -->
              <uix:case name="8">
                <uix:switcher childNameBinding="selectedTypeInt@dataPartitionsBean@servletRequest">
                  <!-- CASE: Range partitions -->
                  <uix:case name="0">   
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="EXCHANGE_DESC@partitionsBundle"/>
                  </uix:case>
                  <!-- CASE: Hash partitions -->
                  <uix:case name="1">   
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="EXCHANGE_DESC@partitionsBundle"/>
                  </uix:case>
                  <!-- CASE: List partitions -->
                  <uix:case name="2">   
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="EXCHANGE_DESC@partitionsBundle"/>
                  </uix:case>
                  <!-- CASE: Range-Hash partitions -->
                  <uix:case name="3">   
                    <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                      <uix:case name="true">          
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="RHEXCHANGE_DESC@partitionsBundle"/>
                      </uix:case>
                      <uix:case name="false">          
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="SUB_EXCHANGE_DESC@partitionsBundle"/>
                      </uix:case>
                    </uix:switcher>
                  </uix:case>
                  <!-- CASE: Range-List partitions -->
                  <uix:case name="4">   
                    <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                      <uix:case name="true">           
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="RLEXCHANGE_DESC@partitionsBundle"/>
                      </uix:case>
                      <uix:case name="false">          
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="SUB_EXCHANGE_DESC@partitionsBundle"/>
                      </uix:case>
                    </uix:switcher>
                  </uix:case>
                </uix:switcher>
              </uix:case>

              <!-- CASE: EDIT VALUES operation -->
              <uix:case name="9">
                <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                  <uix:case name="true">          
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="EDIT_VALS_DESC@partitionsBundle"/>
                  </uix:case>
                  <uix:case name="false">          
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="SEDIT_VALS_DESC@partitionsBundle"/>
                  </uix:case>
                </uix:switcher>
              </uix:case>

            </uix:switcher>
          </uix:pageStatus>       


          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- Create/Edit/View Header --%>
          <uix:subTabLayout>

            <%-- START: PMOP PAGE starts here --%>
            <uix:stackLayout>

              <!-- SWITCH: PMOP operation -->
              <uix:switcher childNameBinding="selectedAction@dataPartitionsBean@servletRequest">

                <!-- CASE: SPLIT operation -->
                <uix:case name="2">
                <uix:stackLayout>
                  <uix:spacer height="10"/>        
           
                  <oem:table name="dataPartitionsUI" 
                             beanKey="dataPartitionsBean" 
                             formSubmitted="true" 
                             dataSourceProp="dataPartitionsUI" 
                             summaryBinding="PARTITIONS@partitionsBundle"
                             blockSize="10"
                             width="100%" >
                  </oem:table>

                  <%-- Include PMOP OPTIONS --%>
                  <jsp:include page="/database/schema/partitions/dataPMOPOpt.jsp"/>
                  <uix:ref refID="dataPMOPOpt"/>

                </uix:stackLayout>
                </uix:case>

                <!-- CASE: EXCHANGE operation -->
                <uix:case name="8">
                <uix:stackLayout>
                  <uix:spacer height="10"/>        

                  <%-- SCHEMA.TABLE --%>
                  <uix:rowLayout>
                      <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                        <uix:case name="true"> 
                          <uix:switcher childNameBinding="selectedTypeInt@dataPartitionsBean@servletRequest">
                           <uix:case name="3">
                             <uix:messageLovField name="newPartName"
                                             required="yes"
                                             promptBinding="HTABLE@partitionsBundle"
                                             textBinding="newPartName@dataPartitionsBean@servletRequest"
                                             searchDescBinding="SELECT_EXCH_TABLE@partitionsBundle"
                                             tipBinding="TABLE_TIP@partitionsBundle"
                                             onClick = "startLov('newPartName', 'ListSchemaTable')"/>
<%--
                        onClickBinding="pnamelovdest1@servletRequest" /> 
--%>
                           </uix:case> 
                           <uix:case name="4">
                             <uix:messageLovField name="newPartName"
                                             required="yes"
                                             promptBinding="LTABLE@partitionsBundle"
                                             textBinding="newPartName@dataPartitionsBean@servletRequest"
                                             searchDescBinding="SELECT_EXCH_TABLE@partitionsBundle"
                                             tipBinding="TABLE_TIP@partitionsBundle"
                                             onClick = "startLov('newPartName', 'ListSchemaTable')"/>
<%--
                                             onClickBinding="pnamelovdest2@servletRequest" /> 
--%>
                           </uix:case> 
                           <uix:default>
                             <uix:messageLovField name="newPartName"
                                             required="yes"
                                             promptBinding="TABLE@partitionsBundle"
                                             textBinding="newPartName@dataPartitionsBean@servletRequest"
                                             searchDescBinding="SELECT_EXCH_TABLE@partitionsBundle"
                                             tipBinding="TABLE_TIP@partitionsBundle"
                                             onClick = "startLov('newPartName', 'ListSchemaTable')"/>
<%--
                                             onClickBinding="pnamelovdest3@servletRequest" /> 
--%>
                           </uix:default> 
                          </uix:switcher>
                        </uix:case>
                        <uix:case name="false"> 
                          <uix:messageLovField name="newPartName"
                                             required="yes"
                                             promptBinding="TABLE@partitionsBundle"
                                             textBinding="newPartName@dataPartitionsBean@servletRequest"
                                             searchDescBinding="SELECT_EXCH_TABLE@partitionsBundle"
                                             tipBinding="TABLE_TIP@partitionsBundle"
                                             onClick = "startLov('newPartName', 'ListSchemaTable')"/>
<%--
                                             onClickBinding="pnamelovdest4@servletRequest" /> 
--%>
                        </uix:case> 
                      </uix:switcher>
                  </uix:rowLayout>

                  <uix:spacer height="10"/>        

                  <uix:rowLayout>   
                    <uix:tip>
                      <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">          
                        <uix:case name="true">          
                          <uix:styledText styleClass="OraTipText"
                                          textBinding="EXCHANGE_WARN@partitionsBundle"/>
                        </uix:case> 
                        <uix:case name="false">          
                          <uix:styledText styleClass="OraTipText"
                                          textBinding="SUB_EXCHANGE_WARN@partitionsBundle"/>
                        </uix:case> 
                      </uix:switcher>

                    </uix:tip>
                  </uix:rowLayout>

                  <%-- Include EXCHANGE PMOP OPTIONS --%>
                  <jsp:include page="/database/schema/partitions/dataExchPMOPOpt.jsp"/>
                  <uix:ref refID="dataExchPMOPOpt"/>

                </uix:stackLayout>
                </uix:case>

                <!-- CASE: MERGE operation -->
                <uix:case name="1">
                <uix:stackLayout>
                  <uix:spacer height="10"/>        
           
                  <uix:labeledFieldLayout>
                    <%-- New Partition Name --%>
                    <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                      <uix:case name="true"> 
                        <uix:messageTextInput name="newPartName" 
                                              required="yes"
                                              promptBinding="NPNAME@partitionsBundle" 
                                              shortDescBinding="NPNAME@partitionsBundle"
                                              textBinding="newPartName@dataPartitionsBean@servletRequest"
                                              columns="35"/>
                      </uix:case> 
                      <uix:case name="false"> 
                        <uix:messageTextInput name="newPartName" 
                                              required="yes"
                                              promptBinding="NSNAME@partitionsBundle" 
                                              shortDescBinding="NPNAME@partitionsBundle"
                                              textBinding="newPartName@dataPartitionsBean@servletRequest" 
	                                      columns="35"/>
                      </uix:case> 
                    </uix:switcher>

                    <%-- New Tablespace Name --%>
                    <uix:messageLovField name="newTablespace"
                                         required="yes"
                                         promptBinding="NTS@partitionsBundle"
                                         textBinding="newTablespace@dataPartitionsBean@servletRequest"
                                         columns="35"
                                         searchDescBinding="SELECT_TS@partitionsBundle"
                                         onClick = "startLov('newTablespace', 'ListTablespacePerm')"/>
<%-- 
                                         onClickBinding="tablespacelovdest@servletRequest" /> 
--%>

                    <%-- New Overflow Tablespace Name --%>
                    <uix:messageLovField name="newOverflowTablespace"
                                         required="yes"
                                         promptBinding="NOVERTS@partitionsBundle"
                                         renderedBinding="isIOTOverflow@dataPartitionsBean@servletRequest"
                                         textBinding="newOverflowTablespace@dataPartitionsBean@servletRequest"
                                         columns="35"
                                         searchDescBinding="SELECT_OVERTS@partitionsBundle"
                                         onClick = "startLov('newOverflowTablespace', 'ListTablespacePerm')"/>

<%--
                                          onClickBinding="overtablespacelovdest@servletRequest" />
--%>
                  </uix:labeledFieldLayout>

                    <uix:spacer height="15"/>        

                    <uix:stackLayout>

                      <uix:switcher childNameBinding="isMergeChoice@dataPartitionsBean@servletRequest">
                        <uix:case name="true">           
                          <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                            <uix:case name="true">          
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="mergeText@dataPartitionsBean@servletRequest"/>
                            </uix:case>
                            <uix:case name="false">          
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="subMergeText@dataPartitionsBean@servletRequest"/>
                            </uix:case>
                          </uix:switcher>
                        </uix:case>
                      </uix:switcher>

                      <uix:spacer height="10"/>  

                      <oem:table name="dataPartitionsUI" 
                                 beanKey="dataPartitionsBean" 
                                 formSubmitted="true" 
                                 dataSourceProp="dataPartitionsUI" 
                                 summaryBinding="PARTITIONS@partitionsBundle"
                                 blockSize="10"
                                 width="100%" >
                        <uix:tableSelection>
                          <oem:singleSelection  shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                               selectedIndexBinding="selectedIndex3@dataPartitionsBean@servletRequest"/>
                        </uix:tableSelection>
                      </oem:table>
                   </uix:stackLayout>

                  <%-- Include PMOP OPTIONS --%>
                  <jsp:include page="/database/schema/partitions/dataPMOPOpt.jsp"/>
                  <uix:ref refID="dataPMOPOpt"/>

                </uix:stackLayout>
                </uix:case>

                <!-- CASE: EDIT VALUES operation -->
                <uix:case name="9">
                <uix:stackLayout>
                  <uix:spacer height="10"/>        
                  <oem:table name="dataPartitionsUI"
                             beanKey="dataPartitionsBean" 
                             formSubmitted="true" 
                             dataSourceProp="dataPartitionsUI" 
                             summaryBinding="PARTITIONS@partitionsBundle"
                             blockSize="10"
                             width="100%" >
                  </oem:table>
                </uix:stackLayout>
                </uix:case>

                <!-- CASE: RENAME operation -->
                <uix:case name="3">
                <uix:stackLayout>
                  <uix:spacer height="10"/>
                  <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                    <uix:case name="true">    
                      <uix:messageTextInput name="newPartName" 
                                            required="yes"
                                            promptBinding="NPNAME@partitionsBundle" 
                                            shortDescBinding="NPNAME@partitionsBundle"
                                            textBinding="newPartName@dataPartitionsBean@servletRequest" 
                                            tipBinding="RENAME_TIP@partitionsBundle" 
	                                        columns="35"/>
                    </uix:case>
                    <uix:case name="false"> 
                      <uix:messageTextInput name="newPartName" 
                                            required="yes"
                                            promptBinding="NSNAME@partitionsBundle" 
                                            shortDescBinding="NSNAME@partitionsBundle"
                                            textBinding="newPartName@dataPartitionsBean@servletRequest" 
                                            tipBinding="SRENAME_TIP@partitionsBundle" 
	                                        columns="35"/>
                    </uix:case>
                  </uix:switcher>
                </uix:stackLayout>
                </uix:case>


                <!-- CASE: MOVE operation -->
                <uix:case name="4">
                <uix:stackLayout>
                  <uix:spacer height="10"/>        
                  <oem:table name="dataPartitionsUI"
                             beanKey="dataPartitionsBean" 
                             formSubmitted="true" 
                             dataSourceProp="dataPartitionsUI" 
                             summaryBinding="PARTITIONS@partitionsBundle"
                             blockSize="10"
                             width="100%" >
                  </oem:table>

                  <%-- Include PMOP OPTIONS --%>
                  <jsp:include page="/database/schema/partitions/dataPMOPOpt.jsp"/>
                  <uix:ref refID="dataPMOPOpt"/>
                </uix:stackLayout>
                </uix:case>

              </uix:switcher>

              <uix:spacer height="20"/>        
              <%-- Tip --%>
              <uix:rowLayout>
                <uix:tip>
                  <uix:styledText styleClass="OraTipText"
                                  textBinding="CONFIRM_TIP@partitionsBundle" />
                </uix:tip>
              </uix:rowLayout>
            </uix:stackLayout>
            <%-- END: PMOP PAGE ends here --%>   

          </uix:subTabLayout>  

          <uix:pageButtons>
            <uix:pageButtonBar>

	  <%-- CANCEL BUTTON --%>
	    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                              shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
        	              name="event" 
                              unvalidated="true"
                	      value="cancelPMOP" />

            <%-- OK BUTTON --%>
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                              shortDescBinding="OK@uixDBObjectBundle@servletRequest"
                              name="event" 
                              value="finishPMOP" />
            </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
    </db:form>
    <%-- END: HTML Form --%>

  </uix:body>

  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
