<%--
  -- Page:        dataPMOPOpt.jsp
  -- Controller:  db/adm/schm/DataPartitionsController.java
  --
  -- Description: Options for data partition maintenance operations
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="dataPMOPOpt">

  <%-- START: PMOP OPTIONS CONTENTS starts here --%>
  <uix:spacer height="20"/>
  <uix:header textBinding="OPTIONS@partitionsBundle">
    <uix:stackLayout>

      <%-- Keep Space Option (TRUNCATE only) --%>
        <uix:switcher childNameBinding="isTruncate@dataPartitionsBean@servletRequest">
          <uix:case name="true">
            <uix:stackLayout>
              <uix:spacer height="10" />	
              <uix:checkBox name="keepSpace" 
                            textBinding="TRUNCATE_KEEP@partitionsBundle"
                            renderedBinding="isNotIOT@dataPartitionsBean@servletRequest"/>                    
              <uix:flowLayout>
                <uix:spacer width="21" height="1" />
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="TRUNCATE_KEEP_HINT@partitionsBundle"/>
              </uix:flowLayout>
            </uix:stackLayout>
          </uix:case>
        </uix:switcher>

      <%-- Update Indexes, Place Local Indexes Option --%>
      <uix:switcher childNameBinding="canPlaceIndexes@dataPartitionsBean@servletRequest">
        <uix:case name="true">   
          <uix:stackLayout>
            <uix:spacer height="10" />

            <uix:flowLayout>
              <uix:checkBox name="updateIndexes" 
                            checked="true" 
                            textBinding="UPDINDEXES@partitionsBundle"/>
              <uix:spacer width="5"/>

              <uix:submitButton textBinding="PLACE_INDEXES@partitionsBundle"
                                shortDescBinding="PLACE_INDEXES@partitionsBundle"
                                disabledBinding="disablePlaceIndexes@dataPartitionsBean@servletRequest"
                                name="event" 
                                value="placeIndexes"/>
            </uix:flowLayout>
            <uix:flowLayout>
              <uix:spacer width="21" height="1" />
              <uix:styledText styleClass="OraInlineInfoText"
                              textBinding="UPDINDEXES_HINT@partitionsBundle"/>
            </uix:flowLayout>
          </uix:stackLayout>
        </uix:case>

        <uix:case name="false"> 
          <uix:stackLayout renderedBinding="canUpdateIndexes@dataPartitionsBean@servletRequest">
            <uix:spacer height="10" />

            <uix:switcher childNameBinding="is10i@dataPartitionsBean@servletRequest">
              <%-- Update Indexes Option --%>
              <uix:case name="true">   
                <uix:stackLayout>
                  <uix:checkBox name="updateIndexes" 
                                checked="true" 
                                onClick="setParallel()"
                                textBinding="UPDINDEXES@partitionsBundle"/>

                  <uix:flowLayout>
                    <uix:spacer width="21" height="1" />
                    <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="UPDINDEXES_HINT@partitionsBundle"/>
                  </uix:flowLayout>
                </uix:stackLayout>
              </uix:case>

              <%-- Update Global Indexes Option --%>
              <uix:case name="false">  
                <uix:stackLayout>
                  <uix:checkBox name="updateIndexes" 
                                checked="true"
                                onClick="setParallel()" 
                                textBinding="UPDGINDEXES@partitionsBundle"/>
                  <uix:flowLayout>
                    <uix:spacer width="21" height="1" />
                    <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="UPDGINDEXES_HINT@partitionsBundle"/>
                  </uix:flowLayout>
                </uix:stackLayout>
              </uix:case>
            </uix:switcher>
          </uix:stackLayout>
        </uix:case> 
      </uix:switcher>


      <%-- Parallel Option --%>
      <uix:stackLayout renderedBinding="canParallel@dataPartitionsBean@servletRequest">
      <uix:spacer height="10" />

      <uix:stackLayout>
        <uix:checkBox name="parallel" 
                      onClick="setParallel()"
                      textBinding="PARALLEL@partitionsBundle"/>
        <uix:flowLayout>
          <uix:spacer width="21" height="1" />
          <uix:styledText styleClass="OraInlineInfoText"
                          textBinding="PARALLEL_HINT@partitionsBundle"/>
        </uix:flowLayout>
      </uix:stackLayout>

      <uix:flowLayout>
        <uix:spacer width="21" height="1" />
        <uix:styledText styleClass="OraPromptText"
                        textBinding="PARALLEL_DEGREE@tableBundle"/>
        <uix:spacer width="5"/>
        <oem:radioButton name="defaultDegree" 
                         value="true" 
                         textBinding="DEFAULT@DBObjectBundle"
                         onClick="setParallel()"
                         selectedValueBinding="defaultDegree@dataPartitionsBean@servletRequest"/>
        <uix:spacer width="5" />
        <oem:radioButton name="defaultDegree"
                         value="false"
                         textBinding="VALUE@DBObjectBundle" 
                         onClick="setParallel()"
                         selectedValueBinding="defaultDegree@dataPartitionsBean@servletRequest"/>
        <uix:spacer width="5" />
        <uix:textInput name="degree" id="PARALLEL_DEGREE" 
                       shortDescBinding="PARALLEL@partitionsBundle"
                       textBinding="degree@dataPartitionsBean@servletRequest"
                       columns="10">
          <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
        </uix:textInput>
      </uix:flowLayout>
      </uix:stackLayout>

      <%-- Mapping Table Option (MOVE, IOT only) --%>
      <uix:spacer height="10" />
      <uix:checkBox name="mappingTable" 
                    textBinding="MAPPING_TABLE_OPTION@partitionsBundle"
                    renderedBinding="canUseMappingTable@dataPartitionsBean@servletRequest"/>                    

      <%-- Online Option (REBUILD INDEX only) --%>
      <uix:stackLayout
            renderedBinding="onlineAllowed@dataPartitionsBean@servletRequest">             
        <uix:checkBox name="rebuildOnline" 
                      checked="true"	
                      textBinding="REBUILD_ONLINE@partitionsBundle"/>
        <uix:flowLayout>
          <uix:spacer width="21" height="1" />
          <uix:styledText styleClass="OraInlineInfoText"
                          textBinding="REBUILD_ONLINE_HINT@partitionsBundle"/>
        </uix:flowLayout>
      </uix:stackLayout>

     <%-- Compute Statistics Option (REBUILD INDEX only) --%>
      <uix:stackLayout
            renderedBinding="computeStatsAllowed@dataPartitionsBean@servletRequest">             
        <uix:spacer height="10" />
        <uix:checkBox name="computeStats" 
                      checked="true"	
                      textBinding="COMPUTE_STATS@partitionsBundle"/>
        <uix:flowLayout>
          <uix:spacer width="21" height="1" />
          <uix:styledText styleClass="OraInlineInfoText"
                          textBinding="COMPUTE_STATS_HINT@partitionsBundle"/>
        </uix:flowLayout>
      </uix:stackLayout>

    </uix:stackLayout>
  </uix:header>

  <%-- END: PMOP OPTIONS CONTENTS ends here --%>   

</uix:buildTree>
       


