<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%--
  -- Page:        dataPartitions.jsp
  -- Controller:  db/adm/schm/DataPartitionsController.java
  --
  -- Description: Main data partitions page
  --%>


<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
<oem:setURLEncoder id="renderingContext"/>

<uix:document>

   <%-- Browser title.  Page name from controller getPageHeader() --%>
   <%@ include file="/oemTitle.jspf" %>

<uix:body>

<%-- HTML Form --%>
<db:form name="tblForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_DATA_PG %>"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>

    <%-- SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/table/subTabsInclude.jsp" />
      <uix:ref refID="subTabsInclude" />
    </uix:subTabs>

    <%-- START: PAGE CONTENTS starts here --%>
    <uix:spacer height="10"/>

    <!--          -->
    <!-- Creating -->
    <!--          -->
    <uix:switcher childNameBinding="creating@objectBean@servletRequest">
      <uix:case name="true">
        <uix:spacer height="5"/>
        <uix:stackLayout>

            <%-- Partitions section --%>
            <uix:switcher childNameBinding="isComposite@dataPartitionsBean@servletRequest">

              <%-- If there are subpartitions, add header --%>
              <uix:case name="true">
                <uix:header textBinding="PART_HDR@msgs">
                  <%@ include file="createPartitions.jspf" %>
                </uix:header>
              </uix:case>
              <uix:case name="false">
                <%@ include file="createPartitions.jspf" %>
              </uix:case>
            </uix:switcher>

            <%-- Subpartitions section --%>
            <uix:switcher childNameBinding="isComposite@dataPartitionsBean@servletRequest">
              <%-- CASE: Composite partitions --%>
              <uix:case name="true">
                <uix:header textBinding="GLOBAL_SUBPART@msgs"
                            renderedBinding="haveParts@dataPartitionsBean@servletRequest">

                  <uix:stackLayout>

                    <uix:spacer height="5"/>

                          <%-- SWITCH: Range-Hash or Range-List type --%>
                          <uix:switcher childNameBinding="selectedTypeInt@dataPartitionsBean@servletRequest">

                            <%-- CASE: Range-Hash partitions --%>
                            <uix:case name="3">
                              <uix:labeledFieldLayout labelWidth="20%">

                                <uix:styledText styleClass="OraFieldText"
                                                textBinding="SMETHOD@msgs"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="HASH@msgs"/>
                                <uix:styledText styleClass="OraFieldText"
                                                textBinding="SCOLS@msgs"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="scolsList@partitionColsBean@servletRequest"/>
                              </uix:labeledFieldLayout>
                            </uix:case>

                            <%-- CASE: Range-List partitions --%>
                            <uix:case name="4">
                              <uix:labeledFieldLayout labelWidth="20%">
                                <uix:styledText styleClass="OraFieldText"
                                                textBinding="SMETHOD@msgs"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="LIST@msgs"/>
                                <uix:styledText styleClass="OraFieldText"
                                                textBinding="SCOL@msgs"/>
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="scolsList@partitionColsBean@servletRequest"/>
                              </uix:labeledFieldLayout>

                            </uix:case> <%-- range-list --%>
                          </uix:switcher>
                            <%-- Subpartitions table --%>
                                <%-- DELETE ALL SUBPARTITIONS --%>
                                <uix:rowLayout width="100%"
                                               renderedBinding="haveSubs@dataPartitionsBean@servletRequest">
                                  <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                                    <uix:submitButton textBinding="DELETEAS@msgs" name="event" value="deleteAllSubpartitions" shortDescBinding="DELETEAS@msgs"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>

                      <%-- Subpartitions table --%>
                      <%@ include file="subpartitionsTable.jsp" %>

                      <uix:spacer height="5"/>

                  </uix:stackLayout>
                </uix:header>
              </uix:case> <%-- has subpartitions --%>
            </uix:switcher>
        </uix:stackLayout>
      </uix:case>

      <%--         --%>
      <%-- Editing --%>
      <%--         --%>
      <uix:case name="false">

        <uix:spacer height="10"/>

        <!-- SWITCH: Partition type -->
        <uix:switcher childNameBinding="selectedTypeInt@dataPartitionsBean@servletRequest">

          <!-- CASE: Range partitions -->
          <uix:case name="0">
            <uix:rowLayout width="100%">
              <jsp:include page="/database/schema/partitions/dataPartitionsR.jsp"/>
              <uix:ref refID="dataPartitionsR"/>
            </uix:rowLayout>
          </uix:case>

          <!-- CASE: Hash partitions -->
          <uix:case name="1">
            <uix:rowLayout width="100%">
              <jsp:include page="/database/schema/partitions/dataPartitionsH.jsp"/>
              <uix:ref refID="dataPartitionsH"/>
            </uix:rowLayout>
          </uix:case>

          <!-- CASE: list partitions -->
          <uix:case name="2">
            <uix:rowLayout width="100%">
              <jsp:include page="/database/schema/partitions/dataPartitionsL.jsp"/>
              <uix:ref refID="dataPartitionsL"/>
            </uix:rowLayout>
          </uix:case>

          <!-- CASE: Range-Hash composite partitions -->
          <uix:case name="3">
            <uix:rowLayout width="100%">
              <jsp:include page="/database/schema/partitions/dataPartitionsR.jsp"/>
              <uix:ref refID="dataPartitionsR"/>
            </uix:rowLayout>
          </uix:case>

          <!-- CASE: Range-List composite partitions -->
          <uix:case name="4">
            <uix:rowLayout width="100%">
              <jsp:include page="/database/schema/partitions/dataPartitionsR.jsp"/>
              <uix:ref refID="dataPartitionsR"/>
            </uix:rowLayout>
          </uix:case>

        </uix:switcher>

      </uix:case>
    </uix:switcher>


    <%-- END: PAGE CONTENTS ends here --%>

  </uix:subTabLayout>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%>


