<%--
  -- Page:        dataPartitionsH.jsp
  -- Controller:  db/adm/schm/DataPartitionsController.java
  --
  -- Description: Edit Hash partitions page
  --%>
<script language="JavaScript" src="/em/database/LOV.js"></script>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/utils.js"/>

<uix:buildTree nodeID="dataPartitionsH">
   
  <uix:labeledFieldLayout labelWidth="20%">
    <uix:messagePrompt promptBinding="PMETHOD@msgs"/>
    <uix:styledText styleClass="OraDataText" 
                    textBinding="displayType@dataPartitionsBean@servletRequest" />

    <uix:messagePrompt promptBinding="PCOLS@msgs"/>
    <uix:styledText styleClass="OraDataText" 
                    textBinding="pcolsList@partitionColsBean@servletRequest" />
  </uix:labeledFieldLayout>
  <%-- Follow page context information with a separator --%>
  <uix:separator/>

    <uix:spacer height="5"/>

    <%-- SEARCH PROMPT --%>
    <uix:stackLayout renderedBinding="canSearch@dataPartitionsBean@servletRequest" >
      <uix:rowLayout>
        <uix:styledText styleClass="OraInstructionText" textBinding="SEARCHPNAME@msgs" labeledNodeId="SEARCHPNAME"/>
        <uix:spacer height="1" width="5"/>
        <uix:textInput name="searchPartName" textBinding="searchPartName@dataPartitionsBean@servletRequest" columns="32" id="SEARCHPNAME" shortDescBinding="SEARCHPNAME@msgs"/>
        <uix:spacer height="1" width="5"/>
        <uix:submitButton textBinding="GO@msgs" name="event" value="searchPartitions" shortDescBinding="GO@msgs"/>
      </uix:rowLayout>
    </uix:stackLayout>
    <%-- END SEARCH PROMPT --%>

    <uix:stackLayout>
      <uix:rowLayout width="100%">
        <uix:cellFormat hAlign="right" vAlign="top" width="100%">
          <uix:submitButton textBinding="COALESCE@msgs"
                            shortDescBinding="COALESCE@msgs"
                            name="event" 
                            renderedBinding="canCoalesce@dataPartitionsBean@servletRequest" 
                            disabledBinding="disableCoalesce@dataPartitionsBean@servletRequest" 
                            value="coalescePartition"/>
        </uix:cellFormat>
      </uix:rowLayout>

      <uix:spacer height="1"/>

      <oem:table name="dataPartitionsUI" 
                 beanKey="dataPartitionsBean" 
                 formSubmitted="true" 
                 dataSourceProp="dataPartitionsUI" 
                 summaryBinding="PARTITIONS@msgs"
                 blockSize="10" 
                 width="100%"
                 alternateTextBinding="NO_PARTS@msgs">    
        <uix:tableSelection>
          <oem:singleSelection
               selectedIndexBinding="selectedIndex@dataPartitionsBean@servletRequest" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest">
            <uix:flowLayout>
              <uix:submitButton textBinding="ADVOPT@msgs" 
                                shortDescBinding="ADVOPT@msgs"
                                name="event" 
                                value="advOptions"/>
              <uix:spacer width="5"/>
              <uix:submitButton textBinding="DELETE@msgs" 
                                shortDescBinding="DELETE@msgs"
                                name="event" 
                                disabledBinding="disableDelete@dataPartitionsBean@servletRequest"
                                value="deletePartition"/>
              <uix:spacer width="10"/>
              <uix:messagePrompt promptBinding="ACTIONS@msgs" labeledNodeId="ACTIONS" />
              <uix:spacer width="5"/>
              <uix:choice name="actionChoice" id="ACTIONS"
                          selectedValueBinding="selectedAction@dataPartitionsBean@servletRequest">
                <uix:option textBinding="TRUNCATE@msgs" value="0" />
                <uix:option textBinding="RENAME@msgs" value="3" />
                <uix:option textBinding="MOVE@msgs" value="4" />   
                <uix:option textBinding="EXCHANGE@msgs" value="8" />
                <uix:option textBinding="REBUILD_IDX@msgs" value="6" />
                <uix:option textBinding="UNUSABLE_IDX@msgs" value="7" />
                <uix:option textBinding="COALESCE@msgs" value="13"
                            renderedBinding="canCoalesceIdx@dataPartitionsBean@servletRequest"/>                    
                <uix:option textBinding="PLACE_INDEXES@msgs" value="14"
                            renderedBinding="canPlaceIndexesAction@dataPartitionsBean@servletRequest"/>      
              </uix:choice>                
              <uix:spacer width="5"/>
              <uix:submitButton textBinding="GO@msgs" 
                                shortDescBinding="GO@msgs"
                                name="event" 
                                value="selectAction" /> 
            </uix:flowLayout>          
          </oem:singleSelection>
        </uix:tableSelection>

        <uix:footer>
          <uix:submitButton textBinding="ADDAP@msgs" 
                            shortDescBinding="ADDAP@msgs"
                            name="event" value="addPartition"
                            renderedBinding="canAdd@dataPartitionsBean@servletRequest" />
        </uix:footer>
      </oem:table>
      <uix:tip>
        <uix:styledText styleClass="OraTipText"
                        textBinding="HDELTIP@msgs" />
      </uix:tip>

     <uix:spacer height="10"/>
    </uix:stackLayout>

</uix:buildTree>
       


