<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       dataPartitionsLOB.jsp
  -- Controller: db/adm/schm/DataPartitionsController.java
  --
  -- Description: Lob attributes tab for data partition LOB columns
  --              This tab allows the user to view/change the various storage
  --              options for individual LOB columns.
  --              Launched by the Advanced Options button.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<script language="JavaScript" src="/em/database/LOV.js"></script>
<db:script  src="/database/utils.js"/>
<script language="javascript">
function setLOBOptions() 
{
  if (document.forms[0].retention != null)
        initLOBStorageOptions();
}
</script>


<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">

  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

  <%-- Browser title.  Page name from controller getPageHeader() --%>
  <%@ include file="/oemTitle.jspf" %>

  <uix:body onLoad="setLOBOptions()">  

    <%-- HTML Form --%>
    <db:form name="tblForm"
             method="post"
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_LOB_PG %>"/>
        <uix:pageLayout titleBinding="lobAttrHdr@dataPartitionsBean@servletRequest">

          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/globalPopup.jspf" %>

          <uix:location>
            <uix:switcher childNameBinding="isTableType@dataPartitionsBean@servletRequest">
              <uix:case name="true">
                <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="true">
                    <jsp:include page="wizTrain.jsp"/>
                    <uix:ref refID="wizTrain"/>
                  </uix:case>
                </uix:switcher>
              </uix:case>
            </uix:switcher>
          </uix:location>

          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info"
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- Create/Edit/View Header --%>
          <uix:subTabLayout>

            <%-- SubTabs --%>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="2">
                  <db:link textBinding="STORAGE@msgs"
                           shortDescBinding="STORAGE@msgs"
                           onClick="submitForm('tblForm', true, {event:'pStorage'})"
                           copyParams="target,type,cancelURL,sname,oname,otype"/>
                  <uix:switcher childNameBinding="isIOTOverflow@dataPartitionsBean@servletRequest">
                    <uix:case name="true">
                      <db:link textBinding="OVERSTORAGE@msgs"   
                               shortDescBinding="OVERSTORAGE@msgs"
                          onClick="submitForm('tblForm', true, {event:'pOverflow'})"
                          copyParams="target,type,cancelURL,sname,oname,otype"/>
                    </uix:case>
                  </uix:switcher>
                  <db:link textBinding="LOBATTR@msgs"
                           shortDescBinding="LOBATTR@msgs"
                           copyParams="target,type,cancelURL,sname,oname,otype" />
                  <%-- Statistics tab (EDIT only) --%>
                  <db:link textBinding="STATS@msgs"
                           shortDescBinding="STATS@msgs"
                           renderedBinding="currentExists@dataPartitionsBean@servletRequest"
                           onClick="submitForm('tblForm', true, {event:'pStats'})"
                           copyParams="target,type,cancelURL,sname,oname,otype"/>
              </uix:subTabBar>
            </uix:subTabs>

            <%-- START: PARTITION LOB ATTRIBUTES PAGE starts here --%>

              <uix:rowLayout>
                <uix:tableLayout cellSpacing="5" width="100%">

                  <%-- TIP: DESCRIPTION OF PARTITION-LEVEL OPTIONS --%>
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                            <uix:case name="true">

                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="DESC_OPTS@msgs"/>
                            </uix:case>
                            <uix:case name="false">
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="DESC_SUB_OPTS@msgs"/>
                            </uix:case>
                          </uix:switcher>
                        </uix:case>
                        <%-- Editing --%>
                        <uix:case name="false">
                          <uix:switcher childNameBinding="isComposite@dataPartitionsBean@servletRequest">
                            <uix:case name="true">  
                              <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                                <uix:case name="true">
                                  <uix:styledText styleClass="OraInstructionText"
                                                  textBinding="DESC_DEF_SUB_OPTS@msgs" />
                                </uix:case>
                                <uix:case name="false">
                                  <uix:styledText styleClass="OraInstructionText"
                                                  textBinding="EDESC_SUB_OPTS@msgs" />
                                </uix:case>
                              </uix:switcher>
                            </uix:case>
                            <%-- Editing, not composite --%>
                            <uix:case name="false">  
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="EDESC_OPTS@msgs" />
                            </uix:case>
                          </uix:switcher>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>
               </uix:tableLayout>
              </uix:rowLayout>

              <uix:tableLayout cellSpacing="5" hAlign="center" width="75%">
              <%-- Workaround to get 75% to display correctly --%>
                <uix:rowLayout>
                  <uix:tableLayout>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:messagePrompt promptBinding="LOBCOL@msgs"/>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:spacer height="1" width="5" />
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:switcher childNameBinding="hasMultiLOBs@dataPartitionsBean@servletRequest">
                          <uix:case name="true">
                          <oem:choice name="lobCol"
                                    onChange="submitForm('tblForm', true, {'event':'changeLOBCol'})"
                                    optionsBinding="lobCols@dataPartitionsBean@servletRequest"
                                    shortDescBinding="LOBCOL@msgs"
                                    selectedValueBinding="lobCol@dataPartitionsBean@servletRequest"/>
                          </uix:case>
                          <uix:case name="false">
                            <uix:styledText styleClass="OraDataText"
                                            textBinding="lobCol@dataPartitionsBean@servletRequest"/>
                          </uix:case>
                        </uix:switcher>

                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:rowLayout>
              </uix:tableLayout>


              <uix:dataScope currentDataBinding="pLOBSegmentBean@servletRequest">
                <jsp:include page="/database/schema/utilities/lobStorageInclude.jsp" />
                <uix:ref refID="lobStorageInclude" />
              </uix:dataScope>

            <%-- END: PARTITION LOB ATTRIBUTES PAGE ends here --%>

          </uix:subTabLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <%-- CANCEL BUTTON --%>
              <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                                shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                                name="event" 
                                value="cancelOpts" />
              <%-- OK BUTTON --%>
              <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                                shortDescBinding="OK@uixDBObjectBundle@servletRequest" 
                                name="event" 
                                value="finishOpts" />
            </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
    </db:form>
    <%-- END: HTML Form --%>

    </uix:body>

  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
