<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       dataPartitionsOverflow.jsp
  -- Controller: db/adm/schm/DataPartitionsController.java
  --
  -- Description: Storage tab for data partition overflow segments (IOT)
  --              This tab allows the user to view the various storage
  --              options for individual data partition overflow segments.
  --              Launched by the Advanced Options button.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">

  <%-- Note: Must be named msgs due to wizTrain include  --%>
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
  
    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <%-- HTML Form --%>
    <db:form name="tblForm" 
             method="post" 
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_OVERFLOW_PG %>"/>
        <uix:pageLayout titleBinding="overflowHdr@dataPartitionsBean@servletRequest">

          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/globalPopup.jspf" %>

          <%-- Train --%>
          <%-- The train will only display if we are in the partitions wizard --%>
          <uix:location>
            <uix:switcher childNameBinding="isTableType@dataPartitionsBean@servletRequest">
              <uix:case name="true">
                <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="true">
                    <jsp:include page="wizTrain.jsp"/>
                    <uix:ref refID="wizTrain"/>
                  </uix:case>
                </uix:switcher>
              </uix:case>
            </uix:switcher>
          </uix:location>

          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- Create/Edit/View Header --%>
          <uix:subTabLayout>

            <%-- SubTabs --%>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
                  <db:link textBinding="STORAGE@msgs"
                           shortDescBinding="STORAGE@msgs"
                           onClick="submitForm('tblForm', true, {event:'pStorage'})"
                           copyParams="target,type,cancelURL,sname,oname,otype"/>
                  <db:link textBinding="OVERSTORAGE@msgs" copyParams="target,type,cancelURL,sname,oname,otype" shortDescBinding="OVERSTORAGE@msgs"/>
                  <uix:switcher childNameBinding="hasLOBs@dataPartitionsBean@servletRequest">
                    <uix:case name="true">
                      <db:link textBinding="LOBATTR@msgs"
                               shortDescBinding="LOBATTR@msgs"
                               onClick="submitForm('tblForm', true, {event:'pLOB'})"
                               copyParams="target,type,cancelURL,sname,oname,otype"/>
                    </uix:case>
                  </uix:switcher> 

                <%-- Statistics tab (EDIT only) --%>
                <db:link textBinding="STATS@msgs"
                         shortDescBinding="STATS@msgs"
                         renderedBinding="currentExists@dataPartitionsBean@servletRequest"
                         onClick="submitForm('tblForm', true, {event:'pStats'})"
                         copyParams="target,type,cancelURL,sname,oname,otype"/>
              </uix:subTabBar>
            </uix:subTabs>


            <%-- START: PARTITION OVERFLOW PAGE starts here --%>
              <uix:rowLayout>
                <uix:tableLayout cellSpacing="5" width="100%">

                  <%-- TIP: DESCRIPTION OF PARTITION-LEVEL OPTIONS --%>
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="DESC_OPTS@msgs"/>
                        </uix:case>
                        <%-- Editing --%>
                        <uix:case name="false">
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="EDESC_OPTS@msgs" />
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>
               </uix:tableLayout>
              </uix:rowLayout>


     <uix:dataScope currentDataBinding="pOverflowSegmentBean@servletRequest">
       <jsp:include page="/database/schema/utilities/storageContextInclude.jsp" />
         <uix:ref refID="storageInclude" />

    </uix:dataScope>

    <uix:spacer height="10" />

    <%-- END: PARTITION OVERFLOW STORAGE PAGE ends here --%>   

    </uix:subTabLayout>  

    <uix:pageButtons>
      <uix:pageButtonBar>

        <%-- CANCEL BUTTON --%>
        <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                          renderedBinding="canEditOpts@dataPartitionsBean@servletRequest"
                          name="event" 
                          value="cancelOpts" />
        <%-- OK BUTTON --%>
        <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="OK@uixDBObjectBundle@servletRequest" 
                          name="event" 
                          value="finishOpts" />
      </uix:pageButtonBar>
    </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    <%-- END: HTML Form --%>

    </uix:body>

  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
