<%--
  -- Page:        dataPartitionsR.jsp
  -- Controller:  db/adm/schm/DataPartitionsController.java
  --
  -- Description: Create/Edit Range, Range-Hash composite 
  --              and Range-List composite partitions page
  --%>
<script language="JavaScript" src="/em/database/LOV.js"></script>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/utils.js"/>

<uix:buildTree nodeID="dataPartitionsR">

    <uix:switcher childNameBinding="isComposite@dataPartitionsBean@servletRequest">
      <uix:case name="true">   
      <uix:labeledFieldLayout labelWidth="20%">
      <uix:messagePrompt promptBinding="PMETHOD@msgs"/>
      <uix:styledText styleClass="OraDataText" 
                      textBinding="displayType@dataPartitionsBean@servletRequest" />

      <uix:messagePrompt promptBinding="PCOLS@msgs"/>
      <uix:styledText styleClass="OraDataText" 
                            textBinding="pcolsList@partitionColsBean@servletRequest" />

      <uix:switcher childNameBinding="isRangeList@dataPartitionsBean@servletRequest">
        <uix:case name="true">     
          <uix:messagePrompt promptBinding="SCOL@msgs"/>
        </uix:case>
        <uix:case name="false">     
          <uix:messagePrompt promptBinding="SCOLS@msgs"/>
        </uix:case>
      </uix:switcher>
     <uix:styledText styleClass="OraDataText" 
                     textBinding="scolsList@partitionColsBean@servletRequest" />
    </uix:labeledFieldLayout>
    </uix:case>
    <uix:case name="false">   
      <uix:labeledFieldLayout labelWidth="20%">
      <uix:messagePrompt promptBinding="PMETHOD@msgs"/>
      <uix:styledText styleClass="OraDataText" 
                      textBinding="displayType@dataPartitionsBean@servletRequest" />

      <uix:messagePrompt promptBinding="PCOLS@msgs"/>
      <uix:styledText styleClass="OraDataText" 
                            textBinding="pcolsList@partitionColsBean@servletRequest" />
    </uix:labeledFieldLayout>
    </uix:case>
    </uix:switcher>
    <%-- Follow page context information with a separator --%>
    <uix:separator/>

    <uix:spacer height="10"/>           

    <%-- SEARCH PROMPT --%>
    <uix:stackLayout renderedBinding="canSearch@dataPartitionsBean@servletRequest" >
      <uix:rowLayout>
        <uix:styledText styleClass="OraInstructionText" textBinding="SEARCHPNAME@msgs" labeledNodeId="SEARCHPNAME"/>
        <uix:spacer height="1" width="5"/>
        <uix:textInput name="searchPartName" textBinding="searchPartName@dataPartitionsBean@servletRequest" columns="32" id="SEARCHPNAME" shortDescBinding="SEARCHPNAME@msgs"/>
        <uix:spacer height="1" width="5"/>
        <uix:submitButton textBinding="GO@msgs" name="event" value="searchPartitions" shortDescBinding="GO@msgs"/>
      </uix:rowLayout>
    </uix:stackLayout>
    <%-- END SEARCH PROMPT --%>

    <uix:spacer height="5"/>           

    <%-- New partitions added during edit? --%>
    <uix:stackLayout renderedBinding="newPartitions@dataPartitionsBean@servletRequest">
      <uix:spacer height="5"/>
      <uix:rowLayout>    
        <uix:styledText styleClass="OraInstructionText"
                        textBinding="RHVDESC@msgs"/>
      </uix:rowLayout>
      <uix:spacer height="5"/>

      <uix:styledText renderedBinding="hasDate@partitionColsBean@servletRequest"
                      textBinding="dateExample@dataPartitionsBean@servletRequest"
                      styleClass="OraInlineInfoText"/>
   
      <uix:spacer height="5"/>
    </uix:stackLayout>

    <oem:table name="dataPartitionsUI" 
               beanKey="dataPartitionsBean" 
               formSubmitted="true" 
               dataSourceProp="dataPartitionsUI" 
               summaryBinding="PARTITIONS@msgs"
               blockSize="10" 
               width="100%"
               alternateTextBinding="NO_PARTS@msgs">    

      <uix:tableSelection>
        <oem:singleSelection
             selectedIndexBinding="selectedIndex@dataPartitionsBean@servletRequest" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest">
          <uix:flowLayout>
            <uix:submitButton textBinding="ADVOPT@msgs" 
                              shortDescBinding="ADVOPT@msgs"
                              name="event" 
                              value="advOptions"/>
            <%-- Composite partitions --%>
            <uix:flowLayout renderedBinding="isComposite@dataPartitionsBean@servletRequest">
              <uix:spacer width="5"/>
              <uix:submitButton textBinding="SUBPARTITIONS@msgs" 
                                shortDescBinding="SUBPARTITIONS@msgs"
                                name="event" 
                                value="subpartitions"/>
            </uix:flowLayout>
            <uix:spacer width="5"/>
            <uix:submitButton textBinding="DELETE@msgs" 
                              shortDescBinding="DELETE@msgs"
                              name="event" 
                              disabledBinding="disableDelete@dataPartitionsBean@servletRequest" 
                              value="deletePartition"/>
            <uix:spacer width="10"/>
            <uix:messagePrompt promptBinding="ACTIONS@msgs" labeledNodeId="ACTIONS"/>
            <uix:spacer width="5"/>
            <uix:choice name="actionChoice" id="ACTIONS"
                        shortDescBinding="ACTIONS@msgs"
                        selectedValueBinding="selectedAction@dataPartitionsBean@servletRequest">
              <uix:option textBinding="TRUNCATE@msgs" value="0" />  
              <uix:option textBinding="MERGE@msgs" value="1" />
              <uix:option textBinding="SPLIT@msgs" value="2" />
              <uix:option textBinding="RENAME@msgs" value="3" />
              <uix:option textBinding="MOVE@msgs" value="4"
                          renderedBinding="canMove@dataPartitionsBean@servletRequest" />
              <uix:option textBinding="EXCHANGE@msgs" value="8" />
              <uix:option textBinding="REBUILD_IDX@msgs" value="6"
                          renderedBinding="canUnusableIdx@dataPartitionsBean@servletRequest" />

              <uix:option textBinding="UNUSABLE_IDX@msgs" value="7"
                          renderedBinding="canUnusableIdx@dataPartitionsBean@servletRequest" />
              <uix:option textBinding="COALESCE@msgs" value="13"
                          renderedBinding="canCoalesceIdx@dataPartitionsBean@servletRequest"/>      
              <uix:option textBinding="PLACE_INDEXES@msgs" value="14"
                          renderedBinding="canPlaceIndexesAction@dataPartitionsBean@servletRequest"/>      
            </uix:choice>  
            <uix:spacer width="5"/>
            <uix:submitButton textBinding="GO@msgs" 
                              shortDescBinding="GO@msgs"
                              name="event" 
                              value="selectAction" />
          </uix:flowLayout> 
        </oem:singleSelection>
      </uix:tableSelection>

      <uix:footer>
        <uix:submitButton textBinding="ADDAP@msgs" 
                          shortDescBinding="ADDAP@msgs"
                          name="event" value="addPartition"
                          renderedBinding="canAdd@dataPartitionsBean@servletRequest" />
      </uix:footer>
    </oem:table>

    <uix:spacer height="5"/>

    <uix:tip renderedBinding="canAdd@dataPartitionsBean@servletRequest">
      <uix:styledText textBinding="R_MAX_TIP@msgs"
                      styleClass="OraTipText"/>
    </uix:tip>

    <uix:spacer height="10"/>

</uix:buildTree>
       


