<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       dataPartitionsStats.jsp
  -- Controller: db/adm/schm/DataPartitionsController.java
  --
  -- Description: Statistics tab for data/index [sub]partitions
  --              This tab allows the user to view the various
  --              statistics for individual data [sub]partitions.
  --              Launched by the Advanced Options button.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">

  <uix:bundle name="pmsgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
  
    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <%-- HTML Form --%>
    <db:form name="tblForm" 
             method="post" 
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_STATS_PG %>"/>
        <uix:pageLayout titleBinding="statsHdr@dataPartitionsBean@servletRequest">

          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/globalPopup.jspf" %>

          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- Create/Edit/View Header --%>
          <uix:subTabLayout>

            <%-- SubTabs --%>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="3">
                  <db:link textBinding="STORAGE@pmsgs"
                           shortDescBinding="STORAGE@pmsgs"
                           onClick="submitForm('tblForm', true, {event:'pStorage'})"
                           copyParams="target,type,cancelURL,sname,oname,otype"/>
                <uix:switcher childNameBinding="isIOTOverflow@dataPartitionsBean@servletRequest">
                  <uix:case name="true">
                    <db:link textBinding="OVERSTORAGE@pmsgs"
                             shortDescBinding="OVERSTORAGE@pmsgs"
                             onClick="submitForm('tblForm', true, {event:'pOverflow'})"
                             copyParams="target,type,cancelURL,sname,oname,otype"/>
                  </uix:case>
                </uix:switcher> 
                <uix:switcher childNameBinding="hasLOBs@dataPartitionsBean@servletRequest">
                  <uix:case name="true">
                    <db:link textBinding="LOBATTR@pmsgs"
                             shortDescBinding="LOBATTR@pmsgs"
                             onClick="submitForm('tblForm', true, {event:'pLOB'})"
                             copyParams="target,type,cancelURL,sname,oname,otype"/>
                  </uix:case>
                </uix:switcher> 
                
                <%-- Statistics tab (EDIT only) --%>
                <db:link textBinding="STATS@pmsgs" shortDescBinding="STATS@pmsgs" copyParams="target,type,cancelURL,sname,oname,otype"/>

              </uix:subTabBar>
            </uix:subTabs>

            <uix:spacer height="10" />

            <%-- START: PARTITION STATISTICS PAGE starts here --%>

            <uix:dataScope currentDataBinding="pStatsBean@servletRequest">

              <uix:stackLayout renderedBinding="isTableType@dataPartitionsBean@servletRequest">

                <uix:labeledFieldLayout width="75%">
                  <%-- LAST ANALYZED --%>
                  <%-- NOTE: switcher doesn't work with labeledFieldLayout --%>

                  <uix:messagePrompt promptBinding="LAST_ANALYZED@pmsgs" />
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="lastAnalyzed@" />

                  <%-- BLOCKS --%>
                  <uix:messagePrompt promptBinding="BLOCKS@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="blocks@" />

                  <%-- EMPTY BLOCKS --%>
                  <uix:messagePrompt promptBinding="EMPTY_BLOCKS@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="emptyBlocks@" />

                  <%-- AVERAGE SPACE --%>
                  <uix:messagePrompt promptBinding="AVG_SPACE@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="avgSpace@" />

                  <%-- NUMBER OF ROWS --%>
                  <uix:messagePrompt promptBinding="NUM_ROWS@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="numRows@" />

                  <%-- SAMPLE SIZE --%>
                  <uix:messagePrompt promptBinding="SAMPLE_SIZE@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="sampleSize@" />

                  <%-- AVERAGE ROW LENGTH --%>
                  <uix:messagePrompt promptBinding="AVG_ROW_LEN@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="avgRowLen@" />

                  <%-- CHAIN COUNT --%>
                  <uix:messagePrompt promptBinding="CHAIN_CNT@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="chainCnt@" />

                </uix:labeledFieldLayout>

                <uix:stackLayout renderedBinding="isNotAnalyzed@" >
                  <uix:spacer height="10" />
                  <uix:tip>
                    <uix:styledText styleClass="OraTipText"
                                    textBinding="STATS_TIP@pmsgs" />
                  </uix:tip>
                </uix:stackLayout>

              </uix:stackLayout>

              <uix:stackLayout renderedBinding="isIndexType@dataPartitionsBean@servletRequest">

                <uix:labeledFieldLayout> 

                  <%-- LAST ANALYZED --%>
                  <uix:messagePrompt promptBinding="LAST_ANALYZED@pmsgs" />
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="lastAnalyzed@" />

                  <%-- TREE HEIGHT (BLEVEL) --%>
                  <uix:messagePrompt promptBinding="BLEVEL@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="blevel@" />

                  <%-- DISTINCT KEYS --%>
                  <uix:messagePrompt promptBinding="DISTINCT_KEYS@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="distinctKeys@" />

                  <%-- CLUSTERING FACTOR --%>
                  <uix:messagePrompt promptBinding="CLUSTERING_FACTOR@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="clusteringFactor@" />

                  <%-- LEAF BLOCKS --%>
                  <uix:messagePrompt promptBinding="LEAF_BLOCKS@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="leafBlocks@" />

                  <%-- AVERAGE LEAF BLOCKS --%>
                  <uix:messagePrompt promptBinding="AVG_LEAF_BLOCKS@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="avgLeafBlocks@" />

                  <%-- AVERAGE DATA BLOCKS --%>
                  <uix:messagePrompt promptBinding="AVG_DATA_BLOCKS@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="avgDataBlocks@" />

                  <%-- NUMBER OF ROWS --%>
                  <uix:messagePrompt promptBinding="NUM_ROWS@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="numRows@" />

                  <%-- SAMPLE SIZE --%>
                  <uix:messagePrompt promptBinding="SAMPLE_SIZE@pmsgs"/>
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="sampleSize@" />

                </uix:labeledFieldLayout>

                <uix:stackLayout renderedBinding="isNotAnalyzed@" >
                  <uix:spacer height="10" />
                  <uix:tip>
                    <uix:styledText styleClass="OraTipText"
                                    textBinding="IDX_STATS_TIP@pmsgs" />
                  </uix:tip>
                </uix:stackLayout>

              </uix:stackLayout>

            </uix:dataScope>

            <uix:spacer height="10" />

    <%-- END: PARTITION STATISTICS PAGE ends here --%>   

    </uix:subTabLayout>  

    <uix:pageButtons>
      <uix:pageButtonBar>

        <%-- CANCEL BUTTON --%>
        <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
                          renderedBinding="canEditOpts@dataPartitionsBean@servletRequest"
                          name="event" 
                          value="cancelOpts" />
        <%-- OK BUTTON --%>
        <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="OK@uixDBObjectBundle@servletRequest"
                          name="event" 
                          value="finishOpts" />
      </uix:pageButtonBar>
    </uix:pageButtons>
  </uix:pageLayout>
  </db:form>
  <%-- END: HTML Form --%>

  </uix:body>

  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
