<%--
  -- Copyright (c) 2007, 2009, Oracle and/or its affiliates. 
  -- All rights reserved. 
  -- Page:       dataPartitionsStorage.jsp
  -- Controller: db/adm/schm/DataPartitionsController.java
  --
  -- Description: Storage tab for data [sub]partitions
  --              This tab allows the user to view/edit the various
  --              storage options for individual data [sub]partitions.
  --              Launched by the Advanced Options button.
  --  MODIFIED    (MM/DD/YY)
  --   chanchan    07/09/09 - Support new compression GUI (bug 8669360)
  --   chanchan    05/01/09 - Add columnar compression supports (ER bug #8276145)
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>

<uix:renderingContext id="renderingContext">

  <%-- Note: Must be named msgs due to wizTrain include  --%>
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="tableMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
  
    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <%-- HTML Form --%>
    <db:form name="tblForm" 
             method="post" 
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_STORAGE_PG %>"/>
        <uix:pageLayout titleBinding="storageHdr@dataPartitionsBean@servletRequest">

          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/globalPopup.jspf" %>

          <%-- Train --%>
          <%-- The train will only display if we are in the partitions wizard --%>
          <uix:location>

            <uix:switcher childNameBinding="isTableType@dataPartitionsBean@servletRequest">
              <uix:case name="true">
                <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="true">
                    <jsp:include page="wizTrain.jsp"/>
                    <uix:ref refID="wizTrain"/>
                  </uix:case>
                </uix:switcher>
              </uix:case>
            </uix:switcher>
          </uix:location>

          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- Create/Edit/View Header --%>
          <uix:subTabLayout>

            <%-- SubTabs --%>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
                <db:link textBinding="STORAGE@msgs" shortDescBinding="STORAGE@msgs" copyParams="target,type,cancelURL,sname,oname,otype"/>
                <uix:switcher childNameBinding="isIOTOverflow@dataPartitionsBean@servletRequest">
                  <uix:case name="true">
                    <db:link textBinding="OVERSTORAGE@msgs"
                             shortDescBinding="OVERSTORAGE@msgs"
                             onClick="submitForm('tblForm', true, {event:'pOverflow'})"
                             copyParams="target,type,cancelURL,sname,oname,otype"/>
                  </uix:case>
                </uix:switcher> 
                <uix:switcher childNameBinding="hasLOBs@dataPartitionsBean@servletRequest">
                  <uix:case name="true">
                    <db:link textBinding="LOBATTR@msgs"
                             shortDescBinding="LOBATTR@msgs"
                             onClick="submitForm('tblForm', true, {event:'pLOB'})"
                             copyParams="target,type,cancelURL,sname,oname,otype"/>
                  </uix:case>
                </uix:switcher> 

                <%-- Statistics tab (EDIT only) --%>
                <db:link textBinding="STATS@msgs"
                         shortDescBinding="STATS@msgs"
                         onClick="submitForm('tblForm', true, {event:'pStats'})"
                         renderedBinding="currentExists@dataPartitionsBean@servletRequest"
                         copyParams="target,type,cancelURL,sname,oname,otype"/>

              </uix:subTabBar>
            </uix:subTabs>

            <%-- START: PARTITION STORAGE PAGE starts here --%>

            <uix:rowLayout>
              <uix:tableLayout cellSpacing="5" width="100%">

                <%-- DESCRIPTION OF EDITING OPTIONS --%>
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                      <%-- Creating --%>
                      <uix:case name="true">
                        <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                          <uix:case name="true">

                            <uix:switcher childNameBinding="isTableType@dataPartitionsBean@servletRequest">
                              <uix:case name="true">
                                <uix:stackLayout>
                                <uix:styledText styleClass="OraInstructionText"
                                                renderedBinding="canEditOpts@dataPartitionsBean@servletRequest"
                                                textBinding="DESC_OPTS@msgs"/>

                                <uix:styledText styleClass="OraInstructionText"
                                                renderedBinding="isHash@dataPartitionsBean@servletRequest"
                                                textBinding="NO_HASH_STORAGE@msgs" />
                                </uix:stackLayout>
                              </uix:case>
                              <%-- Creating Index --%>
                              <uix:case name="false">
                                <uix:stackLayout>
                                <uix:styledText styleClass="OraInstructionText"
                                                renderedBinding="canEditOpts@dataPartitionsBean@servletRequest"
                                                textBinding="IDESC_OPTS@msgs"/>
                                <uix:styledText styleClass="OraInstructionText"
                                                renderedBinding="isHash@dataPartitionsBean@servletRequest"
                                                textBinding="NO_HASH_STORAGE@msgs" />
                                </uix:stackLayout>
                              </uix:case>
                            </uix:switcher>
                          </uix:case>
                          <%-- Creating Subs --%>
                          <uix:case name="false">
                            <uix:switcher childNameBinding="isTableType@dataPartitionsBean@servletRequest">
                              <uix:case name="false">
                                <uix:styledText styleClass="OraInstructionText"
                                                textBinding="IDESC_SUB_OPTS@msgs"/>
                              </uix:case>
                              <uix:case name="true">
                                <uix:styledText styleClass="OraInstructionText"
                                                textBinding="SUBS_NO_STORAGE@msgs"/>
                              </uix:case>
                            </uix:switcher>
                          </uix:case>
                        </uix:switcher>
                      </uix:case>
                      <%-- Editing --%>
                      <uix:case name="false">
                        <uix:switcher childNameBinding="isComposite@dataPartitionsBean@servletRequest">
                          <uix:case name="true">  
                            <uix:stackLayout>
                            <uix:styledText styleClass="OraInstructionText"
                                            textBinding="DESC_DEF_SUB_OPTS@msgs"
                                            renderedBinding="isParts@dataPartitionsBean@servletRequest" />
                            <uix:styledText styleClass="OraInstructionText"
                                            renderedBinding="isSubs@dataPartitionsBean@servletRequest"
                                            textBinding="SUBS_NO_STORAGE@msgs"/>
                            </uix:stackLayout>
                          </uix:case>
                          <%-- Editing, not composite --%>
                          <uix:case name="false">  
                            <uix:stackLayout>
                            <uix:styledText styleClass="OraInstructionText"
                                            renderedBinding="canEditOpts@dataPartitionsBean@servletRequest"
                                            textBinding="EDESC_OPTS@msgs" />
                            <uix:styledText styleClass="OraInstructionText"
                                            renderedBinding="isHash@dataPartitionsBean@servletRequest"
                                            textBinding="NO_HASH_STORAGE@msgs" />
                            </uix:stackLayout>
                          </uix:case>
                        </uix:switcher>
                      </uix:case>
                    </uix:switcher>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:rowLayout>

     <uix:dataScope currentDataBinding="pSegmentBean@servletRequest">
       <jsp:include page="/database/schema/utilities/storageContextInclude.jsp" />
         <uix:ref refID="storageInclude" />

         <%-- OPTIONS --%>
      <uix:switcher childNameBinding="isIOT@dataPartitionsBean@servletRequest">
        <uix:case name="false">
          <jsp:include page="/database/schema/compressOptionsInclude.jsp" />
          <uix:ref refID="compressInclude" />
        </uix:case>
        <uix:case name="true">
         <uix:header textBinding="OPTIONS@msgs"
                     renderedBinding="compressAvailable@">
           <uix:tableLayout cellSpacing="5" hAlign="left" width="100%">

            <%-- COMPRESS OPTION --%>
            <uix:rowLayout renderedBinding="compressAvailable@">
              <uix:cellFormat vAlign="top" hAlign="right">
                <uix:messagePrompt promptBinding="COMPRESS_HDR@msgs"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                <uix:stackLayout>
                  <oem:radioButton name="compress" 
                                   value="-1" 
                                   textBinding="DEFAULT_OPT@msgs"
                                   selectedValueBinding="compress@"
                                   disabledBinding="compressDisabled@"/>
                  <uix:switcher childNameBinding="isTableType@dataPartitionsBean@servletRequest">
                    <uix:case name="true">
                      <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                        <uix:case name="true">
                          <uix:rowLayout>
                            <uix:spacer width="21"/>
                              <uix:styledText styleClass="OraInlineInfoText"
                                              textBinding="TABLE_COMPRESS_DEF@msgs"/>
                          </uix:rowLayout>
                        </uix:case>
                        <uix:case name="false">
                          <uix:rowLayout>
                            <uix:spacer width="21"/>
                              <uix:styledText styleClass="OraInlineInfoText"
                                              textBinding="SUB_TABLE_COMPRESS_DEF@msgs"/>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                    <uix:case name="false">
                      <uix:rowLayout>
                        <uix:spacer width="21"/>
                          <uix:styledText styleClass="OraInlineInfoText"
                                          textBinding="INDEX_COMPRESS_DEF@msgs"/>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                  <oem:radioButton name="compress" 
                                   value="1" 
                                   textBinding="YES@uixDBObjectBundle@servletRequest"
                                   selectedValueBinding="compress@"
                                   disabledBinding="compressDisabled@"/>
                  <uix:switcher childNameBinding="isTableType@dataPartitionsBean@servletRequest">
                    <uix:case name="true">
                      <uix:switcher childNameBinding="isIOT@dataPartitionsBean@servletRequest">
                        <uix:case name="false">
                          <uix:rowLayout>
                            <uix:spacer width="21"/>
                            <uix:styledText styleClass="OraInlineInfoText"
                                            textBinding="COMPRESS_OPT@msgs"/>
                          </uix:rowLayout>
                        </uix:case>
                        <uix:case name="true">
                          <uix:rowLayout>
                            <uix:spacer width="21"/>
                            <uix:styledText styleClass="OraInlineInfoText"
                                            textBinding="COMPRESS_KEY_OPT@msgs"/>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                    <uix:case name="false">
                      <uix:rowLayout>
                        <uix:spacer width="21"/>
                          <uix:styledText styleClass="OraInlineInfoText"
                                          textBinding="COMPRESS_KEY_OPT@msgs"/>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                  <oem:radioButton name="compress" 
                                   value="0" 
                                   textBinding="NO@uixDBObjectBundle@servletRequest"
                                   selectedValueBinding="compress@"
                                   disabledBinding="compressDisabled@"/>

                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
        </uix:case>
      </uix:switcher>

    </uix:dataScope>

    <uix:spacer height="10" />

    <%-- END: PARTITION STORAGE PAGE ends here --%>   

    </uix:subTabLayout>  

    <uix:pageButtons>
      <uix:pageButtonBar>

        <%-- CANCEL BUTTON --%>
        <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
                          renderedBinding="canEditOpts@dataPartitionsBean@servletRequest"
                          name="event" 
                          value="cancelOpts" />
        <%-- OK BUTTON --%>
        <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="OK@uixDBObjectBundle@servletRequest"
                          name="event" 
                          value="finishOpts" />
      </uix:pageButtonBar>
    </uix:pageButtons>
  </uix:pageLayout>
  </db:form>
  <%-- END: HTML Form --%>

  </uix:body>

  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
