<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       dataSubpartitions.jsp
  -- Controller: db/adm/schm/DataPartitionsController.java
  --
  -- Description: Define partition-level subpartitions for composite 
  --              data partitions.  
  --              Launched by clicking Subpartitions button after 
  --              selecting a partition.
  --         OR   Define table-level subpartitions (template).
  --              Launched by clicking Subpartition Template button.
  --%>
<script language="JavaScript" src="/em/database/LOV.js"></script>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="partitionsBundle"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <%-- HTML Form --%>
    <db:form name="tblForm" 
             method="post"
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_SUB_PG %>"/>
      <uix:pageLayout titleBinding="subHdr@dataPartitionsBean@servletRequest">

        <%-- Warning/Error display --%>
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <%-- Oracle Logo and Tabs --%>
        <%@ include file="/database/global.jspf" %>

        <uix:pageStatus>
          <uix:labeledFieldLayout labelWidth="30%">
            <uix:messagePrompt promptBinding="PMETHOD@partitionsBundle"/>
            <uix:styledText styleClass="OraDataText" 
                            textBinding="displayType@dataPartitionsBean@servletRequest" />

            <uix:messagePrompt promptBinding="PCOLS@partitionsBundle"/>
            <uix:styledText styleClass="OraDataText" 
                            textBinding="pcolsList@partitionColsBean@servletRequest" />

                            <uix:switcher childNameBinding="isRangeList@dataPartitionsBean@servletRequest">
                              <uix:case name="true">     
                                <uix:messagePrompt promptBinding="SCOL@partitionsBundle"/>
                              </uix:case>
                              <uix:case name="false">     
                                <uix:messagePrompt promptBinding="SCOLS@partitionsBundle"/>
                              </uix:case>
                            </uix:switcher>
                            <uix:styledText styleClass="OraDataText" 
                                            textBinding="scolsList@partitionColsBean@servletRequest" />
            </uix:labeledFieldLayout>
          </uix:pageStatus>
          <%-- Follow page/wizard context information with a separator --%>
          <uix:separator/>

        <uix:subTabLayout>
         <uix:stackLayout> 

            <%-- START: SUBPARTITION PAGE starts here --%>
            <uix:stackLayout renderedBinding="creating@objectBean@servletRequest">
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="DESC_SUBS@partitionsBundle" />

              <uix:spacer height="10"/>
            </uix:stackLayout>

            <uix:stackLayout renderedBinding="isRangeList@dataPartitionsBean@servletRequest">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="SUB_LVDESC@msgs"/>

              <uix:spacer height="5"/>
            </uix:stackLayout>

      <%-- SWITCH: Create subpartitions --%>
      <uix:switcher childNameBinding="creating@objectBean@servletRequest">

        <%-- CASE: Create subpartitions --%>
        <uix:case name="true">
        <uix:stackLayout>

         <uix:rowLayout>  
            <uix:messagePrompt promptBinding="NUMSUBPARTS@partitionsBundle" labeledNodeId="NUMSUBPARTS"/>    
            <uix:spacer width="5"/>
            <uix:textInput name="numSubparts" id="NUMSUBPARTS" shortDescBinding="NUMSUBPARTS@partitionsBundle"
                 textBinding="numSubparts@dataPartitionsBean@servletRequest" 
                 columns="7">
              <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
            </uix:textInput>
            <uix:spacer width="10"/>

                        <uix:messageLovField name="tablespaceListS" 
                                             promptBinding="STOREIN@partitionsBundle"
                                             textBinding="tablespaceListS@dataPartitionsBean@servletRequest"
                                             columns="40"
                                             searchDescBinding="SELECT_TS@msgs"
                                             tipBinding="TSTIP@partitionsBundle"
                                             onClick = "appendData();selectMultiple();startLov('tablespaceListS', 'ListTablespacePerm')"/>

<%--
                                             onClickBinding="tablespacelistlovdest@servletRequest" />
--%>

            <uix:spacer width="5"/>
            <uix:submitButton textBinding="ADD@partitionsBundle" name="event" value="addSubpartitions"  shortDescBinding="ADD@partitionsBundle"/>
           </uix:rowLayout> 

          <%-- SWITCH: Delete all subpartitions --%>
          <uix:switcher childNameBinding="haveSubs@dataPartitionsBean@servletRequest">
            <%-- CASE: Have at least 1 subpartition --%>
            <uix:case name="true">
 
              <%-- DELETE ALL SUBPARTITIONS --%>
              <uix:rowLayout width="100%">
                <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                  <uix:submitButton textBinding="DELETEAS@partitionsBundle" name="event" value="deleteAllSubpartitions" shortDescBinding="DELETEAS@partitionsBundle"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>

        </uix:stackLayout>
        </uix:case>
      </uix:switcher>

      <%-- BEGIN EDIT --%>
      <%-- Search Prompt --%>
      <uix:stackLayout renderedBinding="canSearch@dataPartitionsBean@servletRequest" >
        <uix:rowLayout>
          <uix:styledText styleClass="OraInstructionText" textBinding="SEARCHSNAME@msgs" labeledNodeId="SEARCHSNAME"/>
          <uix:spacer height="1" width="5"/>
          <uix:textInput name="searchSubPartName" textBinding="searchSubPartName@dataPartitionsBean@servletRequest" columns="32" id="SEARCHSNAME" shortDescBinding="SEARCHSNAME@msgs"/>
          <uix:spacer height="1" width="5"/>
          <uix:submitButton textBinding="GO@msgs" name="event" value="searchPartitions" shortDescBinding="GO@msgs"/>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:spacer height="5"/>
        </uix:rowLayout>
      </uix:stackLayout>
      <%-- End Search Prompt --%>

      <uix:stackLayout>
      <uix:rowLayout width="100%">
        <uix:cellFormat hAlign="right" vAlign="top" width="100%">
          <uix:submitButton textBinding="COALESCE@msgs" 
                            shortDescBinding="COALESCE@msgs"
                            name="event" 
                            renderedBinding="canCoalesce@dataPartitionsBean@servletRequest" 
                            disabledBinding="disableCoalesce@dataPartitionsBean@servletRequest" 
                            value="coalesceSubpartition"/>
        </uix:cellFormat>
      </uix:rowLayout>

      <oem:table name="dataSubpartitionsUI" 
                 beanKey="dataPartitionsBean" 
                 formSubmitted="true" 
                 dataSourceProp="dataSubpartitionsUI" 
                 summaryBinding="SUBPARTITIONS@partitionsBundle"
                 blockSize="10" 
                 width="100%"
                 alternateTextBinding="NO_SPARTS@partitionsBundle">    

        <uix:tableSelection>
          <oem:singleSelection
               selectedIndexBinding="selectedIndex2@dataPartitionsBean@servletRequest" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest">
          <uix:flowLayout>

          <uix:flowLayout>
            <uix:spacer width="5"/>
            <uix:submitButton textBinding="ADVOPT@msgs" 
                              shortDescBinding="ADVOPT@msgs"
                              name="event" 
                              value="advOptionsSub"/>

            <uix:spacer width="5"/>
            <uix:submitButton textBinding="INSERT@msgs" 
                              shortDescBinding="INSERT@msgs"
                              name="event" 
                              renderedBinding="creating@dataPartitionsBean@servletRequest" 
                              value="insertSubpartition"/>

            <uix:spacer width="5"/>
            <uix:submitButton textBinding="DELETE@msgs" 
                              shortDescBinding="DELETE@msgs"
                              name="event" 
                              disabledBinding="disableDelete@dataPartitionsBean@servletRequest" 
                              value="deleteSubpartition"/>
          </uix:flowLayout>         

          <uix:flowLayout renderedBinding="allowPMOPs@dataPartitionsBean@servletRequest" >      
                  <uix:spacer width="10"/>
                  <uix:messagePrompt promptBinding="ACTIONS@partitionsBundle" labeledNodeId="ACTIONS"/>
                  <uix:spacer width="5"/>
                  <uix:choice name="actionChoice" id="ACTIONS"
                              shortDescBinding="ACTIONS@partitionsBundle"
                              selectedValueBinding="selectedAction@dataPartitionsBean@servletRequest">
                    <uix:option textBinding="TRUNCATE@partitionsBundle" value="0" />                                
                    <uix:switcher childNameBinding="isRangeList@dataPartitionsBean@servletRequest">
                      <uix:case name="true">          
                        <uix:stackLayout>
                          <uix:option textBinding="MERGE@partitionsBundle" value="1" />               
                          <uix:option textBinding="SPLIT@partitionsBundle" value="2" />
                          <uix:option textBinding="EDIT_VALS@partitionsBundle" value="9" />
                        </uix:stackLayout>
                      </uix:case>
                    </uix:switcher>         
                    <uix:option textBinding="RENAME@partitionsBundle" value="3" /> 
                    <uix:option textBinding="MOVE@partitionsBundle" value="4" />
                    <uix:option textBinding="EXCHANGE@partitionsBundle" value="8" />
                    <uix:option textBinding="REBUILD_IDX@partitionsBundle" value="6" />
                    <uix:option textBinding="UNUSABLE_IDX@partitionsBundle" value="7" />                                     
                    <uix:option textBinding="PLACE_INDEXES@partitionsBundle" value="14"
                                renderedBinding="canPlaceIndexesSubAction@dataPartitionsBean@servletRequest"/>      
                  </uix:choice>  
                  <uix:spacer width="5"/>
                  <uix:submitButton textBinding="GO@partitionsBundle" 
                                    shortDescBinding="GO@partitionsBundle"
                                    name="event" 
                                    value="selectActionSub" />       
                </uix:flowLayout>

          </uix:flowLayout>
          </oem:singleSelection>
        </uix:tableSelection>

        <uix:footer>
          <uix:switcher childNameBinding="editing@dataPartitionsBean@servletRequest">
            <uix:case name="true">
              <uix:submitButton textBinding="ADDAS@msgs" 
                                shortDescBinding="ADDAS@msgs"
                                name="event" 
                                value="addPartSub"
                                renderedBinding="canAdd@dataPartitionsBean@servletRequest" />
            </uix:case>
            <uix:case name="false">
              <uix:submitButton textBinding="ADDAS@msgs" 
                                shortDescBinding="ADDAS@msgs"
                                name="event" 
                                value="addSubpartition"
                                renderedBinding="canAdd@dataPartitionsBean@servletRequest" />
            </uix:case>
          </uix:switcher>

        </uix:footer>
      </oem:table>

      <uix:spacer height="5"/>

          <uix:tip renderedBinding="creating@dataPartitionsBean@servletRequest">
            <uix:styledText styleClass="OraTipText"
                            textBinding="REVERT_TEMPLATE@msgs" />
          </uix:tip>

      <uix:switcher childNameBinding="isRangeList@dataPartitionsBean@servletRequest">
        <uix:case name="false">        
          <uix:tip renderedBinding="editing@dataPartitionsBean@servletRequest">
            <uix:styledText styleClass="OraTipText"
                            textBinding="SUB_HDELTIP@msgs" />
          </uix:tip>
        </uix:case>

        <uix:case name="true">  
            <uix:tip renderedBinding="canUseDef@dataPartitionsBean@servletRequest">
              <uix:styledText styleClass="OraTipText"
                              textBinding="SUB_L_DEF_TIP@msgs" />
            </uix:tip>      
        </uix:case>

      </uix:switcher>

      </uix:stackLayout>


         </uix:stackLayout> 
        </uix:subTabLayout>  

        <uix:pageButtons>
          <uix:pageButtonBar>

            <%-- SHOW SQL BUTTON --%>
            <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" 
                              shortDescBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                              name="event" 
	                      renderedBinding="editing@dataPartitionsBean@servletRequest"
                              value="showSql" />

            <%-- CANCEL BUTTON --%>
            <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                              shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
                              name="event" 
                              value="cancelSubs" />

            <%-- OK BUTTON --%>
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                              shortDescBinding="OK@uixDBObjectBundle@servletRequest"
                              name="event" 
                              value="finishSubs" />
            </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
    </db:form>
    <%-- END: HTML Form --%>

  </uix:body>

  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
