<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        deleteAllConfirmation.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Confirmation page for deleting all partitions, 
  --              all template subpartitions, and all partition-level
  --              subpartitions.
  --
  --  MODIFIED    (MM/DD/YY)
  --     sresrini  03/21/06 - Fix jsp compilation errors
  --     chanchan  10/09/03 - Add ADA supports 
  --     mpawelko  09/25/03 - mpawelko_partition_validation 
  --     mpawelko  09/23/03 - created 
  --%>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="pmsgs" 
              class="oracle.sysman.db.rsc.schm.PartitionsMsg" />
  <uix:bundle name="DBObjectBundle"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
 
    <uix:metaContainer>
      <uix:head titleBinding="CONFIRMATION@DBObjectBundle"/>
    </uix:metaContainer>

    <uix:body>
     <db:form name="tblForm"
              method="post"
              destinationBinding="destination@objectBean@servletRequest"
              copyParams="target,type,cancelURL,sname,oname,otype">
       <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_DELETE_ALL_PG %>"/>
         <uix:pageLayout messageType="confirmation">
          
           <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
           <%@ include file="/database/globalPopup.jspf" %>

           <uix:pageStatus>
             <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
               <uix:case name="true">
                 <uix:styledText styleClass="OraDataText" textBinding="DELETE_ALL_WARN@pmsgs" />  
               </uix:case>
               <uix:case name="false">
                 <uix:switcher childNameBinding="isSubTemplate@dataPartitionsBean@servletRequest">
                   <uix:case name="true">
                     <uix:styledText styleClass="OraDataText" textBinding="SUB_DELETE_ALL_WARN@pmsgs" />  
                   </uix:case>
                   <uix:case name="false">
                     <uix:styledText styleClass="OraDataText" textBinding="SUBPART_DELETE_ALL_WARN@pmsgs" />  
                   </uix:case>
                 </uix:switcher>
               </uix:case>
             </uix:switcher>
           </uix:pageStatus>

           <uix:spacer height="10"/>

           <uix:styledText styleClass="OraInstructionText" textBinding="CONTINUE_QUESTION@pmsgs" />  



          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="NO@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="NO@uixDBObjectBundle@servletRequest"
                      destination="javascript: history.back()" />
              <uix:submitButton textBinding="YES@uixDBObjectBundle@servletRequest" 
                                shortDescBinding="YES@uixDBObjectBundle@servletRequest"
                                name="event" 
                                value="doDeleteAllPartitions" />
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>            
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
