<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       indexPMOP.jsp
  -- Controller: db/adm/schm/IndexPartitionsController.java
  --
  -- Description: Partition Maintenance Operation (PMOP) property
  --              pages for index [sub]partitions
  --              Launched when necessary by selecting an Action
  --              from the Actions choice box [EDIT only]
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<script language="JavaScript" src="/em/database/LOV.js"></script>

<script language="javascript">
function setParallel()
{
  if (document.forms[0].parallel != null)
  {
    document.forms[0].defaultDegree[0].disabled = !document.forms[0].parallel.checked;
    document.forms[0].defaultDegree[1].disabled = !document.forms[0].parallel.checked;
    document.forms[0].degree.disabled = (document.forms[0].defaultDegree[0].checked || document.forms[0].defaultDegree[0].disabled);
  }
}
</script>


<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">

  <uix:bundle name="partitionsBundle"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="DBObjectBundle"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

  <%-- Browser title.  Page name from controller getPageHeader() --%>
  <%@ include file="/oemTitle.jspf" %>

  <uix:body onLoad="setParallel()">

    <%-- HTML Form --%>
    <db:form name="indexForm"
             method="post"
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_IDX_PMOP_PG %>"/>
        <uix:pageLayout titleBinding="PMOPHdr@dataPartitionsBean@servletRequest">
          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>

          <uix:pageStatus> 
            <uix:switcher childNameBinding="selectedAction@dataPartitionsBean@servletRequest">
              <!-- CASE: SPLIT operation -->
              <uix:case name="2">
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="RSPLIT_DESC@partitionsBundle"/>
              </uix:case>

              <!-- CASE: REBUILD PARTITION (MOVE) operation  -->
              <uix:case name="4">
                <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                  <uix:case name="true">
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="REBUILDPART_DESC@partitionsBundle"/>
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="SUB_REBUILDPART_DESC@partitionsBundle"/>
                  </uix:case> 
                </uix:switcher> 
              </uix:case> 

            </uix:switcher>
          </uix:pageStatus> 

          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- Create/Edit/View Header --%>
          <uix:subTabLayout>

            <%-- START: PMOP PAGE starts here --%>
            <uix:stackLayout>

              <!-- SWITCH: PMOP operation -->
              <uix:switcher childNameBinding="selectedAction@dataPartitionsBean@servletRequest">

                <!-- CASE: SPLIT operation -->
                <uix:case name="2">
                <uix:stackLayout>
                  <uix:spacer height="10"/>        
                  <oem:table name="dataPartitionsUI" 
                             beanKey="dataPartitionsBean" 
                             formSubmitted="true" 
                             dataSourceProp="dataPartitionsUI" 
                             summaryBinding="INDEX_PARTS@partitionsBundle"
                             blockSize="10"
                             width="100%" >
                  </oem:table>

                  <%-- Include PMOP OPTIONS --%>
                  <jsp:include page="/database/schema/partitions/dataPMOPOpt.jsp"/>
                  <uix:ref refID="dataPMOPOpt"/>

                </uix:stackLayout>
                </uix:case>

                <!-- CASE: RENAME operation -->
                <uix:case name="3">
                <uix:stackLayout>
                  <uix:spacer height="10"/>

                  <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                    <uix:case name="true">    
                      <uix:messageTextInput name="newPartName" 
                                            required="yes"
                                            promptBinding="NPNAME@partitionsBundle" 
                                            shortDescBinding="NPNAME@partitionsBundle" 
                                            textBinding="newPartName@dataPartitionsBean@servletRequest" 
                                            tipBinding="IRENAME_TIP@partitionsBundle" 
	                                    columns="35"/>
                    </uix:case>
                    <uix:case name="false"> 
                      <uix:messageTextInput name="newPartName"
                                            required="yes" 
                                            promptBinding="NSNAME@partitionsBundle" 
                                            shortDescBinding="NSNAME@partitionsBundle" 
                                            textBinding="newPartName@dataPartitionsBean@servletRequest" 
                                            tipBinding="ISRENAME_TIP@partitionsBundle" 
	                                    columns="35"/>
                    </uix:case>
                  </uix:switcher>
                </uix:stackLayout>
                </uix:case>

                <!-- CASE: REBUILD PARTITION (MOVE) operation  -->
                <uix:case name="4">
                <uix:stackLayout>
                  <uix:spacer height="10"/>        
                  <oem:table name="dataPartitionsUI"
                             beanKey="dataPartitionsBean" 
                             formSubmitted="true" 
                             dataSourceProp="dataPartitionsUI" 
                             summaryBinding="INDEX_PARTS@partitionsBundle"
                             blockSize="10"
                             width="100%" >
                  </oem:table>

                  <%-- Include PMOP OPTIONS --%>
                  <jsp:include page="/database/schema/partitions/dataPMOPOpt.jsp"/>
                  <uix:ref refID="dataPMOPOpt"/>

                </uix:stackLayout>
                </uix:case>

              </uix:switcher>

              <uix:spacer height="20"/>        
              <%-- Tip --%>
              <uix:rowLayout>
                <uix:tip>
                  <uix:styledText styleClass="OraTipText"
                                  textBinding="CONFIRM_IDX_TIP@partitionsBundle" />
                </uix:tip>
              </uix:rowLayout>
            </uix:stackLayout>
            <%-- END: PMOP PAGE ends here --%>   

          </uix:subTabLayout>  

          <uix:pageButtons>
            <uix:pageButtonBar>

	  <%-- CANCEL BUTTON --%>
	    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                              shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest" 
			      name="event" 
                              unvalidated="true"

			      value="cancelPMOP" />

            <%-- OK BUTTON --%>
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                              shortDescBinding="OK@uixDBObjectBundle@servletRequest" 
                              name="event" 
                              value="finishPMOP" />
            </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
    </db:form>
    <%-- END: HTML Form --%>

  </uix:body>

  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
