<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        indexPartitions.jsp
  -- Controller:  db/adm/schm/IndexPartitionsController.java
  --
  -- Description: Main index partitions page
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">

  <uix:bundle name="partitionsBundle"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
  <%-- Browser title.  Page name from controller getPageHeader() --%>
  <%@ include file="/oemTitle.jspf" %>

<uix:body>

<%-- HTML Form --%>
<db:form name="indexForm" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_IDX_PG %>"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/index/subTabsInclude.jsp" />
      <uix:ref refID="indexSubTabsInclude" />
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>

    <!-- SWITCH: Index type -->
    <uix:switcher childNameBinding="selectedTypeInt@dataPartitionsBean@servletRequest">

      <!-- CASE: Local index -->
      <uix:case name="5">
        <uix:rowLayout width="100%">
          <jsp:include page="/database/schema/partitions/indexPartitionsL.jsp"/>
          <uix:ref refID="indexPartitionsL"/>
        </uix:rowLayout> 
      </uix:case>  

      <!-- CASE: Global-Range index -->
      <uix:case name="6">
        <uix:rowLayout width="100%">
          <jsp:include page="/database/schema/partitions/indexPartitionsGR.jsp"/>
          <uix:ref refID="indexPartitionsGR"/>
        </uix:rowLayout> 
      </uix:case>  

      <!-- CASE: Global-Hash index -->
      <uix:case name="7">
        <uix:rowLayout width="100%">
          <jsp:include page="/database/schema/partitions/indexPartitionsGH.jsp"/>
          <uix:ref refID="indexPartitionsGH"/>
        </uix:rowLayout> 
      </uix:case>  

    </uix:switcher>
    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 


