<%--
  -- Page:        indexPartitionsGH.jsp
  -- Controller:  db/adm/schm/IndexPartitionsController.java
  --
  -- Description: Create/Edit Global-Hash (10i) index partitions page
  --%>
<script language="JavaScript" src="/em/database/LOV.js"></script>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/utils.js"/>

<uix:buildTree nodeID="indexPartitionsGH">

  <%-- START: TAB CONTENTS starts here --%>

  <%-- SWITCH: Create/Edit partitions --%>
  <uix:switcher childNameBinding="creating@objectBean@servletRequest">

    <%-- CASE: Create partitions --%>
    <uix:case name="true">

      <uix:stackLayout>
        <uix:checkBox name="partsEnabled"
                      checkedBinding="partsEnabled@dataPartitionsBean@servletRequest"
                      onClick="submitForm('indexForm', true, {'event':'changeEnable'})"
                      textBinding="ENABLEPART@partitionsBundle" />
            <uix:rowLayout>
              <uix:flowLayout>
                <uix:spacer width="21" height="1" />
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="IDX_PART_INSTR@partitionsBundle"/>
              </uix:flowLayout>
            </uix:rowLayout>

          <uix:spacer height="5"/>

          <%-- Partitioning method --%>
          <uix:rowLayout>
            <uix:cellFormat> 
              <uix:spacer height="1" width="20" />
            </uix:cellFormat>

            <uix:cellFormat hAlign="right">
              <uix:styledText textBinding="PMETHOD@partitionsBundle"
                              labeledNodeId="PMETHOD"
                              styleClass="OraPromptText" />

            </uix:cellFormat>

            <uix:cellFormat> 
              <uix:spacer height="1" width="5" />
            </uix:cellFormat>

            <uix:cellFormat> 
              <uix:choice name="ptype" 
                          onChange="submitForm('indexForm', true, {'event':'changeType'})"
                          id="PMETHOD"
                          shortDescBinding="PMETHOD@partitionsBundle"
                          selectedValueBinding="selectedTypeInt@dataPartitionsBean@servletRequest"
                          disabledBinding="partsDisabled@dataPartitionsBean@servletRequest">

                <uix:option textBinding="LOCAL@partitionsBundle"
                            renderedBinding="isOnPartitioned@dataPartitionsBean@servletRequest"
                            value="5" />
                <uix:option textBinding="GLOBALRANGE@partitionsBundle"
                            value="6" />
                <uix:option textBinding="GLOBALHASH@partitionsBundle"
                            value="7" />
              </uix:choice>  
           </uix:cellFormat>

          </uix:rowLayout>

          <uix:spacer height="5"/>

          <%-- start : header --%>
          <uix:header textBinding="PMETHODGH@partitionsBundle">

          <uix:rowLayout>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="GHDESC@partitionsBundle"/>
          </uix:rowLayout>
          </uix:header>


        <%-- Indent --%>   
        <uix:rowLayout width="100%">
          <uix:cellFormat> 
            <uix:spacer height="1" width="20" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="right">

        <%-- start : header --%>
        <uix:header textBinding="PCOLS@partitionsBundle">

          <%-- SWITCH: Columns available/No columns available --%>
          <uix:switcher childNameBinding="multiCols@partitionColsBean@servletRequest">
            <%-- CASE: Columns available to be added --%>
            <uix:case name="true">
              <uix:stackLayout>

              <uix:rowLayout width="80%">
                <uix:styledText styleClass="OraInstructionText" 
                                textBinding="GHCOLS@partitionsBundle"/>
              </uix:rowLayout>

              <uix:spacer height="5"/>

              <uix:rowLayout width="80%">
              <uix:cellFormat hAlign="right" vAlign="top">

                <uix:messagePrompt promptBinding="PCOL@partitionsBundle" labeledNodeId="PCOL"/>
                <uix:spacer width="5"/>
                <oem:choice name="pcol" 
                            id="PCOL"
                            shortDescBinding="PCOL@partitionsBundle"
                            optionsBinding="pcols@partitionColsBean@servletRequest" 
                            disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"/>

                <uix:spacer width="10"/>
                <uix:submitButton textBinding="ADD@partitionsBundle" 
                                  shortDescBinding="ADD@partitionsBundle" 
                                  name="event" 
                                  disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                  value="addFirst"/>
              </uix:cellFormat>
              </uix:rowLayout>
             </uix:stackLayout>
            </uix:case>

            <%-- CASE: No columns left to add --%>
            <uix:case name="false">
              <uix:stackLayout>
                <uix:rowLayout width="80%">
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="GHCOLSDESC@msgs"/>
                </uix:rowLayout>
                <uix:spacer height="5"/>
              </uix:stackLayout>

            </uix:case>
          </uix:switcher>


          <oem:table name="partitionColsUI" 
                     beanKey="partitionColsBean" 
                     formSubmitted="true" 
                     dataSourceProp="partitionColsUI" 
                     blockSize="10" 
                     width="80%"
                     summaryBinding="PCOLS@partitionsBundle"
                     alternateTextBinding="NO_PCOLS@partitionsBundle">

            <uix:footer>
              <uix:submitButton textBinding="REMOVE@partitionsBundle" 
                                shortDescBinding="REMOVE@partitionsBundle" 
                                name="event" 
                                renderedBinding="haveCol@partitionColsBean@servletRequest"
                                disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                value="delLPCol"/>

             </uix:footer>
          </oem:table>          
          <uix:tip>
            <uix:styledText textBinding="PREFIX_TIP@msgs"
                            styleClass="OraTipText"/>
          </uix:tip>
        </uix:header>

        </uix:cellFormat>
       </uix:rowLayout>

       </uix:stackLayout>
     </uix:case>

     <%-- CASE: Edit partitions --%>
     <uix:case name="false">
     <uix:stackLayout>
       <uix:spacer height="10"/>
       <uix:labeledFieldLayout labelWidth="20%">
         <uix:messagePrompt promptBinding="PMETHOD@partitionsBundle"/>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="displayType@dataPartitionsBean@servletRequest" />
         <uix:messagePrompt promptBinding="PCOLS@partitionsBundle"/>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="pcolsList@partitionColsBean@servletRequest" />
       </uix:labeledFieldLayout>
     </uix:stackLayout>
     </uix:case>
    </uix:switcher>  

    <uix:spacer height="1"/>        

    <%-- Indent --%>   
    <uix:rowLayout width="100%">
      <uix:cellFormat> 
        <uix:spacer height="1" width="20" />
      </uix:cellFormat>
      <uix:cellFormat hAlign="right">
    
    <uix:header textBinding="PARTS@partitionsBundle">
      <uix:spacer height="5"/>

      <%-- SWITCH: Create partitions --%>
      <uix:switcher childNameBinding="creating@objectBean@servletRequest">

        <%-- CASE: Create partitions --%>
        <uix:case name="true">
        <uix:stackLayout>

            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" width="100%" vAlign="top">

            <uix:messageTextInput name="numParts" 
                                  promptBinding="NUMPARTS@partitionsBundle"
                                  shortDescBinding="NUMPARTS@partitionsBundle"
                 textBinding="numParts@dataPartitionsBean@servletRequest"
                 disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                 columns="3">
              <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
            </uix:messageTextInput>
              </uix:cellFormat>
<uix:spacer width="10"/>
              <uix:cellFormat>


                <uix:messageLovField name="tablespaceList"
                                     promptBinding="STOREIN@partitionsBundle"
                                     textBinding="tablespaceList@dataPartitionsBean@servletRequest"
                                     disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                     columns="50"
                                     shortDescBinding="SELECT_TS@msgs"
                                     searchDescBinding="SELECT_TS@msgs"
                                     tipBinding="TSTIP@partitionsBundle"
                                     onClick = "appendData();selectMultiple();startLov('tablespaceList', 'ListTablespacePerm')"/>

<%--
                                         onClickBinding="ghtblspclistlovdest@servletRequest" />
--%>
              </uix:cellFormat>

              <uix:spacer width="5"/>
              <uix:cellFormat>

                <uix:submitButton textBinding="ADD@partitionsBundle" 
                                  shortDescBinding="ADD@partitionsBundle" 
                                  name="event" 
                                  disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                  value="addPartitions"/>
              </uix:cellFormat>
            </uix:rowLayout>

      <%-- GLOBAL TABLE BUTTONS --%>
      <uix:rowLayout width="100%">

        <%-- SWITCH: Delete all partitions --%>
        <uix:switcher childNameBinding="haveParts@dataPartitionsBean@servletRequest">
          <%-- CASE: Have at least 1 partition --%>
          <uix:case name="true">
            <uix:cellFormat hAlign="right" vAlign="top" width="100%">
              <uix:submitButton textBinding="DELETEAP@partitionsBundle" 
                                shortDescBinding="DELETEAP@partitionsBundle" 
                                name="event" 
                                disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                value="deleteAllPartitions"/>
            </uix:cellFormat>
          </uix:case>
        </uix:switcher>
      </uix:rowLayout>

    </uix:stackLayout>
    </uix:case>

    <%-- CASE: Edit partitions --%>
    <uix:case name="false">
        <%-- Search Prompt --%>
         <uix:stackLayout renderedBinding="canSearch@dataPartitionsBean@servletRequest" >
           <uix:rowLayout>
             <uix:styledText styleClass="OraInstructionText" textBinding="SEARCHPNAME@msgs" labeledNodeId="SEARCHPNAME"/>
             <uix:spacer height="1" width="5"/>
             <uix:textInput name="searchPartName" textBinding="searchPartName@dataPartitionsBean@servletRequest" columns="32" id="SEARCHPNAME" shortDescBinding="SEARCHPNAME@msgs"/>
             <uix:spacer height="1" width="5"/>
             <uix:submitButton textBinding="GO@msgs" name="event" value="searchPartitions" shortDescBinding="GO@msgs"/>
           </uix:rowLayout>
         </uix:stackLayout>
         <%-- End Search Prompt --%>
    </uix:case>
   </uix:switcher>

      <oem:table name="dataPartitionsUI" 
                 beanKey="dataPartitionsBean" 
                 formSubmitted="true" 
                 dataSourceProp="dataPartitionsUI" 
                 blockSize="10" 
                 width="100%"
                 summaryBinding="PARTS@partitionsBundle"
                 alternateTextBinding="NO_PARTS@partitionsBundle">    

        <uix:tableSelection>
          <oem:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
               selectedIndexBinding="selectedIndex@dataPartitionsBean@servletRequest">
          <uix:flowLayout>

            <%-- SWITCH: Create partitions --%>
            <uix:switcher childNameBinding="creating@objectBean@servletRequest">
              <%-- CASE: Create partitions --%>
              <uix:case name="true">
                <uix:flowLayout>
                  <uix:submitButton textBinding="ADVOPT@partitionsBundle" 
                                    shortDescBinding="ADVOPT@partitionsBundle" 
                                    name="event" 
                                    disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                    value="advOptions"/>
                  <uix:spacer width="5"/>
                  <uix:submitButton textBinding="INSERT@partitionsBundle" 
                                    shortDescBinding="INSERT@partitionsBundle" 
                                    name="event" 
                                    disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                    value="insertPartition"/>
                  <uix:spacer width="5"/>
                  <uix:submitButton textBinding="DELETE@partitionsBundle" 
                                    shortDescBinding="DELETE@partitionsBundle" 
                                    name="event" 
                                    disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                    value="deletePartition"/>
                </uix:flowLayout>
              </uix:case>

              <%-- CASE: Edit partitions --%>
              <uix:case name="false">
                <uix:flowLayout>
                  <uix:submitButton textBinding="ADVOPT@partitionsBundle" 
                                    shortDescBinding="ADVOPT@partitionsBundle" 
                                    name="event" 
                                    value="advOptions"/>
                  <uix:spacer width="5"/>
                  <uix:submitButton textBinding="DELETE@partitionsBundle" 
                                    shortDescBinding="DELETE@partitionsBundle" 
                                    name="event" 
                                    disabledBinding="disableDelete@dataPartitionsBean@servletRequest"
                                    value="deletePartition"/>

                  <uix:spacer width="10"/>
                  <uix:messagePrompt promptBinding="ACTIONS@partitionsBundle" labeledNodeId="ACTIONS"/>
                  <uix:spacer width="5"/>
                  <uix:choice name="actionChoice" id="ACTIONS"
                              selectedValueBinding="selectedAction@dataPartitionsBean@servletRequest">
                    <uix:option textBinding="RENAME@partitionsBundle" value="3" />
                    <uix:option textBinding="REBUILDPART@partitionsBundle" value="4" />
                    <uix:option textBinding="COALESCE@partitionsBundle" value="13" />
                  </uix:choice>  
                  <uix:spacer width="5"/>
                  <uix:submitButton textBinding="GO@partitionsBundle" 
                                    shortDescBinding="GO@partitionsBundle" 
                                    name="event" 
                                    value="selectAction" />       
               </uix:flowLayout>
              </uix:case>
            </uix:switcher>
 
          </uix:flowLayout>
          </oem:singleSelection>
        </uix:tableSelection>

        <uix:footer>
          <%-- SWITCH: Create/Edit partitions --%>
          <uix:switcher childNameBinding="creating@objectBean@servletRequest">
            <%-- CASE: Edit partitions --%>
            <uix:case name="false">
              <uix:submitButton textBinding="ADDAP@partitionsBundle" name="event" value="addPartition" shortDescBinding="ADDAP@partitionsBundle"/>
            </uix:case>
            <%-- CASE: Create partitions --%>
            <uix:case name="true">
              <uix:submitButton textBinding="ADDAP@partitionsBundle" 
                                name="event" 
                                value="doAddPartition" 
                                disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                shortDescBinding="ADDAP@partitionsBundle"/>
            </uix:case>
          </uix:switcher>
        </uix:footer>
      </oem:table>

      <uix:rowLayout>
        <uix:stackLayout>	
          <uix:spacer height="5"/>
          <uix:tip>
            <uix:styledText textBinding="PSPEC_HASH_HINT@msgs"
                            styleClass="OraTipText"/>
          </uix:tip>
        </uix:stackLayout>
      </uix:rowLayout>

      <uix:spacer height="5"/>

    </uix:header>
    </uix:cellFormat>
    </uix:rowLayout>

  <%-- END: TAB CONTENTS ends here --%>   

</uix:buildTree>
       


