<%--
  -- Page:        indexPartitionsL.jsp
  -- Controller:  db/adm/schm/IndexPartitionsController.java
  --
  -- Description: Create/Edit Local index partitions page
  --%>
<script language="JavaScript" src="/em/database/LOV.js"></script>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/utils.js"/>

<uix:buildTree nodeID="indexPartitionsL">  

  <%-- START: TAB CONTENTS starts here --%>

  <%-- SWITCH: Create/Edit partitions --%>
  <uix:switcher childNameBinding="creating@objectBean@servletRequest">

    <%-- CASE: Create partitions --%>
    <uix:case name="true">
      <uix:stackLayout>
        <uix:checkBox name="partsEnabled"
                      checkedBinding="partsEnabled@dataPartitionsBean@servletRequest"
                      onClick="submitForm('indexForm', true, {'event':'changeEnable'})"
                      textBinding="ENABLEPART@partitionsBundle" />

            <uix:rowLayout>
              <uix:flowLayout>
                <uix:spacer width="21" height="1" />
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="IDX_PART_INSTR@partitionsBundle"/>
              </uix:flowLayout>
            </uix:rowLayout>


          <uix:spacer height="5"/>

          <%-- Partitioning method --%>
          <uix:rowLayout>

            <uix:cellFormat> 
              <uix:spacer height="1" width="20" />
            </uix:cellFormat>

            <uix:cellFormat hAlign="right">
              <uix:styledText textBinding="PMETHOD@partitionsBundle"
                              styleClass="OraPromptText" />

            </uix:cellFormat>

            <uix:cellFormat> 
              <uix:spacer height="1" width="5" />
            </uix:cellFormat>

            <uix:cellFormat> 
              <uix:switcher childNameBinding="onlyLocal@dataPartitionsBean@servletRequest">
                <uix:case name="true">
                  <uix:styledText styleClass="OraDataText" 
                                  textBinding="LOCAL@partitionsBundle" />
                </uix:case>
                <uix:case name="false">
                  <uix:choice name="ptype" 
                              onChange="submitForm('indexForm', true, {'event':'changeType'})"
                              selectedValueBinding="selectedTypeInt@dataPartitionsBean@servletRequest" 
                              shortDescBinding="PMETHOD@partitionsBundle"
                              disabledBinding="partsDisabled@dataPartitionsBean@servletRequest">

                    <uix:option textBinding="LOCAL@partitionsBundle"
                                value="5" />
                    <uix:option textBinding="GLOBALRANGE@partitionsBundle"
                                value="6" />
                    <uix:option textBinding="GLOBALHASH@partitionsBundle"
                                renderedBinding="is10i@dataPartitionsBean@servletRequest"
                                value="7" />
                  </uix:choice>  
                </uix:case>
              </uix:switcher>
            </uix:cellFormat>

          </uix:rowLayout>

          <uix:spacer height="5"/>

        <%-- start : header --%>
        <uix:header textBinding="PMETHODL@partitionsBundle">

          <uix:rowLayout>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="LODESC@partitionsBundle"/>
          </uix:rowLayout>
        </uix:header>

       </uix:stackLayout>
     </uix:case>

     <%-- CASE: Edit partitions --%>
     <uix:case name="false">
       <uix:stackLayout>
         <uix:spacer height="10"/>
       <uix:labeledFieldLayout labelWidth="30%">
         <%-- PARENT OBJECT PARTITIONING METHOD --%>
         <uix:messagePrompt promptBinding="TPMETHOD@partitionsBundle"/>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="objectDisplayType@dataPartitionsBean@servletRequest" />

         <%-- PARTITIONING METHOD --%>
         <uix:messagePrompt promptBinding="PMETHOD@partitionsBundle"/>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="displayType@dataPartitionsBean@servletRequest" />
         <%-- PARTITIONING COLUMNS --%>
         <uix:messagePrompt promptBinding="PCOLS@partitionsBundle"/>
         <uix:styledText styleClass="OraDataText" 
                         textBinding="pcolsList@partitionColsBean@servletRequest" />


       </uix:labeledFieldLayout>

     <%-- SUBPARTITIONING COLUMNS --%>
     <uix:switcher childNameBinding="isObjectComposite@dataPartitionsBean@servletRequest">
       <uix:case name="true">     
         <uix:switcher childNameBinding="isObjectRangeList@dataPartitionsBean@servletRequest">
           <uix:case name="true">  
             <uix:labeledFieldLayout labelWidth="30%">
               <uix:messagePrompt promptBinding="SCOL@partitionsBundle"/>
               <uix:styledText styleClass="OraDataText" 
                               textBinding="scolsList@partitionColsBean@servletRequest" />
             </uix:labeledFieldLayout>
           </uix:case>
           <uix:case name="false">  
             <uix:labeledFieldLayout labelWidth="30%">
              <uix:messagePrompt promptBinding="SCOLS@partitionsBundle"/>
              <uix:styledText styleClass="OraDataText" 
                              textBinding="scolsList@partitionColsBean@servletRequest" />
             </uix:labeledFieldLayout>
           </uix:case>
        </uix:switcher>
      </uix:case>
    </uix:switcher>

    </uix:stackLayout>
    </uix:case>
    </uix:switcher>

    <uix:spacer height="1"/>        
   
    <%-- Indent --%>   
    <uix:rowLayout width="100%">
      <uix:cellFormat> 
        <uix:spacer height="1" width="20" />
      </uix:cellFormat>
      <uix:cellFormat hAlign="right">

    <%-- start : header --%>
    <uix:header textBinding="PARTS@partitionsBundle">
      <uix:spacer height="5"/>   
      <%-- SWITCH: Create partitions --%>
      <uix:switcher childNameBinding="creating@objectBean@servletRequest">

        <%-- CASE: Create partitions --%>
        <uix:case name="true">

          <uix:stackLayout>
        <uix:rowLayout> 
        <uix:stackLayout>

            <uix:radioButton name="localView"
                             onClick="submitForm('indexForm',true,{'event':'changeDefault'})"
                             textBinding="LDEFAULT@partitionsBundle" 
                             value="1"
                             selectedValueBinding="localView@dataPartitionsBean@servletRequest"
                             disabledBinding="partsDisabled@dataPartitionsBean@servletRequest" />

            <uix:radioButton name="localView"
                             onClick="submitForm('indexForm',true,{'event':'changeDefault'})"
                             textBinding="LOVERRIDE@partitionsBundle" 
                             value="0"
                             selectedValueBinding="localView@dataPartitionsBean@servletRequest"
                             disabledBinding="partsDisabled@dataPartitionsBean@servletRequest" />

          </uix:stackLayout>
          </uix:rowLayout> 


      <uix:switcher childNameBinding="usingDefault@dataPartitionsBean@servletRequest">
        <uix:case name="false">
          <uix:stackLayout>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" width="100%">

                <uix:messageLovField name="tablespaceList"
                                         promptBinding="STOREIN@partitionsBundle"
                                         textBinding="tablespaceList@dataPartitionsBean@servletRequest"
                                         disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                         columns="50"
                                         searchDescBinding="SELECT_TS@msgs"
                                         tipBinding="TSTIP@partitionsBundle"
                                         onClick = "appendData();selectMultiple();startLov('tablespaceList', 'ListTablespacePerm')"/>
<%--
                                         onClickBinding="ltblspclistlovdest@servletRequest" />
--%>
              </uix:cellFormat>

              <uix:spacer width="5"/>
              <uix:cellFormat>

                <uix:submitButton textBinding="GO@partitionsBundle" 
                                  shortDescBinding="GO@partitionsBundle" 
                                  name="event" 
                                  disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                  value="setTablespaces"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:spacer height="1"/>

      <oem:table name="dataPartitionsUI" 
                 beanKey="dataPartitionsBean" 
                 formSubmitted="true" 
                 dataSourceProp="dataPartitionsUI" 
                 summaryBinding="PARTITIONS@partitionsBundle"
                 blockSize="10"
                 width="100%"
                 alternateTextBinding="NO_PARTS@partitionsBundle">    

        <uix:tableSelection>
          <oem:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
               selectedIndexBinding="selectedIndex@dataPartitionsBean@servletRequest" >

            <uix:flowLayout>
              <uix:submitButton textBinding="ADVOPT@partitionsBundle" 
                                shortDescBinding="ADVOPT@partitionsBundle" 
                                name="event" 
                                disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                value="advOptions"/>

            </uix:flowLayout>

              <uix:switcher childNameBinding="isObjectComposite@dataPartitionsBean@servletRequest">
                <uix:case name="true">
                  <uix:flowLayout>
                    <uix:spacer width="5"/>
                    <uix:submitButton textBinding="LSUBOVERRIDE@partitionsBundle" 
                                    shortDescBinding="LSUBOVERRIDE@partitionsBundle" 
                                    name="event" 
                                    disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                    value="subpartitions"/>
                  </uix:flowLayout>
                </uix:case>
              </uix:switcher>
          </oem:singleSelection>
        </uix:tableSelection>
      </oem:table>
    </uix:stackLayout>
    </uix:case>
    </uix:switcher>
    </uix:stackLayout> 
    </uix:case>
    </uix:switcher>

            <%-- SWITCH: Create partitions --%>
            <uix:switcher childNameBinding="creating@objectBean@servletRequest">
              <%-- CASE: Edit partitions --%>
              <uix:case name="false">
                <uix:stackLayout>

                <%-- Search Prompt --%>
                <uix:stackLayout renderedBinding="canSearch@dataPartitionsBean@servletRequest" >
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" textBinding="SEARCHPNAME@msgs" labeledNodeId="SEARCHPNAME"/>
                    <uix:spacer height="1" width="5"/>
                    <uix:textInput name="searchPartName" textBinding="searchPartName@dataPartitionsBean@servletRequest" columns="32" id="SEARCHPNAME" shortDescBinding="SEARCHPNAME@msgs"/>
                    <uix:spacer height="1" width="5"/>
                    <uix:submitButton textBinding="GO@msgs" name="event" value="searchPartitions" shortDescBinding="GO@msgs"/>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>
                </uix:stackLayout>
                <%-- End Search Prompt --%>

      <oem:table name="dataPartitionsUI" 
                 beanKey="dataPartitionsBean" 
                 formSubmitted="true" 
                 dataSourceProp="dataPartitionsUI" 
                 summaryBinding="PARTITIONS@partitionsBundle"
                 blockSize="10" 
                 width="100%"
                 alternateTextBinding="NO_PARTS@partitionsBundle">    

        <uix:tableSelection>
          <oem:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
               selectedIndexBinding="selectedIndex@dataPartitionsBean@servletRequest">
            <uix:flowLayout>
              <uix:flowLayout>
                <uix:spacer width="5"/>
                <uix:submitButton textBinding="ADVOPT@partitionsBundle" 
                                  shortDescBinding="ADVOPT@partitionsBundle" 
                                  name="event" 
                                  value="advOptions"/>
              </uix:flowLayout>

              <uix:flowLayout renderedBinding="isObjectComposite@dataPartitionsBean@servletRequest" >
                <uix:spacer width="5"/>
                <uix:submitButton textBinding="SUBPARTITIONS@partitionsBundle" 
                                  shortDescBinding="SUBPARTITIONS@partitionsBundle" 
                                  name="event" 
                                  value="subpartitions"/>
               </uix:flowLayout>

               <uix:spacer width="5"/>
               <uix:messagePrompt promptBinding="ACTIONS@partitionsBundle" labeledNodeId="ACTIONS"/>
               <uix:spacer width="5"/>
               <uix:choice name="actionChoice" id="ACTIONS"
                           selectedValueBinding="selectedAction@dataPartitionsBean@servletRequest">
                 <uix:option textBinding="RENAME@partitionsBundle" value="3" />
                 <uix:option textBinding="REBUILDPART@partitionsBundle" 
                             renderedBinding="canRebuild@dataPartitionsBean@servletRequest"
                             value="4" />
                 <uix:switcher childNameBinding="isObjectComposite@dataPartitionsBean@servletRequest">
                   <uix:case name="false">   
                     <uix:option textBinding="COALESCE@partitionsBundle" value="13" />
                   </uix:case>
                 </uix:switcher>

               </uix:choice>  
               <uix:spacer width="5"/>
               <uix:submitButton textBinding="GO@partitionsBundle" 
                                 shortDescBinding="GO@partitionsBundle" 
                                 name="event" 
                                 value="selectAction" />       
             </uix:flowLayout>
          </oem:singleSelection>
        </uix:tableSelection>
      </oem:table>
      

      
      

      <uix:spacer height="5"/>

    </uix:stackLayout>
    </uix:case>
    </uix:switcher>
    </uix:header>
    </uix:cellFormat>
    </uix:rowLayout>

  <%-- END: TAB CONTENTS ends here --%>   

</uix:buildTree>
       


