<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       indexSubpartitions.jsp
  -- Controller: db/adm/schm/IndexPartitionsController.java
  --
  -- Description: Display partition-level subpartitions for composite 
  --              local index partitions.  
  --              Launched by clicking Subpartitions button after 
  --              selecting a partition.
  --%>
<script language="JavaScript" src="/em/database/LOV.js"></script>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
  
  <%-- Browser title.  Page name from controller getPageHeader() --%>
  <%@ include file="/oemTitle.jspf" %>

  <uix:body>

    <%-- HTML Form --%>
    <db:form name="indexForm" 
             method="post" 
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_IDX_SUB_PG %>"/>
      <uix:pageLayout titleBinding="subHdr@dataPartitionsBean@servletRequest">

        <%-- Oracle Logo and Tabs --%>
        <%@ include file="/database/global.jspf" %>

        <%-- Warning/Error display --%>
        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
				                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:subTabLayout>
          <uix:stackLayout>
           <uix:labeledFieldLayout labelWidth="20%">
             <%-- PARENT OBJECT PARTITIONING METHOD --%>
             <uix:messagePrompt promptBinding="TPMETHOD@msgs"/>
             <uix:styledText styleClass="OraDataText" 
                             textBinding="objectDisplayType@dataPartitionsBean@servletRequest" />

             <%-- PARTITIONING METHOD --%>
             <uix:messagePrompt promptBinding="PMETHOD@msgs"/>
             <uix:styledText styleClass="OraDataText" 
                             textBinding="displayType@dataPartitionsBean@servletRequest" />
             <%-- PARTITIONING COLUMNS --%>
             <uix:messagePrompt promptBinding="PCOLS@msgs"/>
             <uix:styledText styleClass="OraDataText" 
                             textBinding="pcolsList@partitionColsBean@servletRequest" />

           </uix:labeledFieldLayout>
     <%-- SUBPARTITIONING COLUMNS --%>
     <uix:switcher childNameBinding="isObjectComposite@dataPartitionsBean@servletRequest">
       <uix:case name="true">     
         <uix:switcher childNameBinding="isObjectRangeList@dataPartitionsBean@servletRequest">
           <uix:case name="true">  
             <uix:labeledFieldLayout labelWidth="20%">
               <uix:messagePrompt promptBinding="SCOL@msgs"/>
               <uix:styledText styleClass="OraDataText" 
                               textBinding="scolsList@partitionColsBean@servletRequest" />
             </uix:labeledFieldLayout>
           </uix:case>
           <uix:case name="false">  
             <uix:labeledFieldLayout labelWidth="20%">
              <uix:messagePrompt promptBinding="SCOLS@msgs"/>
              <uix:styledText styleClass="OraDataText" 
                              textBinding="scolsList@partitionColsBean@servletRequest" />
             </uix:labeledFieldLayout>
           </uix:case>
        </uix:switcher>
      </uix:case>
    </uix:switcher>

      <uix:spacer height="5"/>

      <%-- START: HEADER (SUBPARTITIONS)--%>
      <uix:header textBinding="SPARTS@msgs">
      <uix:spacer height="5"/>

      <uix:tableLayout>

        <uix:switcher childNameBinding="creating@objectBean@servletRequest">
          <%-- CASE: Not in Create partitions --%>
          <uix:case name="false">
            <uix:stackLayout>

            <%-- Search Prompt --%>
            <uix:stackLayout renderedBinding="canSearch@dataPartitionsBean@servletRequest" >

              <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText" textBinding="SEARCHSNAME@msgs" labeledNodeId="SEARCHSNAME"/>
                <uix:spacer height="1" width="5"/>
                <uix:textInput name="searchSubPartName" textBinding="searchSubPartName@dataPartitionsBean@servletRequest" columns="32" id="SEARCHSNAME" shortDescBinding="SEARCHSNAME@msgs"/>

                <uix:spacer height="1" width="5"/>
                <uix:submitButton textBinding="GO@msgs" name="event" value="searchPartitions" shortDescBinding="GO@msgs"/>
              </uix:rowLayout>
            </uix:stackLayout>

            <uix:rowLayout>
              <uix:spacer height="5"/>
            </uix:rowLayout>
            <%-- End Search Prompt --%>
            </uix:stackLayout>
          </uix:case>

          <uix:case name="true">
            <uix:stackLayout>
            <uix:rowLayout>
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="IDX_SUBPART_INSTR@msgs"/>
            </uix:rowLayout>

            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right" width="100%">
                <uix:messageLovField name="tablespaceListS"
                                         promptBinding="STOREIN@msgs"
                                         textBinding="tablespaceListS@dataPartitionsBean@servletRequest"
                                         disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                         columns="50"
                                         searchDescBinding="SELECT_TS@msgs"
                                         tipBinding="TSTIP@msgs"
                                         onClick = "appendData();selectMultiple();startLov('tablespaceListS', 'ListTablespacePerm')"/>
<%--
                                         onClickBinding="tblspclistlovdest@servletRequest" />
--%>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:submitButton textBinding="GO@msgs" 
                                  shortDescBinding="GO@msgs" 
                                  name="event" 
                                  disabledBinding="partsDisabled@dataPartitionsBean@servletRequest"
                                  value="setSubTablespaces"/>
              </uix:cellFormat>

            </uix:rowLayout>
            </uix:stackLayout>
          </uix:case>
        </uix:switcher>


      <uix:spacer height="5"/>

      <oem:table name="dataSubpartitionsUI" 
                 beanKey="dataPartitionsBean" 
                 formSubmitted="true" 
                 dataSourceProp="dataSubpartitionsUI" 
                 summaryBinding="SUBPARTITIONS@msgs"
                 blockSize="10" 
                 width="100%"
                 alternateTextBinding="NO_SPARTS@msgs">    

        <uix:tableSelection>
          <oem:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
               selectedIndexBinding="selectedIndex2@dataPartitionsBean@servletRequest">
            <uix:flowLayout>

              <uix:spacer width="5"/>
              <uix:submitButton textBinding="ADVOPT@msgs" name="event" value="advOptionsSub" shortDescBinding="ADVOPT@msgs"/>

              <%-- SWITCH: Create/Edit partitions --%>
              <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                <uix:case name="false">
                  <uix:flowLayout>
                  <uix:spacer width="10"/>
                  <uix:messagePrompt promptBinding="ACTIONS@msgs" labeledNodeId="ACTIONS"/>
                  <uix:spacer width="5"/>
                  <uix:choice name="actionChoice" id="ACTIONS"
                              selectedValueBinding="selectedAction@dataPartitionsBean@servletRequest">
                    <uix:option textBinding="RENAME@msgs" value="3" />
                    <uix:option textBinding="REBUILDPART@msgs" value="4" />
                    <uix:option textBinding="COALESCE@msgs" value="13" />
                  </uix:choice>  
                  <uix:spacer width="5"/>
                  <uix:submitButton textBinding="GO@msgs" 
                                    shortDescBinding="GO@msgs" 
                                    name="event" 
                                    value="selectActionSub" />       
                  </uix:flowLayout>
                </uix:case>
              </uix:switcher>
          </uix:flowLayout>
          </oem:singleSelection>
        </uix:tableSelection>
      </oem:table>

      </uix:tableLayout>
      </uix:header>
      <%-- END: HEADER (SUBPARTITIONS)--%>


          </uix:stackLayout>
        </uix:subTabLayout>  

        <uix:pageButtons>
          <uix:pageButtonBar>

            <%-- SHOW SQL BUTTON --%>
            <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" 
                              shortDescBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                              name="event" 
                              value="showSql" />

            <%-- CANCEL BUTTON --%>
            <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                              shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
                              name="event" 
                              value="cancelSubs" />

            <%-- OK BUTTON --%>
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                              shortDescBinding="OK@uixDBObjectBundle@servletRequest"
                              name="event" 
                              value="finishSubs" />
            </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
    </db:form>
    <%-- END: HTML Form --%>

  </uix:body>

  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
