<%--
  -- Page:        partitionsTable.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Partitions table included into partitioning wizard
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  05/17/05 - fix oac violations 
  --     mpawelko  07/20/04 - try to use generic LOVs from oem:table 
  --     chanchan  10/08/03 - Add ADA supports 
  --     mpawelko  08/20/03 - GUI changes 
  --     mpawelko  08/01/03 - fix add partition
  --     mpawelko  05/16/03 - show Advanced Options on Create
  --     mpawelko  05/02/03 - disable add if MAXVALUE or DEFAULT
  --     mpawelko  03/26/03 - disable Delete
  --     mpawelko  03/19/03 - get options right
  --     jochen    01/02/03 - No advanced options only for subpartitions
  --     jochen    12/23/02 - No advanced options for 9iR2+
  --     mpawelko  12/09/02 - Need db tags for LOV fields
  --     jochen    11/22/02 - No subpartitions buttons in wizard
  --     jochen    11/19/02 - jochen_partition
  --              Cloned from dataPartitionsR.jsp
  --%>
<script language="JavaScript" src="/em/database/LOV.js"></script>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/utils.js"/>

<uix:buildTree nodeID="partitionsTable">

  <oem:table name="dataPartitionsUI"
             beanKey="dataPartitionsBean"
             formSubmitted="true"
             dataSourceProp="dataPartitionsUI"
             summaryBinding="PARTITIONS@msgs"
             blockSize="10" 
             width="100%"
             alternateTextBinding="NO_PARTS@msgs">

    <uix:tableSelection>
      <oem:singleSelection
          selectedIndexBinding="selectedIndex@dataPartitionsBean@servletRequest" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest">
        <uix:submitButton textBinding="ADVOPT@msgs" shortDescBinding="ADVOPT@msgs"
                          name="event"
                          value="advOptions"/>

        <%-- SWITCH: Subpartitions --%>
        <uix:switcher childNameBinding="isComposite@dataPartitionsBean@servletRequest">
          <%-- CASE: Composite partitions --%>
          <uix:case name="true">
            <uix:flowLayout renderedBinding="notInWizard@partWizardBean@servletRequest">
              <uix:spacer width="5"/>
              <uix:submitButton textBinding="SUBPARTITIONS@msgs" shortDescBinding="SUBPARTITIONS@msgs"
                                name="event"
                                value="subpartitions"/>
            </uix:flowLayout>
          </uix:case>
        </uix:switcher>

        <%-- SWITCH: Create partitions --%>
        <uix:switcher childNameBinding="creating@objectBean@servletRequest">
          <%-- CASE: Create partitions --%>
          <uix:case name="true">
            <uix:flowLayout>
              <uix:spacer width="5"/>
              <uix:submitButton textBinding="INSERT@msgs" name="event" value="insertPartition" shortDescBinding="INSERT@msgs"/>
            </uix:flowLayout>
          </uix:case>
        </uix:switcher>

        <uix:spacer width="5"/>

        <uix:submitButton textBinding="DELETE@msgs" shortDescBinding="DELETE@msgs"
                          name="event" 
                          disabledBinding="disableDelete@dataPartitionsBean@servletRequest"
                          value="deletePartition"/>
      </oem:singleSelection>
    </uix:tableSelection>

    <uix:footer>
      <uix:submitButton textBinding="ADDAP@msgs" shortDescBinding="ADDAP@msgs"
                        name="event"
                        value="doAddPartition"
                        renderedBinding="canAdd@dataPartitionsBean@servletRequest"/>
    </uix:footer>
  </oem:table>

  <uix:spacer height="5"/>

  <uix:switcher childNameBinding="ptype@partWizardBean@servletRequest">

    <%-- Hash partitioning --%>
    <uix:case name="1">
      <uix:spacer height="1"/>
    </uix:case>

    <%-- List partitioning --%>
    <uix:case name="2">
        <uix:tip renderedBinding="canUseDef@dataPartitionsBean@servletRequest">
          <uix:styledText textBinding="L_DEF_TIP@msgs"
                          styleClass="OraTipText"/>
        </uix:tip>
    </uix:case>

    <%-- Range, Range-List, Range-Hash partitioning --%>
    <uix:default>
      <uix:stackLayout>
        <uix:tip renderedBinding="canUseMax@dataPartitionsBean@servletRequest">
          <uix:styledText textBinding="R_MAX_TIP@msgs"
                          styleClass="OraTipText"/>
        </uix:tip>
      </uix:stackLayout>
    </uix:default>
  </uix:switcher>

</uix:buildTree>

