<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       placeLocalIndexStorage.jsp
  -- Controller: db/adm/schm/DataPartitionsController.java
  --
  -- Description: Storage attributes for placing local indexes
  --              This page allows the user to view/edit the various
  --              storage options for individual local index partitions
  --              that will be created automatically when additional
  --              table partitions are created as the result of an
  --              ADD/SPLIT/MERGE/MOVE PMOP.
  --              Launched by the Advanced Options button from the 
  --              Place Local Indexes page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">

  <uix:bundle name="pmsgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
  
    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <%-- HTML Form --%>
      <db:form name="tblForm" 
               method="post" 
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,cancelURL,sname,oname,otype">
        <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_PLI_STORAGE_PG %>"/>
        <uix:pageLayout titleBinding="PLIStorageHdr@dataPartitionsBean@servletRequest">

          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>

          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-- Create/Edit/View Header --%>
          <uix:subTabLayout>

            <%-- START: LOCAL INDEX PARTITION STORAGE PAGE starts here --%>

            <uix:dataScope currentDataBinding="pSegmentPLIBean@servletRequest">
              <jsp:include page="/database/schema/utilities/storageContextInclude.jsp" />
              <uix:ref refID="storageInclude" />

            </uix:dataScope>

            <uix:spacer height="10" />

            <%-- END:  LOCAL INDEX PARTITION STORAGE PAGE ends here --%>   

          </uix:subTabLayout>  

          <uix:pageButtons>
            <uix:pageButtonBar>

            <%-- CANCEL BUTTON --%>
            <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                              shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
                          renderedBinding="canEditOpts@dataPartitionsBean@servletRequest"
                          name="event" 
                          value="cancelPLIStorage" />
            <%-- OK BUTTON --%>
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                              shortDescBinding="OK@uixDBObjectBundle@servletRequest"
                          name="event" 
                          value="finishPLIStorage" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
      <%-- END: HTML Form --%>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
